/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.blocks;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedBlocksEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class SetBlockBiomeAction
extends WorldAction {
    public SetBlockBiomeAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        Biome biome;
        List<Location> locations = this.getArguments().getLocationList("locations", this);
        String biomeString = this.getArguments().getValue("biome", "plains", (Action)this);
        try {
            biome = Biome.valueOf((String)biomeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            biome = Biome.PLAINS;
        }
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                SetBlockBiomeAction.this.getPlanet().getLimits().setLastModifiedBlocksAmount(0);
            }
        };
        this.getPlanet().getTerritory().addBukkitRunnable(runnable);
        for (Location location : locations) {
            if (this.getPlanet().getLimits().getLastModifiedBlocksAmount() > this.getPlanet().getLimits().getModifyingBlocksLimit()) {
                runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
                this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
                new LimitReachedBlocksEvent(this.getPlanet()).callEvent();
                return;
            }
            location.getBlock().setBiome(biome);
            this.getPlanet().getLimits().setLastModifiedBlocksAmount(this.getPlanet().getLimits().getLastModifiedBlocksAmount() + 1);
        }
        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
        this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SET_BLOCK_BIOME;
    }
}

