/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.blocks;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedBlocksEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.planets.PlanetRunnable;

public final class SetBlockTypeAction
extends WorldAction {
    public SetBlockTypeAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        List<Location> locations = this.getArguments().getLocationList("locations", this);
        Material material = this.getArguments().getValue("type", Material.AIR, (Action)this);
        PlanetRunnable planetRunnable = new PlanetRunnable(this.getPlanet()){

            @Override
            public void execute() {
                SetBlockTypeAction.this.getPlanet().getLimits().setLastModifiedBlocksAmount(0);
            }
        };
        for (Location location : locations) {
            if (this.getPlanet().getLimits().getLastModifiedBlocksAmount() > this.getPlanet().getLimits().getModifyingBlocksLimit()) {
                this.getPlanet().getTerritory().scheduleAsyncRunnable(planetRunnable, 20L);
                new LimitReachedBlocksEvent(this.getPlanet()).callEvent();
                return;
            }
            switch (material) {
                case WATER_BUCKET: {
                    Material material2 = Material.WATER;
                    break;
                }
                case LAVA_BUCKET: {
                    Material material2 = Material.LAVA;
                    break;
                }
                case POWDER_SNOW_BUCKET: {
                    Material material2 = Material.POWDER_SNOW;
                    break;
                }
                case FLINT_AND_STEEL: {
                    Material material2 = Material.FIRE;
                    break;
                }
                default: {
                    Material material2 = material = material;
                }
            }
            if (material.isBlock()) {
                location.getBlock().setType(material);
            }
            this.getPlanet().getLimits().setLastModifiedBlocksAmount(this.getPlanet().getLimits().getLastModifiedBlocksAmount() + 1);
        }
        this.getPlanet().getTerritory().scheduleAsyncRunnable(planetRunnable, 20L);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SET_BLOCK_TYPE;
    }
}

