/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.entity;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class SpawnEntityAction
extends WorldAction {
    public SpawnEntityAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        EntityType type;
        String customName = this.getArguments().getValue("name", "", (Action)this);
        boolean ai = this.getArguments().getValue("ai", true, (Action)this);
        boolean gravity = this.getArguments().getValue("gravity", true, (Action)this);
        boolean glowing = this.getArguments().getValue("glowing", false, (Action)this);
        boolean invisible = this.getArguments().getValue("invisible", false, (Action)this);
        boolean invulnerable = this.getArguments().getValue("invulnerable", false, (Action)this);
        boolean customNameVisible = this.getArguments().getValue("show-name", true, (Action)this);
        boolean visibleByDefault = this.getArguments().getValue("visible-for-all", true, (Action)this);
        ItemStack spawnEgg = this.getArguments().getValue("type", new ItemStack(Material.AIR), (Action)this);
        String typeString = spawnEgg.getType() != Material.AIR && spawnEgg.getType().name().endsWith("_SPAWN_EGG") ? spawnEgg.getType().name().replace("_SPAWN_EGG", "") : this.getArguments().getValue("type", "chicken", (Action)this);
        try {
            type = EntityType.valueOf((String)typeString);
        }
        catch (IllegalArgumentException e) {
            type = EntityType.CHICKEN;
        }
        if (this.isBannedEntity(type)) {
            throw new IllegalArgumentException("Cannot spawn " + type.name() + ", because it's disallowed entity type.");
        }
        for (Location location : this.getArguments().getLocationList("locations", this)) {
            Entity spawnedEntity = this.getPlanet().getTerritory().getWorld().spawnEntity(location, type);
            spawnedEntity.setGravity(gravity);
            if (!customName.isEmpty()) {
                spawnedEntity.setCustomName(customName);
            }
            spawnedEntity.setGlowing(glowing);
            spawnedEntity.setInvisible(invisible);
            spawnedEntity.setInvulnerable(invulnerable);
            spawnedEntity.setCustomNameVisible(customNameVisible);
            spawnedEntity.setVisibleByDefault(visibleByDefault);
            if (!(spawnedEntity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)spawnedEntity;
            living.setAI(ai);
        }
    }

    public boolean isBannedEntity(EntityType type) {
        return switch (type) {
            case EntityType.PLAYER, EntityType.ITEM, EntityType.LIGHTNING_BOLT -> true;
            default -> false;
        };
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SPAWN_ENTITY;
    }
}

