/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.world;

import org.bukkit.WorldBorder;
import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class SetWorldBorderAction
extends WorldAction {
    public SetWorldBorderAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        double radius = this.getArguments().getValue("radius", this.getWorld() == null ? 10.0 : this.getWorld().getWorldBorder().getSize(), (Action)this);
        int time = this.getArguments().getValue("time", 0, (Action)this);
        int warningDistance = this.getArguments().getValue("warning-distance", 5, (Action)this);
        int warningTime = this.getArguments().getValue("warning-time", 15, (Action)this);
        double damage = this.getArguments().getValue("damage", 0.2, (Action)this);
        int safeDistance = this.getArguments().getValue("safe-distance", 5, (Action)this);
        WorldBorder border = this.getWorld().getWorldBorder();
        border.setSize(Math.min((double)this.getPlanet().getTerritory().getWorldSize(), radius), (long)time);
        border.setWarningTime(warningTime);
        border.setWarningDistance(warningDistance);
        border.setDamageAmount(damage);
        border.setDamageBuffer((double)safeDistance);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_SET_WORLD_BORDER;
    }
}

