/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.world;

import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.VariableTransferEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.planets.Planet;

public final class TransferVariableAction
extends WorldAction {
    public TransferVariableAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!(this.getArguments().pathExists("world") && this.getArguments().pathExists("key") && this.getArguments().pathExists("value"))) {
            return;
        }
        String worldId = this.getArguments().getValue("world", "0", (Action)this);
        Planet planet = OpenCreative.getPlanetsManager().getPlanetById(worldId);
        if (planet == null) {
            return;
        }
        if (!planet.isLoaded()) {
            return;
        }
        if (!planet.isOwner(this.getPlanet().getOwner())) {
            return;
        }
        String key = this.getArguments().getValue("key", "key", (Action)this);
        String value = this.getArguments().getValue("value", "value", (Action)this);
        new VariableTransferEvent(planet, key, value).callEvent();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_TRANSFER_VARIABLE;
    }
}

