/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.world.phys.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.utils.millennium.math.AxisAlignedBB;
import ua.mcchickenstudio.opencreative.utils.millennium.math.BuildSpeed;
import ua.mcchickenstudio.opencreative.utils.millennium.math.Euler;
import ua.mcchickenstudio.opencreative.utils.millennium.math.FastMath;
import ua.mcchickenstudio.opencreative.utils.millennium.math.GeneralMath;
import ua.mcchickenstudio.opencreative.utils.millennium.math.Interpolation;
import ua.mcchickenstudio.opencreative.utils.millennium.math.MovingObjectPosition;
import ua.mcchickenstudio.opencreative.utils.millennium.math.RayTrace;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec2;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec3;

public class PhysObject {
    private static final double BOX_SIZE = 0.5;
    private boolean living = true;
    private World world;
    private Particle mainParticle;
    private Particle subParticle;
    private Particle hitParticle;
    private int count;
    private int i1;
    private int i2;
    private int i3;
    private int hitCount;
    private Location location;
    public double speed;
    public double weight;
    public double speedAccel;
    public double speedLimit;
    public double weightAccel;
    public double weightLimit;
    public double damage;
    public double explosion;
    public double shockwaveRadius;
    public double shockwavePower;
    private final List<PotionEffect> potionEffect;
    public int timeExist = 0;

    public void tick() {
        ++this.timeExist;
        if (this.timeExist > 800) {
            this.living = false;
        }
        if (!this.living) {
            return;
        }
        Location old = this.location.clone();
        this.applyMotion();
        if (this.checkBlockCollision(old) || this.checkEntityCollision(old)) {
            this.living = false;
        } else {
            this.world.spawnParticle(this.mainParticle, this.location, this.count, (double)this.i1, (double)this.i2, (double)this.i3);
            if (this.subParticle != null) {
                this.world.spawnParticle(this.subParticle, this.location, this.count, (double)this.i1, (double)this.i2, (double)this.i3);
            }
        }
    }

    public void applyMotion() {
        float yaw = this.location.getYaw();
        float pitch = this.location.getPitch();
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        double x = -Math.cos(pitchRad) * Math.sin(yawRad);
        double y = -Math.sin(pitchRad);
        double z = Math.cos(pitchRad) * Math.cos(yawRad);
        this.location.add(new Vector(x, y, z).multiply(this.speed));
        this.location.add(0.0, -this.weight, 0.0);
        this.speed += this.speedAccel;
        if (this.speed > this.speedLimit) {
            this.speed = this.speedLimit;
        } else if (this.speed < 0.0) {
            this.speed = 0.0;
        }
        this.weight += this.weightAccel;
        if (this.weight > this.weightLimit) {
            this.weight = this.weightLimit;
        } else if (this.weight < 0.0) {
            this.weight = 0.0;
        }
    }

    public boolean checkEntityCollision(Location from) {
        List<Entity> entities = PhysObject.getEntitiesAroundPoint(this.location, this.speed + 0.5);
        Vec3 fromVec = new Vec3(from.getX(), from.getY(), from.getZ());
        double closest = 999.0;
        LivingEntity closestEntity = null;
        Vec3 closestHit = new Vec3(0.0, 0.0, 0.0);
        for (Entity entity : entities) {
            double dist;
            Location l = entity.getLocation();
            if (!(entity instanceof LivingEntity)) continue;
            AxisAlignedBB bb = new AxisAlignedBB(l.getX() - 0.3, l.getY() - 0.1, l.getZ() - 0.3, l.getX() + 0.3, l.getY() + 1.9, l.getZ() + 0.3);
            MovingObjectPosition result = RayTrace.rayCast(l.getYaw(), this.location.getPitch(), bb, fromVec, this.speed + 0.1, BuildSpeed.FAST);
            if (result == null || !((dist = fromVec.distanceTo(result.hitVec)) < closest)) continue;
            closest = dist;
            closestEntity = (LivingEntity)entity;
            closestHit = result.hitVec;
        }
        if (closestEntity != null) {
            Location hitLoc = new Location(this.world, closestHit.xCoord, closestHit.yCoord, closestHit.zCoord);
            LivingEntity finalClosestEntity = closestEntity;
            this.shockwave(hitLoc, entities);
            Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> {
                finalClosestEntity.damage(this.damage);
                if (this.potionEffect != null) {
                    finalClosestEntity.addPotionEffects(this.potionEffect);
                }
                this.world.spawnParticle(this.hitParticle, hitLoc, this.hitCount);
                if (this.explosion > 0.0) {
                    this.world.createExplosion(hitLoc, (float)this.explosion);
                }
            });
        }
        return false;
    }

    public boolean checkBlockCollision(Location from) {
        HashSet<AxisAlignedBB> boxes = new HashSet<AxisAlignedBB>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Location l = this.location.clone().add((double)x, (double)y, (double)z);
                    Block block = this.world.getBlockAt(l);
                    if (block.getType().name().equals("AIR")) continue;
                    Location b = new Location(this.world, (double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5);
                    boxes.add(new AxisAlignedBB(b.getX() - 0.5, b.getY() - 0.5, b.getZ() - 0.5, b.getX() + 0.5, b.getY() + 0.5, b.getZ() + 0.5));
                }
            }
        }
        if (boxes.isEmpty()) {
            return false;
        }
        Vec3 fromVec = new Vec3(from.getX(), from.getY(), from.getZ());
        double closest = 999.0;
        Vec3 closestDist = new Vec3(0.0, 0.0, 0.0);
        for (AxisAlignedBB bb : boxes) {
            double dist;
            MovingObjectPosition result = RayTrace.rayCast(this.location.getYaw(), this.location.getPitch(), bb, fromVec, this.speed + 0.3, BuildSpeed.FAST);
            if (result == null || !((dist = fromVec.distanceTo(result.hitVec)) < closest)) continue;
            closest = dist;
            closestDist = result.hitVec;
        }
        if (closest < 100.0) {
            Location hitLoc = new Location(this.world, closestDist.xCoord, closestDist.yCoord, closestDist.zCoord);
            this.shockwave(hitLoc, null);
            Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> {
                this.world.spawnParticle(this.hitParticle, hitLoc, this.hitCount);
                if (this.explosion > 0.0) {
                    this.world.createExplosion(hitLoc, (float)this.explosion);
                }
            });
            return true;
        }
        return false;
    }

    private void shockwave(Location to, List<Entity> saved) {
        List<Entity> entities;
        List<Entity> list = entities = saved != null ? saved : PhysObject.getEntitiesAroundPoint(to, this.shockwaveRadius + 0.3);
        if (this.shockwaveRadius < 1.0E-7 || this.shockwavePower < 1.0E-7) {
            return;
        }
        for (Entity entity : entities) {
            Location l = entity.getLocation();
            if (!(entity instanceof LivingEntity)) continue;
            double delta = l.getY() - to.getY();
            double calculateRealisticVertical = delta >= 1.0 ? 0.0 : Interpolation.interpolate(0.5, 1.0, delta, Interpolation.Type.BACK, Interpolation.Ease.OUT);
            Vec2 vec = Euler.calculateVec2Vec(new Vec3(to.toVector()), new Vec3(l.clone().add(0.0, calculateRealisticVertical, 0.0).toVector()));
            Vector velo = new Vector(-GeneralMath.sin((float)Math.toRadians(vec.getX()), BuildSpeed.FAST), -GeneralMath.sin((float)Math.toRadians(vec.getY()), BuildSpeed.FAST), GeneralMath.cos((float)Math.toRadians(vec.getX()), BuildSpeed.FAST)).multiply((this.shockwavePower + 1.0) / 5.0);
            double interpolatePitch = 1.0 - Math.abs(vec.getY()) / 90.0;
            velo.setX(velo.getX() * 3.0 * interpolatePitch);
            velo.setZ(velo.getZ() * 3.0 * interpolatePitch);
            double delta2 = l.distance(to) / this.shockwaveRadius;
            double calculateRealisticHorizontal = Interpolation.interpolate(1.0, 0.25, delta2, Interpolation.Type.BACK, Interpolation.Ease.OUT);
            velo.setX(velo.getX() * calculateRealisticHorizontal);
            velo.setZ(velo.getZ() * calculateRealisticHorizontal);
            entity.setVelocity(velo);
        }
    }

    public PhysObject(World world, List<?> visual, List<?> motion, List<?> settings) {
        this.world = world;
        this.mainParticle = (Particle)visual.get(0);
        this.subParticle = visual.get(1) instanceof Particle ? (Particle)visual.get(1) : null;
        this.count = ((Number)visual.get(2)).intValue();
        this.i1 = ((Number)visual.get(3)).intValue();
        this.i2 = ((Number)visual.get(4)).intValue();
        this.i3 = ((Number)visual.get(5)).intValue();
        this.hitParticle = (Particle)visual.get(6);
        this.hitCount = ((Number)visual.get(7)).intValue();
        this.location = (Location)motion.get(0);
        this.speed = ((Number)motion.get(1)).doubleValue();
        this.weight = ((Number)motion.get(2)).doubleValue();
        this.speedAccel = ((Number)motion.get(3)).doubleValue();
        this.speedLimit = ((Number)motion.get(4)).doubleValue();
        this.weightAccel = ((Number)motion.get(5)).doubleValue();
        this.weightLimit = ((Number)motion.get(6)).doubleValue();
        this.damage = ((Number)settings.get(0)).doubleValue();
        this.explosion = ((Number)settings.get(1)).doubleValue();
        this.potionEffect = settings.get(2) instanceof ItemStack ? PhysObject.getPotionEffects((ItemStack)settings.get(2)) : null;
        this.shockwaveRadius = ((Number)settings.get(3)).doubleValue();
        this.shockwavePower = ((Number)settings.get(4)).doubleValue();
    }

    private static List<Entity> getEntitiesAroundPoint(Location location, double radius) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        World world = location.getWorld();
        int smallX = FastMath.floor((location.getX() - radius) / 16.0);
        int bigX = FastMath.floor((location.getX() + radius) / 16.0);
        int smallZ = FastMath.floor((location.getZ() - radius) / 16.0);
        int bigZ = FastMath.floor((location.getZ() + radius) / 16.0);
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                if (!world.isChunkLoaded(x, z)) continue;
                entities.addAll(Arrays.asList(world.getChunkAt(x, z).getEntities()));
            }
        }
        entities.removeIf(entity -> entity.getLocation().distanceSquared(location) > radius * radius);
        return entities;
    }

    private static List<PotionEffect> getPotionEffects(ItemStack item) {
        if (item == null || item.getType() != Material.POTION) {
            return List.of();
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return List.of();
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        return potionMeta.getCustomEffects();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysObject)) {
            return false;
        }
        PhysObject other = (PhysObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLiving() != other.isLiving()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getI1() != other.getI1()) {
            return false;
        }
        if (this.getI2() != other.getI2()) {
            return false;
        }
        if (this.getI3() != other.getI3()) {
            return false;
        }
        if (this.getHitCount() != other.getHitCount()) {
            return false;
        }
        if (Double.compare(this.speed, other.speed) != 0) {
            return false;
        }
        if (Double.compare(this.weight, other.weight) != 0) {
            return false;
        }
        if (Double.compare(this.speedAccel, other.speedAccel) != 0) {
            return false;
        }
        if (Double.compare(this.speedLimit, other.speedLimit) != 0) {
            return false;
        }
        if (Double.compare(this.weightAccel, other.weightAccel) != 0) {
            return false;
        }
        if (Double.compare(this.weightLimit, other.weightLimit) != 0) {
            return false;
        }
        if (Double.compare(this.damage, other.damage) != 0) {
            return false;
        }
        if (Double.compare(this.explosion, other.explosion) != 0) {
            return false;
        }
        if (Double.compare(this.shockwaveRadius, other.shockwaveRadius) != 0) {
            return false;
        }
        if (Double.compare(this.shockwavePower, other.shockwavePower) != 0) {
            return false;
        }
        if (this.timeExist != other.timeExist) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        Particle this$mainParticle = this.getMainParticle();
        Particle other$mainParticle = other.getMainParticle();
        if (this$mainParticle == null ? other$mainParticle != null : !this$mainParticle.equals(other$mainParticle)) {
            return false;
        }
        Particle this$subParticle = this.getSubParticle();
        Particle other$subParticle = other.getSubParticle();
        if (this$subParticle == null ? other$subParticle != null : !this$subParticle.equals(other$subParticle)) {
            return false;
        }
        Particle this$hitParticle = this.getHitParticle();
        Particle other$hitParticle = other.getHitParticle();
        if (this$hitParticle == null ? other$hitParticle != null : !this$hitParticle.equals(other$hitParticle)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        List<PotionEffect> this$potionEffect = this.getPotionEffect();
        List<PotionEffect> other$potionEffect = other.getPotionEffect();
        return !(this$potionEffect == null ? other$potionEffect != null : !((Object)this$potionEffect).equals(other$potionEffect));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PhysObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLiving() ? 79 : 97);
        result = result * 59 + this.getCount();
        result = result * 59 + this.getI1();
        result = result * 59 + this.getI2();
        result = result * 59 + this.getI3();
        result = result * 59 + this.getHitCount();
        long $speed = Double.doubleToLongBits(this.speed);
        result = result * 59 + (int)($speed >>> 32 ^ $speed);
        long $weight = Double.doubleToLongBits(this.weight);
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        long $speedAccel = Double.doubleToLongBits(this.speedAccel);
        result = result * 59 + (int)($speedAccel >>> 32 ^ $speedAccel);
        long $speedLimit = Double.doubleToLongBits(this.speedLimit);
        result = result * 59 + (int)($speedLimit >>> 32 ^ $speedLimit);
        long $weightAccel = Double.doubleToLongBits(this.weightAccel);
        result = result * 59 + (int)($weightAccel >>> 32 ^ $weightAccel);
        long $weightLimit = Double.doubleToLongBits(this.weightLimit);
        result = result * 59 + (int)($weightLimit >>> 32 ^ $weightLimit);
        long $damage = Double.doubleToLongBits(this.damage);
        result = result * 59 + (int)($damage >>> 32 ^ $damage);
        long $explosion = Double.doubleToLongBits(this.explosion);
        result = result * 59 + (int)($explosion >>> 32 ^ $explosion);
        long $shockwaveRadius = Double.doubleToLongBits(this.shockwaveRadius);
        result = result * 59 + (int)($shockwaveRadius >>> 32 ^ $shockwaveRadius);
        long $shockwavePower = Double.doubleToLongBits(this.shockwavePower);
        result = result * 59 + (int)($shockwavePower >>> 32 ^ $shockwavePower);
        result = result * 59 + this.timeExist;
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        Particle $mainParticle = this.getMainParticle();
        result = result * 59 + ($mainParticle == null ? 43 : $mainParticle.hashCode());
        Particle $subParticle = this.getSubParticle();
        result = result * 59 + ($subParticle == null ? 43 : $subParticle.hashCode());
        Particle $hitParticle = this.getHitParticle();
        result = result * 59 + ($hitParticle == null ? 43 : $hitParticle.hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        List<PotionEffect> $potionEffect = this.getPotionEffect();
        result = result * 59 + ($potionEffect == null ? 43 : ((Object)$potionEffect).hashCode());
        return result;
    }

    @Generated
    public boolean isLiving() {
        return this.living;
    }

    @Generated
    public World getWorld() {
        return this.world;
    }

    @Generated
    public Particle getMainParticle() {
        return this.mainParticle;
    }

    @Generated
    public Particle getSubParticle() {
        return this.subParticle;
    }

    @Generated
    public Particle getHitParticle() {
        return this.hitParticle;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public int getI1() {
        return this.i1;
    }

    @Generated
    public int getI2() {
        return this.i2;
    }

    @Generated
    public int getI3() {
        return this.i3;
    }

    @Generated
    public int getHitCount() {
        return this.hitCount;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public List<PotionEffect> getPotionEffect() {
        return this.potionEffect;
    }
}

