/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.world.phys.data;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.world.phys.data.PhysObject;
import ua.mcchickenstudio.opencreative.utils.async.AsyncScheduler;
import ua.mcchickenstudio.opencreative.utils.millennium.types.EvictingList;

public final class PhysService {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(40, new ThreadFactoryBuilder().setNameFormat("opencreative-phys-thread-%d").build());
    private static final Map<Integer, List<PhysObject>> objects = new ConcurrentHashMap<Integer, List<PhysObject>>();

    public static void add(PhysObject object, int limit) {
        World world = object.getWorld();
        int hash = Objects.hashCode(world.getName());
        if (!objects.containsKey(hash)) {
            objects.put(hash, new EvictingList(limit));
        }
        objects.get(hash).add(object);
    }

    public static void run() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)OpenCreative.getPlugin(), () -> AsyncScheduler.run(() -> {
            for (List<PhysObject> objects : objects.values()) {
                if (objects.isEmpty()) continue;
                HashSet<PhysObject> toDelete = new HashSet<PhysObject>();
                for (PhysObject object : objects) {
                    object.tick();
                    if (object.isLiving()) continue;
                    toDelete.add(object);
                }
                objects.removeAll(toDelete);
            }
        }, scheduler), 1L, 1L);
    }

    @Generated
    private PhysService() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

