/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.values.EventValue;
import ua.mcchickenstudio.opencreative.coding.values.EventValues;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public abstract class Condition
extends Action {
    private final List<Action> actions = new ArrayList<Action>();
    private final List<Action> reactions = new ArrayList<Action>();
    private final boolean isOpposed;

    public Condition(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args);
        this.isOpposed = isOpposed;
        this.actions.addAll(actions);
        this.reactions.addAll(reactions);
    }

    public abstract boolean check(Entity var1);

    @Override
    public void prepareAndExecute(ActionsHandler handler) {
        this.handler = handler;
        this.event = this.getExecutor().getEvent();
        ErrorUtils.sendCodingDebugAction(this);
        boolean check = false;
        if (this.getTargets().isEmpty()) {
            return;
        }
        Iterator<Entity> iterator = this.getTargets().iterator();
        while (iterator.hasNext()) {
            Entity entity;
            this.entity = entity = iterator.next();
            if (this.getActionType().isSelectionMustBeInWorld() && (entity == null || entity.getWorld() != this.getPlanet().getTerritory().getWorld()) || !this.check(entity)) continue;
            check = true;
        }
        ErrorUtils.sendCodingDebugLog(this.getPlanet(), MessageUtils.getLocaleMessage("coding-debug.condition.returned-" + check, false).replace("%type%", this.getActionType().getLocaleName()));
        if (check ^ this.isOpposed) {
            new ActionsHandler(this).executeActions(this.actions);
        } else {
            new ActionsHandler(this).executeActions(this.reactions);
        }
    }

    @Override
    protected void execute(Entity entity) {
    }

    @Override
    public abstract ActionCategory getActionCategory();

    public List<Action> getActions() {
        return this.actions;
    }

    public boolean isOpposed() {
        return this.isOpposed;
    }

    @Nullable
    protected Object getEventValue(@NotNull Class<? extends EventValue> clazz) {
        if (clazz == null) {
            Condition.$$$reportNull$$$0(0);
        }
        return EventValues.getInstance().getValue(clazz, this.handler, (Action)this, this.getEntity());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "ua/mcchickenstudio/opencreative/coding/blocks/conditions/Condition", "getEventValue"));
    }
}

