/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions.entityconditions.params;

import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.entityconditions.EntityCondition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public class IsEntityInTeam
extends EntityCondition {
    public IsEntityInTeam(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args, actions, reactions, isOpposed);
    }

    @Override
    public boolean check(Entity entity) {
        if (!this.getArguments().pathExists("scoreboard") || !this.getArguments().pathExists("team")) {
            return false;
        }
        String scoreboardName = this.getArguments().getValue("scoreboard", "board", (Action)this);
        String teamName = this.getArguments().getValue("team", "team", (Action)this);
        Scoreboard scoreboard = this.getPlanet().getTerritory().getScoreboards().get(scoreboardName.toLowerCase());
        if (scoreboard == null) {
            return false;
        }
        Team team = scoreboard.getTeam(teamName);
        if (team != null) {
            return team.hasEntity(entity);
        }
        return false;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.IF_ENTITY_IS_IN_RAIN;
    }
}

