/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.blocks;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.playerconditions.PlayerCondition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public class IsLookingAtBlockCondition
extends PlayerCondition {
    public IsLookingAtBlockCondition(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args, actions, reactions, isOpposed);
    }

    @Override
    public boolean checkPlayer(Player player) {
        List<ItemStack> blocks = this.getArguments().getItemList("blocks", this);
        List<Location> locations = this.getArguments().getLocationList("locations", this);
        if (blocks.isEmpty() && locations.isEmpty()) {
            return false;
        }
        Block block = player.getTargetBlockExact(30);
        if (block == null) {
            return false;
        }
        Material blockType = block.getType();
        for (ItemStack checkBlock : blocks) {
            if (blockType != checkBlock.getType()) continue;
            return true;
        }
        double radius = this.getArguments().getValue("radius", 0.5, (Action)this);
        Location location = block.getLocation();
        for (Location checkLocation : locations) {
            if (!(location.distance(checkLocation) <= radius)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.IF_PLAYER_LOOKS_AT_BLOCK;
    }
}

