/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.conditions.variableconditions.item;

import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.variableconditions.VariableCondition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public class VarItemHasEnchantments
extends VariableCondition {
    public VarItemHasEnchantments(Executor executor, Target target, int x, Arguments args, List<Action> actions, List<Action> reactions, boolean isOpposed) {
        super(executor, target, x, args, actions, reactions, isOpposed);
    }

    @Override
    public boolean check(Entity entity) {
        ItemStack item = this.getArguments().getValue("item", new ItemStack(Material.APPLE), (Action)this);
        ItemStack enchantedBook = this.getArguments().getValue("enchantment", new ItemStack(Material.ENCHANTED_BOOK), (Action)this);
        boolean requireAllEnchants = this.getArguments().getValue("all", true, (Action)this);
        String levelCheckMode = this.getArguments().getValue("level-check", "exact", (Action)this);
        if (!item.hasItemMeta() || !enchantedBook.hasItemMeta()) {
            return false;
        }
        ItemMeta itemMeta = enchantedBook.getItemMeta();
        if (!(itemMeta instanceof EnchantmentStorageMeta)) {
            return false;
        }
        EnchantmentStorageMeta bookMeta = (EnchantmentStorageMeta)itemMeta;
        Map requiredEnchantments = bookMeta.getStoredEnchants();
        if (requiredEnchantments.isEmpty()) {
            return false;
        }
        int matches = 0;
        for (Map.Entry entry : requiredEnchantments.entrySet()) {
            boolean levelMatches;
            Enchantment enchantment = (Enchantment)entry.getKey();
            int requiredLevel = (Integer)entry.getValue();
            if (!item.containsEnchantment(enchantment)) continue;
            if (!(levelMatches = (switch (levelCheckMode) {
                case "exact" -> {
                    if (item.getEnchantmentLevel(enchantment) == requiredLevel) {
                        yield true;
                    }
                    yield false;
                }
                case "min-level" -> {
                    if (item.getEnchantmentLevel(enchantment) >= requiredLevel) {
                        yield true;
                    }
                    yield false;
                }
                case "max-level" -> {
                    if (item.getEnchantmentLevel(enchantment) <= requiredLevel) {
                        yield true;
                    }
                    yield false;
                }
                case "ignore" -> true;
                default -> false;
            }))) continue;
            ++matches;
        }
        if (requireAllEnchants) {
            return matches == requiredEnchantments.size();
        }
        return matches > 0;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.IF_VAR_ITEM_HAS_ENCHANTMENTS;
    }
}

