/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.executors;

import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.menus.MenusCategory;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public enum ExecutorCategory {
    EVENT_PLAYER(Material.DIAMOND_BLOCK, Material.DEEPSLATE_DIAMOND_ORE, NamedTextColor.AQUA, Material.LIGHT_BLUE_STAINED_GLASS_PANE, MenusCategory.WORLD),
    EVENT_ENTITY(Material.GOLD_BLOCK, Material.DEEPSLATE_GOLD_ORE, NamedTextColor.YELLOW, Material.YELLOW_STAINED_GLASS_PANE, MenusCategory.ENTITY_INTERACTION),
    EVENT_WORLD(Material.REDSTONE_BLOCK, Material.DEEPSLATE_REDSTONE_ORE, NamedTextColor.RED, Material.RED_STAINED_GLASS_PANE, MenusCategory.WORLD_OTHER),
    CYCLE(Material.OXIDIZED_COPPER, Material.WAXED_OXIDIZED_CUT_COPPER, NamedTextColor.DARK_AQUA, Material.LIGHT_BLUE_STAINED_GLASS_PANE),
    FUNCTION(Material.LAPIS_BLOCK, Material.DEEPSLATE_LAPIS_ORE, NamedTextColor.BLUE, Material.BLUE_STAINED_GLASS_PANE),
    METHOD(Material.EMERALD_BLOCK, Material.DEEPSLATE_EMERALD_ORE, NamedTextColor.GREEN, Material.LIME_STAINED_GLASS_PANE);

    private final Material block;
    private final Material additionalBlock;
    private final NamedTextColor color;
    private final Material stainedPane;
    private final MenusCategory defaultCategory;

    private ExecutorCategory(Material block, Material additionalBlock, NamedTextColor color, Material stainedPane) {
        this(block, additionalBlock, color, stainedPane, MenusCategory.OTHER);
    }

    private ExecutorCategory(Material block, Material additionalBlock, NamedTextColor color, Material stainedPane, MenusCategory defaultCategory) {
        this.block = block;
        this.additionalBlock = additionalBlock;
        this.color = color;
        this.stainedPane = stainedPane;
        this.defaultCategory = defaultCategory;
    }

    public MenusCategory getDefaultCategory() {
        return this.defaultCategory;
    }

    public Material getBlock() {
        return this.block;
    }

    public static ExecutorCategory getByMaterial(Material material) {
        for (ExecutorCategory category : ExecutorCategory.values()) {
            if (category.block != material) continue;
            return category;
        }
        return null;
    }

    public Material getStainedPane() {
        return this.stainedPane;
    }

    public NamedTextColor getColor() {
        return this.color;
    }

    public final String getLocaleName() {
        return MessageUtils.getLocaleMessage("blocks." + this.name().toLowerCase(), false);
    }

    public Material getAdditionalBlock() {
        return this.additionalBlock;
    }

    public ItemStack getItem() {
        return ItemUtils.createItem(this.block, 1, "items.developer." + this.name().toLowerCase().replace("_", "-"), this.name().toLowerCase());
    }
}

