/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.executors.other;

import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorType;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public class Cycle
extends Executor {
    private final String name;
    private final int repeatTime;
    private boolean enabled = false;
    private BukkitRunnable runnable = null;

    public Cycle(Planet planet, int x, int y, int z, String name, int repeatTime) {
        super(planet, x, y, z);
        this.name = name;
        this.repeatTime = repeatTime;
    }

    @Override
    public void run(final WorldEvent event) {
        if (!this.enabled) {
            this.enabled = true;
            final Cycle executor = this;
            this.runnable = new BukkitRunnable(){

                public void run() {
                    ErrorUtils.sendCodingDebugExecutor(executor);
                    Cycle.this.executeActions(event);
                }
            };
            this.getPlanet().getTerritory().addBukkitRunnable(this.runnable);
            this.runnable.runTaskTimer((Plugin)OpenCreative.getPlugin(), 0L, (long)this.repeatTime);
        }
    }

    public void stop() {
        if (this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
            this.enabled = false;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ExecutorType getExecutorType() {
        return ExecutorType.CYCLE;
    }

    @Override
    public ExecutorCategory getExecutorCategory() {
        return ExecutorCategory.CYCLE;
    }
}

