/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus.blocks;

import java.time.Duration;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.menus.blocks.BlocksWithMenusCategoryMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class ActionTypeSelectionMenu
extends BlocksWithMenusCategoryMenu<ActionType> {
    private final ActionCategory action;

    public ActionTypeSelectionMenu(@NotNull Player player, @NotNull Location location, @NotNull ActionCategory action) {
        if (player == null) {
            ActionTypeSelectionMenu.$$$reportNull$$$0(0);
        }
        if (location == null) {
            ActionTypeSelectionMenu.$$$reportNull$$$0(1);
        }
        if (action == null) {
            ActionTypeSelectionMenu.$$$reportNull$$$0(2);
        }
        super(player, location, action.isCondition() ? "conditions" : "actions", action.name().toLowerCase(), action.getStainedPane(), action.getDefaultCategory());
        this.action = action;
    }

    @Override
    protected ItemStack getElementIcon(ActionType type) {
        return type.getIcon();
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (item == null) {
            return;
        }
        if (item.getItemMeta() == null) {
            return;
        }
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(this.getPlayer());
        Block codingBlock = this.signLocation.getBlock().getRelative(BlockFace.NORTH);
        if (this.signLocation.getWorld().getName().contains("dev") && devPlanet != null) {
            ActionCategory actionCategory;
            String typeString = ItemUtils.getPersistentData(item, ItemUtils.getCodingValueKey());
            ActionType actionType = null;
            try {
                actionType = ActionType.valueOf(typeString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ActionCategory actionCategory2 = actionCategory = actionType == null ? null : actionType.getCategory();
            if (actionCategory != null) {
                devPlanet.setCodeChanged(true);
                BlockUtils.setSignLine(this.signLocation, 2, actionCategory.name().toLowerCase());
            }
            if (BlockUtils.setSignLine(this.signLocation, 3, typeString.toLowerCase())) {
                devPlanet.setCodeChanged(true);
                PlayerUtils.translateBlockSign(this.signLocation.getBlock());
                this.getPlayer().closeInventory();
                this.getPlayer().showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-" + (this.action.isCondition() ? "conditions" : "actions"))), (Component)item.getItemMeta().displayName(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(750L), (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(750L))));
                (this.action.isCondition() ? Sounds.DEV_SET_CONDITION : Sounds.DEV_SET_ACTION).play((Audience)event.getWhoClicked());
                event.getWhoClicked().swingMainHand();
            }
            if (actionCategory != null) {
                Block containerBlock = codingBlock.getRelative(BlockFace.UP);
                ItemStack[] itemStackArray = containerBlock.getState();
                if (itemStackArray instanceof InventoryHolder) {
                    InventoryHolder container = (InventoryHolder)itemStackArray;
                    if (devPlanet.isDropItems()) {
                        for (ItemStack chestItem : container.getInventory().getContents()) {
                            if (chestItem == null || chestItem.getItemMeta() != null && chestItem.getItemMeta().getPersistentDataContainer().has(ItemUtils.getCodingDoNotDropMeKey())) continue;
                            containerBlock.getWorld().dropItem(containerBlock.getLocation(), chestItem);
                        }
                    }
                    containerBlock.setType(Material.AIR);
                }
                if (actionType.isChestRequired()) {
                    containerBlock.setType(devPlanet.getContainerMaterial());
                    BlockData blockData = containerBlock.getBlockData();
                    ((Directional)blockData).setFacing(BlockFace.SOUTH);
                    containerBlock.setBlockData(blockData);
                    this.getPlayer().spawnParticle(Particle.BLOCK, containerBlock.getLocation(), 1, 0.0, 0.5, 0.5, (Object)containerBlock.getBlockData());
                    Sounds.DEV_ACTION_WITH_CHEST.play((Audience)this.getPlayer());
                }
            }
        }
    }

    @Override
    public List<ActionType> getElements() {
        return ActionType.getActionsByCategories(this.action, this.currentCategory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "player";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "action";
                break;
            }
        }
        objectArray[1] = "ua/mcchickenstudio/opencreative/coding/menus/blocks/ActionTypeSelectionMenu";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

