/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus.blocks;

import java.time.Duration;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorType;
import ua.mcchickenstudio.opencreative.coding.menus.blocks.BlocksWithMenusCategoryMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class ExecutorTypeSelectionMenu
extends BlocksWithMenusCategoryMenu<ExecutorType> {
    private final ExecutorCategory executor;

    public ExecutorTypeSelectionMenu(@NotNull Player player, @NotNull Location location, @NotNull ExecutorCategory executor) {
        if (player == null) {
            ExecutorTypeSelectionMenu.$$$reportNull$$$0(0);
        }
        if (location == null) {
            ExecutorTypeSelectionMenu.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            ExecutorTypeSelectionMenu.$$$reportNull$$$0(2);
        }
        super(player, location, "events", executor.name().toLowerCase(), executor.getStainedPane(), executor.getDefaultCategory());
        this.executor = executor;
    }

    @Override
    protected ItemStack getElementIcon(ExecutorType type) {
        return type.getIcon();
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        event.setCancelled(true);
        if (item == null) {
            return;
        }
        if (item.getItemMeta() == null) {
            return;
        }
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(this.getPlayer());
        Block codingBlock = this.signLocation.getBlock().getRelative(BlockFace.NORTH);
        if (this.signLocation.getWorld().getName().contains("dev") && devPlanet != null) {
            ExecutorCategory executorCategory;
            String typeString = ItemUtils.getPersistentData(item, ItemUtils.getCodingValueKey());
            ExecutorType executorType = null;
            try {
                executorType = ExecutorType.valueOf(typeString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ExecutorCategory executorCategory2 = executorCategory = executorType == null ? null : ExecutorCategory.getByMaterial(codingBlock.getType());
            if (executorCategory != null) {
                devPlanet.setCodeChanged(true);
                BlockUtils.setSignLine(this.signLocation, 2, executorCategory.name().toLowerCase());
            }
            if (BlockUtils.setSignLine(this.signLocation, 3, typeString.toLowerCase())) {
                devPlanet.setCodeChanged(true);
                PlayerUtils.translateBlockSign(this.signLocation.getBlock());
                this.getPlayer().closeInventory();
                this.getPlayer().showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-events")), (Component)item.getItemMeta().displayName(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(750L), (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofMillis(750L))));
                Sounds.DEV_SET_EVENT.play((Audience)event.getWhoClicked());
                event.getWhoClicked().swingMainHand();
            }
        }
    }

    @Override
    public List<ExecutorType> getElements() {
        return ExecutorType.getExecutorsByCategories(this.executor, this.currentCategory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "player";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "executor";
                break;
            }
        }
        objectArray[1] = "ua/mcchickenstudio/opencreative/coding/menus/blocks/ExecutorTypeSelectionMenu";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

