/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus.blocks;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.title.Title;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.menus.ListBrowserMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class FunctionChooserMenu
extends ListBrowserMenu<Location> {
    private final DevPlanet devPlanet;
    private final Location signLocation;

    public FunctionChooserMenu(Player player, DevPlanet planet, Location location) {
        super(player, MessageUtils.getLocaleMessage("menus.developer.function-chooser.title"), ListBrowserMenu.PlacementLayout.LOCATION_CHOOSER);
        this.devPlanet = planet;
        this.signLocation = location;
    }

    @Override
    protected ItemStack getElementIcon(Location location) {
        Block signBlock = location.getBlock().getRelative(BlockFace.SOUTH);
        String line = BlockUtils.getSignLine(signBlock.getLocation(), 3);
        if (line != null && !line.isEmpty()) {
            ItemStack itemStack = ItemUtils.createItem(Material.LAPIS_LAZULI, 1, "menus.developer.function-chooser.items.function");
            ItemMeta meta = itemStack.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.BLUE) + line);
            }
            itemStack.setItemMeta(meta);
            ItemUtils.setPersistentData(itemStack, ItemUtils.getCodingLocationX(), location.getX());
            ItemUtils.setPersistentData(itemStack, ItemUtils.getCodingLocationY(), location.getY());
            ItemUtils.setPersistentData(itemStack, ItemUtils.getCodingLocationZ(), location.getZ());
            ItemUtils.replacePlaceholderInLore(itemStack, "%x%", location.getX());
            ItemUtils.replacePlaceholderInLore(itemStack, "%y%", location.getY());
            ItemUtils.replacePlaceholderInLore(itemStack, "%z%", location.getZ());
            return itemStack;
        }
        return ItemStack.empty();
    }

    @Override
    protected void fillDecorationItems() {
        int slot;
        for (slot = 0; slot <= 8; ++slot) {
            this.setItem(slot, this.DECORATION_PANE_ITEM);
        }
        for (slot = 45; slot <= 53; ++slot) {
            this.setItem(slot, this.DECORATION_PANE_ITEM);
        }
    }

    @Override
    protected void fillOtherItems() {
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        if (this.isPlayerClicked(event) && this.isClickedInMenuSlots(event)) {
            ItemStack item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            if (item.getItemMeta() == null) {
                return;
            }
            String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
            event.getWhoClicked().closeInventory();
            if (event.isRightClick()) {
                PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
                if (container.has(ItemUtils.getCodingLocationX()) && container.has(ItemUtils.getCodingLocationY()) && container.has(ItemUtils.getCodingLocationZ())) {
                    try {
                        double x = (Double)container.get(ItemUtils.getCodingLocationX(), PersistentDataType.DOUBLE);
                        double y = (Double)container.get(ItemUtils.getCodingLocationY(), PersistentDataType.DOUBLE);
                        double z = (Double)container.get(ItemUtils.getCodingLocationZ(), PersistentDataType.DOUBLE);
                        event.getWhoClicked().teleport(new Location(event.getWhoClicked().getWorld(), x, y, z + 2.0, 180.0f, 0.0f));
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            } else {
                this.devPlanet.setCodeChanged(true);
                BlockUtils.setSignLine(this.signLocation, 3, name);
                PlayerUtils.translateBlockSign(this.signLocation.getBlock());
                this.getPlayer().showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("menus.developer.function-chooser.chosen")), (Component)Component.text((String)name).color((TextColor)NamedTextColor.BLUE), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
                Sounds.DEV_SET_FUNCTION.play((Audience)event.getWhoClicked());
                event.getWhoClicked().swingMainHand();
            }
        }
        event.setCancelled(true);
    }

    @Override
    protected void fillArrowsItems(int currentPage) {
        if (this.elements.isEmpty()) {
            this.setItem(this.getNoElementsPageButtonSlot(), this.getNoElementsButton());
            this.setItem(this.getPreviousPageButtonSlot(), this.DECORATION_PANE_ITEM);
            this.setItem(this.getNextPageButtonSlot(), this.DECORATION_PANE_ITEM);
        } else {
            int maxPagesAmount = this.getPages();
            if (currentPage > maxPagesAmount || currentPage < 1) {
                currentPage = 1;
            }
            this.setItem(this.getPreviousPageButtonSlot(), currentPage > 1 ? this.getPreviousPageButton() : this.DECORATION_PANE_ITEM);
            this.setItem(this.getNextPageButtonSlot(), currentPage < maxPagesAmount ? this.getNextPageButton() : this.DECORATION_PANE_ITEM);
        }
    }

    @Override
    public List<Location> getElements() {
        return new ArrayList<Location>(this.devPlanet.getPlacedFunctions());
    }

    @Override
    protected ItemStack getNextPageButton() {
        return ItemUtils.createItem(Material.SPECTRAL_ARROW, 1, "menus.developer.function-chooser.items.next-page");
    }

    @Override
    protected ItemStack getPreviousPageButton() {
        return ItemUtils.createItem(Material.ARROW, 1, "menus.developer.function-chooser.items.previous-page");
    }

    @Override
    protected ItemStack getNoElementsButton() {
        return ItemUtils.createItem(Material.BARRIER, 1, "menus.developer.function-chooser.items.no-elements");
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            FunctionChooserMenu.$$$reportNull$$$0(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/coding/menus/blocks/FunctionChooserMenu", "onOpen"));
    }
}

