/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus.layouts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.ArgumentSlot;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.ParameterSlot;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.ParameterButton;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public abstract class Layout
extends AbstractMenu {
    protected final ActionType actionType;
    protected final List<Integer> argsSlots = new ArrayList<Integer>();
    protected final List<ParameterButton> parameterButtons = new ArrayList<ParameterButton>();
    protected final ArgumentSlot[] requiredSlots;
    private final Block containerBlock;
    private final Set<Player> viewers = new HashSet<Player>();
    private int currentSlot = 0;

    public Layout(int rows, ActionType actionType, Block chestBlock) {
        super(rows, ChatColor.stripColor((String)actionType.getLocaleName()));
        this.actionType = actionType;
        this.containerBlock = chestBlock;
        this.requiredSlots = actionType.getArgumentsSlots();
    }

    protected void fillDecorationItems() {
        for (int slot = 0; slot < this.getRows() * 9; ++slot) {
            this.setItem(slot, this.DECORATION_PANE_ITEM);
        }
    }

    @Override
    public void fillItems(Player player) {
        this.fillDecorationItems();
        this.fillVarsItems();
    }

    protected abstract void fillVarsItems();

    protected ItemStack getFromContent(int slot) {
        BlockState blockState = this.containerBlock.getState();
        if (!(blockState instanceof InventoryHolder)) {
            return ItemStack.empty();
        }
        InventoryHolder container = (InventoryHolder)blockState;
        if (slot < 0 || slot >= container.getInventory().getContents().length) {
            return ItemStack.empty();
        }
        return container.getInventory().getContents()[slot];
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            Layout.$$$reportNull$$$0(0);
        }
        if (!this.isClickedInMenuSlots(event) || !this.isPlayerClicked(event)) {
            return;
        }
        ItemStack currentItem = event.getCursor();
        if (this.argsSlots.contains(event.getRawSlot())) {
            ItemStack argItem = this.inventory.getItem(event.getRawSlot());
            for (ParameterButton parameter : this.parameterButtons) {
                if (!ItemUtils.itemEquals(argItem, parameter.getItem())) continue;
                event.setCancelled(true);
                if (ItemUtils.getValueType(currentItem) == ValueType.VARIABLE) {
                    this.inventory.setItem(event.getRawSlot(), currentItem);
                    Sounds.DEV_VARIABLE_PARAMETER.play((Audience)event.getWhoClicked());
                    continue;
                }
                parameter.next();
                Sounds.DEV_NEXT_PARAMETER.play((Audience)event.getWhoClicked());
                this.inventory.setItem(event.getRawSlot(), parameter.getItem());
            }
        } else {
            event.setCancelled(true);
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            Layout.$$$reportNull$$$0(1);
        }
        this.viewers.add((Player)event.getPlayer());
        (this.containerBlock.getType() == Material.BARREL ? Sounds.DEV_OPEN_BARREL : Sounds.DEV_OPEN_CHEST).play((Audience)event.getPlayer());
        for (Player onlinePlayer : event.getPlayer().getWorld().getPlayers()) {
            PlayerUtils.sendOpenedChestAnimation(onlinePlayer, this.containerBlock);
        }
    }

    @Override
    public final void onClose(@NotNull InventoryCloseEvent event) {
        if (event == null) {
            Layout.$$$reportNull$$$0(2);
        }
        this.saveArgumentsItems(event.getInventory());
        (this.containerBlock.getType() == Material.BARREL ? Sounds.DEV_CLOSED_BARREL : Sounds.DEV_CLOSED_CHEST).play((Audience)event.getPlayer());
        this.viewers.remove((Player)event.getPlayer());
        if (this.viewers.isEmpty()) {
            DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet((Player)event.getPlayer());
            if (devPlanet != null) {
                devPlanet.setCodeChanged(true);
                devPlanet.unregisterOpenedMenu(this.containerBlock.getLocation());
                for (Player onlinePlayer : event.getPlayer().getWorld().getPlayers()) {
                    PlayerUtils.sendClosedChestAnimation(onlinePlayer, this.containerBlock);
                }
            }
            this.destroy();
        }
    }

    private void saveArgumentsItems(Inventory inventory) {
        BlockState blockState = this.containerBlock.getState();
        if (!(blockState instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder container = (InventoryHolder)blockState;
        int chestSlot = 0;
        for (int argSlot : this.argsSlots) {
            ItemStack argItem = inventory.getItem(argSlot);
            container.getInventory().setItem(chestSlot, argItem);
            for (ParameterButton rb : this.parameterButtons) {
                ItemMeta itemMeta;
                if (argItem == null) continue;
                ItemStack itemStack = argItem.clone();
                for (ItemFlag flag : itemStack.getItemFlags()) {
                    itemStack.removeItemFlags(new ItemFlag[]{flag});
                }
                if (!itemStack.equals((Object)rb.getItem(true)) || !itemStack.hasItemMeta()) continue;
                if (rb.getCurrentValue() instanceof Integer) {
                    itemStack.setType(Material.SLIME_BALL);
                    itemMeta = itemStack.getItemMeta();
                    itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&a") + String.valueOf(rb.getCurrentValue()) + ".0");
                } else if (rb.getCurrentValue() instanceof Boolean) {
                    boolean value = (Boolean)rb.getCurrentValue();
                    itemStack.setType(Material.CLOCK);
                    itemMeta = itemStack.getItemMeta();
                    itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + (value ? "a" : "c") + value)));
                } else {
                    itemStack.setType(Material.BOOK);
                    itemMeta = itemStack.getItemMeta();
                    itemMeta.setDisplayName(rb.getCurrentValue().toString());
                }
                itemMeta.lore(null);
                itemStack.setItemMeta(itemMeta);
                ItemUtils.setPersistentData(itemStack, ItemUtils.getCodingValueKey(), ValueType.getByMaterial(itemStack.getType()).name());
                ItemUtils.setPersistentData(itemStack, ItemUtils.getCodingDoNotDropMeKey(), "1");
                container.getInventory().setItem(chestSlot, itemStack);
            }
            ++chestSlot;
        }
        this.containerBlock.getState().update(true);
    }

    public ArgumentSlot[] getRequiredSlots() {
        return this.requiredSlots;
    }

    protected void setArgSlotVertical(int argNumber, int slot) {
        ArgumentSlot argumentSlot = this.getRequiredSlots()[argNumber - 1];
        this.setItem(slot - 9, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
        this.setArgSlot(argNumber, slot);
        this.setItem(slot + 9, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
    }

    protected void setArgSlotHorizontal(int argNumber, int slot) {
        ArgumentSlot argumentSlot = this.getRequiredSlots()[argNumber - 1];
        this.setItem(slot - 1, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
        this.setArgSlot(argumentSlot, slot);
        this.setItem(slot + 1, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
    }

    protected void setArgSlotCross(int argNumber, int slot) {
        ArgumentSlot argumentSlot = this.getRequiredSlots()[argNumber - 1];
        this.setItem(slot - 9, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
        this.setItem(slot - 1, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
        this.setArgSlot(argumentSlot, slot);
        this.setItem(slot + 1, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
        this.setItem(slot + 9, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
    }

    protected void setGlass(int argNumber, int slot) {
        ArgumentSlot argumentSlot = this.getRequiredSlots()[argNumber - 1];
        this.setItem(slot, argumentSlot.getVarType().getGlassItem(this.actionType, argumentSlot.getPath()));
    }

    protected void setArgSlot(int argNumber, int slot) {
        ArgumentSlot argumentSlot = this.getRequiredSlots()[argNumber - 1];
        this.setArgSlot(argumentSlot, slot);
    }

    private void setArgSlot(ArgumentSlot argumentSlot, int slot) {
        ItemStack contentItem = this.getFromContent(this.currentSlot++);
        if (argumentSlot.isParameter()) {
            Object value = "";
            if (contentItem != null && contentItem.hasItemMeta()) {
                String display = ChatColor.stripColor((String)contentItem.getItemMeta().getDisplayName());
                value = contentItem.getType() == Material.SLIME_BALL ? Integer.valueOf(Integer.parseInt(display.replace(".0", ""))) : (contentItem.getType() == Material.CLOCK ? Boolean.valueOf(Boolean.parseBoolean(display)) : display);
            }
            ParameterButton rb = this.createParamButton((ParameterSlot)argumentSlot, value);
            if (contentItem != null && ItemUtils.getValueType(contentItem) == ValueType.VARIABLE) {
                this.setItem(slot, contentItem);
            } else {
                this.setItem(slot, rb.getItem());
            }
            this.parameterButtons.add(rb);
        } else {
            this.setItem(slot, contentItem);
        }
        this.argsSlots.add(slot);
    }

    public List<Integer> getArgsSlots() {
        return this.argsSlots;
    }

    protected ParameterButton createParamButton(ParameterSlot argumentSlot, Object value) {
        String path = "items.developer." + (this.actionType.isCondition() ? "conditions" : "actions") + "." + this.actionType.name().toLowerCase().replace("_", "-") + ".arguments." + argumentSlot.getPath();
        return new ParameterButton(value, argumentSlot.getValues(), argumentSlot.getPath(), "items.developer", path, argumentSlot.getIcons());
    }

    protected int getRow(int slot) {
        if (slot < 9) {
            return 1;
        }
        if (slot < 18) {
            return 2;
        }
        if (slot < 27) {
            return 3;
        }
        if (slot < 36) {
            return 4;
        }
        if (slot < 45) {
            return 5;
        }
        if (slot < 54) {
            return 6;
        }
        return 0;
    }

    protected List<Integer> getRowSlots(int row) {
        int lastSlot = row * 9 - 1;
        int firstSlot = lastSlot - 8;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = firstSlot; slot < lastSlot; ++slot) {
            slots.add(slot);
        }
        return slots;
    }

    protected List<Integer> getFreeSlots(int row) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot : this.getRowSlots(row)) {
            if (this.getItem(slot) != this.DECORATION_PANE_ITEM) continue;
            slots.add(slot);
        }
        return slots;
    }

    protected List<Integer> getCentredSlots(int count, int row) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        switch (count) {
            case 1: {
                slots.add(row * 9 - 5);
                break;
            }
            case 2: {
                slots.add(row * 9 - 7);
                slots.add(row * 9 - 3);
                break;
            }
            case 3: {
                slots.add(row * 9 - 8);
                slots.add(row * 9 - 5);
                slots.add(row * 9 - 2);
                break;
            }
            case 4: {
                slots.add(row * 9 - 8);
                slots.add(row * 9 - 6);
                slots.add(row * 9 - 4);
                slots.add(row * 9 - 2);
                break;
            }
            case 5: {
                slots.add(row * 9 - 9);
                slots.add(row * 9 - 7);
                slots.add(row * 9 - 5);
                slots.add(row * 9 - 3);
                slots.add(row * 9 - 1);
                break;
            }
            case 6: {
                slots.add(row * 9 - 8);
                slots.add(row * 9 - 7);
                slots.add(row * 9 - 6);
                slots.add(row * 9 - 4);
                slots.add(row * 9 - 3);
                slots.add(row * 9 - 2);
                break;
            }
            case 7: {
                slots.add(row * 9 - 8);
                slots.add(row * 9 - 7);
                slots.add(row * 9 - 6);
                slots.add(row * 9 - 5);
                slots.add(row * 9 - 4);
                slots.add(row * 9 - 3);
                slots.add(row * 9 - 2);
                break;
            }
            case 8: {
                slots.add(row * 9 - 9);
                slots.add(row * 9 - 8);
                slots.add(row * 9 - 7);
                slots.add(row * 9 - 6);
                slots.add(row * 9 - 4);
                slots.add(row * 9 - 3);
                slots.add(row * 9 - 2);
                slots.add(row * 9 - 1);
                break;
            }
            default: {
                slots.add(row * 9 - 9);
                slots.add(row * 9 - 8);
                slots.add(row * 9 - 7);
                slots.add(row * 9 - 6);
                slots.add(row * 9 - 5);
                slots.add(row * 9 - 4);
                slots.add(row * 9 - 3);
                slots.add(row * 9 - 2);
                slots.add(row * 9 - 1);
            }
        }
        return slots;
    }

    protected int getArgSlotsSize() {
        int count = 0;
        for (ArgumentSlot slot : this.actionType.getArgumentsSlots()) {
            count += slot.getListSize();
        }
        return count;
    }

    public Set<Player> getViewers() {
        return this.viewers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/menus/layouts/Layout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onClose";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

