/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.menus.variables;

import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.menus.ListBrowserMenu;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class PotionsMenu
extends ListBrowserMenu<PotionEffectType> {
    private final Material potionMaterial;

    public PotionsMenu(Player player, Material material) {
        super(player, MessageUtils.getLocaleMessage("menus.developer.potions-list.title"), ListBrowserMenu.PlacementLayout.VALUE_CHOOSER);
        if (material != Material.POTION && material != Material.LINGERING_POTION && material != Material.SPLASH_POTION) {
            material = Material.POTION;
        }
        this.potionMaterial = material;
    }

    @Override
    protected ItemStack getElementIcon(PotionEffectType type) {
        ItemStack itemStack = new ItemStack(this.potionMaterial, 1);
        PotionMeta meta = (PotionMeta)itemStack.getItemMeta();
        PotionType potionType = PotionType.getByEffect((PotionEffectType)type);
        String name = type.getName().toLowerCase().replace("minecraft:", "");
        meta.displayName((Component)Component.text((String)MessageUtils.getLocaleItemName("menus.developer.potions-list.potions." + name)));
        if (potionType != null) {
            meta.setBasePotionType(potionType);
        } else {
            meta.setBasePotionType(PotionType.WATER);
            meta.addCustomEffect(new PotionEffect(type, 3600, 0), true);
        }
        meta.setColor(type.getColor());
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    @Override
    protected void fillDecorationItems() {
    }

    @Override
    protected void fillOtherItems() {
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        if (this.isPlayerClicked(event) && this.isClickedInMenuSlots(event)) {
            if (event.getCurrentItem() == null) {
                return;
            }
            event.getWhoClicked().getInventory().setItemInMainHand(event.getCurrentItem());
            Sounds.DEV_POTION_SET.play((Audience)event.getWhoClicked());
        }
        event.setCancelled(true);
    }

    @Override
    public List<PotionEffectType> getElements() {
        return Arrays.asList(PotionEffectType.values());
    }

    @Override
    protected ItemStack getNextPageButton() {
        return ItemUtils.createItem(Material.SPECTRAL_ARROW, 1, "menus.developer.potions-list.items.next-page");
    }

    @Override
    protected ItemStack getPreviousPageButton() {
        return ItemUtils.createItem(Material.ARROW, 1, "menus.developer.potions-list.items.previous-page");
    }

    @Override
    protected ItemStack getNoElementsButton() {
        return ItemUtils.createItem(Material.BARRIER, 1, "menus.developer.potions-list.items.no-elements");
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            PotionsMenu.$$$reportNull$$$0(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/coding/menus/variables/PotionsMenu", "onOpen"));
    }
}

