/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.modules;

import java.util.LinkedList;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.CodeConfiguration;
import ua.mcchickenstudio.opencreative.coding.CodingBlockParser;
import ua.mcchickenstudio.opencreative.coding.CodingBlockPlacer;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.settings.groups.LimitType;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class BlocksManipulatorMenu
extends AbstractMenu {
    private final Player player;
    private final DevPlanet devPlanet;
    private final ItemStack duplicate;
    private final ItemStack createModule;
    private final ItemStack createModuleLimit;

    public BlocksManipulatorMenu(@NotNull Player player, @NotNull DevPlanet devPlanet, int selectedAmount) {
        if (player == null) {
            BlocksManipulatorMenu.$$$reportNull$$$0(0);
        }
        if (devPlanet == null) {
            BlocksManipulatorMenu.$$$reportNull$$$0(1);
        }
        super(3, MessageUtils.getLocaleMessage("menus.developer.manipulator.title", false).replace("%amount%", String.valueOf(selectedAmount)).replace("%limit%", String.valueOf(OpenCreative.getSettings().getGroups().getGroup(player).getLimit(LimitType.SELECTED_LINES_AMOUNT).calculateLimit(1))));
        this.duplicate = ItemUtils.createItem(Material.BOOKSHELF, 1, "menus.developer.manipulator.items.duplicate", "duplicate");
        this.createModule = ItemUtils.createItem(Material.CHERRY_CHEST_BOAT, 1, "menus.developer.manipulator.items.create-module", "module");
        this.createModuleLimit = ItemUtils.createItem(Material.RED_STAINED_GLASS, 1, "menus.developer.manipulator.items.create-module-limit", "module");
        this.player = player;
        this.devPlanet = devPlanet;
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(12, this.duplicate);
        int amount = OpenCreative.getModuleManager().getPlayerModules(player.getUniqueId()).size();
        int limit = OpenCreative.getSettings().getGroups().getGroup(player).getModulesLimit();
        int left = limit - amount;
        if (left >= 1) {
            ItemUtils.replacePlaceholderInLore(this.createModule, "%amount%", amount);
            ItemUtils.replacePlaceholderInLore(this.createModule, "%limit%", limit);
            ItemUtils.replacePlaceholderInLore(this.createModule, "%left%", left);
            this.setItem(14, this.createModule);
        } else {
            ItemUtils.replacePlaceholderInLore(this.createModuleLimit, "%amount%", amount);
            ItemUtils.replacePlaceholderInLore(this.createModuleLimit, "%limit%", limit);
            ItemUtils.replacePlaceholderInLore(this.createModuleLimit, "%left%", left);
            this.setItem(14, this.createModuleLimit);
        }
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            BlocksManipulatorMenu.$$$reportNull$$$0(2);
        }
        if (!this.isClickedInMenuSlots(event) || !this.isPlayerClicked(event)) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        if (!this.devPlanet.isLoaded()) {
            this.player.closeInventory();
            return;
        }
        if (ItemUtils.itemEquals(currentItem, this.duplicate)) {
            if (CooldownUtils.getCooldown(this.player, CooldownUtils.CooldownType.BLOCKS_DUPLICATION) > 0) {
                this.player.sendMessage(MessageUtils.getLocaleMessage("cooldown").replace("%cooldown%", String.valueOf(CooldownUtils.getCooldown(this.player, CooldownUtils.CooldownType.BLOCKS_DUPLICATION))));
                return;
            }
            CooldownUtils.setCooldown(this.player, OpenCreative.getSettings().getGroups().getGroup(this.player).getBlocksDuplicationCooldown(), CooldownUtils.CooldownType.BLOCKS_DUPLICATION);
            this.player.closeInventory();
            CodeConfiguration temporary = new CodeConfiguration();
            new CodingBlockParser(this.devPlanet).parseExecutors(this.devPlanet, temporary, new LinkedList<Location>(this.devPlanet.getMarkedExecutors(this.player)));
            this.devPlanet.clearMarkedExecutors(this.player);
            ConfigurationSection section = temporary.getConfigurationSection("code.blocks");
            if (section == null) {
                return;
            }
            new CodingBlockPlacer(this.devPlanet).placeCodingLines(this.devPlanet, section);
            this.devPlanet.setCodeChanged(true);
            Sounds.DEV_BLOCKS_DUPLICATED.play((Audience)this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.createModule)) {
            if (CooldownUtils.getCooldown(this.player, CooldownUtils.CooldownType.MODULE_MANIPULATION) > 0) {
                this.player.sendMessage(MessageUtils.getLocaleMessage("cooldown").replace("%cooldown%", String.valueOf(CooldownUtils.getCooldown(this.player, CooldownUtils.CooldownType.MODULE_MANIPULATION))));
                return;
            }
            CooldownUtils.setCooldown(this.player, OpenCreative.getSettings().getGroups().getGroup(this.player).getBlocksDuplicationCooldown(), CooldownUtils.CooldownType.MODULE_MANIPULATION);
            int limit = OpenCreative.getSettings().getGroups().getGroup(this.player).getModulesLimit();
            if (OpenCreative.getModuleManager().getPlayerModules(this.player.getUniqueId()).size() > limit) {
                this.player.closeInventory();
                return;
            }
            this.player.closeInventory();
            OpenCreative.getModuleManager().createModule(this.player, this.devPlanet, this.devPlanet.getMarkedExecutors(this.player));
            this.devPlanet.clearMarkedExecutors(this.player);
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            BlocksManipulatorMenu.$$$reportNull$$$0(3);
        }
        Sounds.MENU_OPEN_BLOCKS_MANIPULATOR.play((Audience)this.player);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devPlanet";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/modules/BlocksManipulatorMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

