/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.modules;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.coding.modules.ModuleSettingsMenu;
import ua.mcchickenstudio.opencreative.coding.modules.ModulesBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.ListBrowserMenu;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class OwnModulesBrowserMenu
extends ListBrowserMenu<Module> {
    private final List<Module> modules;
    private final ItemStack TUTORIAL = ItemUtils.createItem(Material.ENDER_EYE, 1, "menus.own-modules.items.tutorial");
    private final ItemStack BACK_TO_ALL_MODULES = ItemUtils.createItem(Material.MANGROVE_CHEST_BOAT, 1, "menus.own-modules.items.all-modules");

    public OwnModulesBrowserMenu(Player player) {
        super(player, MessageUtils.getLocaleMessage("menus.own-modules.title", false), ListBrowserMenu.PlacementLayout.BOTTOM_NO_DECORATION, new int[]{45}, new int[]{45, 46, 52, 53});
        this.modules = new ArrayList<Module>(OpenCreative.getModuleManager().getPlayerModules(player.getUniqueId()));
        Comparator<Module> sortByOnline = Comparator.comparingLong(module -> module.getInformation().getCreationTime());
        this.modules.sort(sortByOnline);
    }

    @Override
    protected ItemStack getElementIcon(Module module) {
        ItemStack item = ItemUtils.clearItemMeta(module.getInformation().getIcon().clone());
        ItemMeta meta = item.getItemMeta();
        meta.displayName(module.getInformation().displayName());
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : MessageUtils.getLocaleItemDescription("menus.own-modules.items.module.lore")) {
            if (loreLine.contains("%moduleDescription%")) {
                String[] newLines;
                for (String newLine : newLines = module.getInformation().getDescription().split("\\\\n")) {
                    lore.add(loreLine.replace("%moduleDescription%", ChatColor.translateAlternateColorCodes((char)'&', (String)newLine)));
                }
                continue;
            }
            lore.add(MessageUtils.parseModuleLines(module, loreLine));
        }
        meta.setLore(lore);
        item.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
        item.setItemMeta(meta);
        ItemUtils.setPersistentData(item, ItemUtils.getItemIdKey(), String.valueOf(module.getId()));
        return item;
    }

    @Override
    protected void fillOtherItems() {
        this.setItem(45, this.BACK_TO_ALL_MODULES);
        this.setItem(ItemUtils.createItem(Material.GREEN_STAINED_GLASS_PANE, 1), 47, 51);
        this.setItem(49, this.TUTORIAL);
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        if (ItemUtils.itemEquals(item, this.BACK_TO_ALL_MODULES)) {
            new ModulesBrowserMenu(this.getPlayer()).open(this.getPlayer());
        }
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack currentItem = event.getCurrentItem();
        event.setCancelled(true);
        if (currentItem == null) {
            return;
        }
        String moduleID = ItemUtils.getPersistentData(currentItem, ItemUtils.getItemIdKey());
        if (moduleID.isEmpty()) {
            return;
        }
        Module module = OpenCreative.getModuleManager().getModuleById(moduleID);
        if (module != null) {
            new ModuleSettingsMenu(module, this.getPlayer()).open(this.getPlayer());
        }
    }

    @Override
    protected void fillArrowsItems(int currentPage) {
        if (this.elements.isEmpty()) {
            this.setItem(this.getNoElementsPageButtonSlot(), this.getNoElementsButton());
            this.setItem(this.getPreviousPageButtonSlot(), this.BACK_TO_ALL_MODULES);
            this.setItem(this.getNextPageButtonSlot(), this.DECORATION_ITEM);
        } else {
            int maxPagesAmount = this.getPages();
            if (currentPage > maxPagesAmount || currentPage < 1) {
                currentPage = 1;
            }
            this.setItem(this.getPreviousPageButtonSlot(), currentPage > 1 ? this.getPreviousPageButton() : this.BACK_TO_ALL_MODULES);
            this.setItem(this.getNextPageButtonSlot(), currentPage < maxPagesAmount ? this.getNextPageButton() : this.DECORATION_ITEM);
        }
    }

    @Override
    public List<Module> getElements() {
        return new ArrayList<Module>(this.modules);
    }

    @Override
    protected ItemStack getNextPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.SPECTRAL_ARROW, this.getCurrentPage() + 1, "menus.own-modules.items.next-page"), "%page%", this.getCurrentPage() + 1);
    }

    @Override
    protected ItemStack getPreviousPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.SPECTRAL_ARROW, Math.max(1, this.getCurrentPage() - 1), "menus.own-modules.items.previous-page"), "%page%", this.getCurrentPage() - 1);
    }

    @Override
    protected ItemStack getNoElementsButton() {
        return ItemUtils.createItem(Material.BARRIER, 1, "menus.own-modules.items.no-modules");
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            OwnModulesBrowserMenu.$$$reportNull$$$0(0);
        }
        Sounds.MENU_OPEN_OWN_MODULES_BROWSER.play((Audience)event.getPlayer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/coding/modules/OwnModulesBrowserMenu", "onOpen"));
    }
}

