/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.blocks.events.WorldEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.KillerVictimEvent;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyPlaceholder;

public final class EventPlaceholder
extends KeyPlaceholder {
    public EventPlaceholder() {
        super("killer", "damager", "killer_uuid", "damager_uuid", "victim", "victim_uuid", "shooter", "shooter_uuid", "event");
    }

    @Override
    @Nullable
    public String parseKey(String key, ActionsHandler handler, Action action) {
        WorldEvent worldEvent = handler.getEvent();
        Entity killer = null;
        Entity victim = null;
        if (worldEvent instanceof KillerVictimEvent) {
            KillerVictimEvent event = (KillerVictimEvent)((Object)worldEvent);
            killer = event.getKiller();
            victim = event.getVictim();
        }
        return switch (key) {
            case "killer", "damager", "shooter" -> {
                if (killer != null) {
                    yield killer.getName();
                }
                yield null;
            }
            case "killer_uuid", "damager_uuid", "shooter_uuid" -> {
                if (killer != null) {
                    yield killer.getUniqueId().toString();
                }
                yield null;
            }
            case "victim" -> {
                if (victim != null) {
                    yield victim.getName();
                }
                yield null;
            }
            case "victim_uuid" -> {
                if (victim != null) {
                    yield victim.getUniqueId().toString();
                }
                yield null;
            }
            case "event" -> {
                if (handler.getEvent() == null) {
                    yield "null";
                }
                yield ((Object)((Object)handler.getEvent())).getClass().getSimpleName().toLowerCase();
            }
            default -> null;
        };
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getName() {
        return "Event Placeholder";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Parses event placeholders";
    }
}

