/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.Placeholder;

public abstract class KeyPlaceholder
extends Placeholder {
    private final String[] keys;
    private static final int limit = 20;
    private static final Pattern PATTERN_PLACEHOLDER = Pattern.compile("%[A-Za-z0-9]+%");

    public KeyPlaceholder(String ... keys) {
        this.keys = keys;
    }

    public static Pattern getPatternPlaceholder() {
        return PATTERN_PLACEHOLDER;
    }

    @Override
    public boolean matches(String text) {
        Matcher matcher = PATTERN_PLACEHOLDER.matcher(text);
        while (matcher.find()) {
            String placeholder = matcher.group();
            String key = placeholder.substring(1, placeholder.length() - 1);
            for (String listedKey : this.keys) {
                if (!key.equals(listedKey)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getKeys() {
        return this.keys;
    }

    @Nullable
    public abstract String parseKey(String var1, ActionsHandler var2, Action var3);

    @Override
    @NotNull
    public String parse(String text, ActionsHandler handler, Action action) {
        Matcher matcher = PATTERN_PLACEHOLDER.matcher(text);
        StringBuilder result = new StringBuilder();
        int count = 0;
        while (matcher.find() && ++count < 20) {
            String key = matcher.group();
            Object replacement = this.parseKey(key = key.substring(1, key.length() - 1), handler, action);
            if (replacement == null) {
                replacement = "%" + key + "%";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement((String)replacement));
        }
        matcher.appendTail(result);
        String string = result.toString();
        if (string == null) {
            KeyPlaceholder.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ua/mcchickenstudio/opencreative/coding/placeholders/KeyPlaceholder", "parse"));
    }
}

