/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.Placeholder;

public abstract class KeyValuePlaceholder
extends Placeholder {
    private final String[] keys;
    private static final Pattern PATTERN = Pattern.compile("%([A-Za-z0-9_]+)\\(([^)]+)\\)");
    private static final int limit = 20;

    public KeyValuePlaceholder(String ... keys) {
        this.keys = keys;
    }

    public static Pattern getPattern() {
        return PATTERN;
    }

    public String[] getKeys() {
        return this.keys;
    }

    @Nullable
    public abstract String parseKeyValue(String var1, String var2, ActionsHandler var3, Action var4);

    @Override
    public boolean matches(String text) {
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (!Arrays.asList(this.keys).contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String parse(String text, ActionsHandler handler, Action action) {
        Matcher matcher = PATTERN.matcher(text);
        StringBuilder result = new StringBuilder();
        int count = 0;
        while (matcher.find() && ++count < 20) {
            String value;
            String key = matcher.group(1);
            Object replacement = this.parseKeyValue(key, value = matcher.group(2), handler, action);
            if (replacement == null) {
                replacement = "%" + key + "(" + value + ")";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement((String)replacement));
        }
        matcher.appendTail(result);
        String string = result.toString();
        if (string == null) {
            KeyValuePlaceholder.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ua/mcchickenstudio/opencreative/coding/placeholders/KeyValuePlaceholder", "parse"));
    }
}

