/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyValuePlaceholder;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.coding.variables.WorldVariable;
import ua.mcchickenstudio.opencreative.coding.variables.WorldVariables;

public final class ListPlaceholder
extends KeyValuePlaceholder {
    public ListPlaceholder() {
        super("list", "list_local", "list_game", "list_global", "list_saved", "list_save");
    }

    @Override
    @Nullable
    public String parseKeyValue(String key, String value, ActionsHandler handler, Action action) {
        VariableLink link;
        if (!value.contains(",")) {
            return null;
        }
        String[] split = value.split(",");
        if (split.length < 2) {
            return null;
        }
        String listName = split[0].strip();
        int listIndex = 1;
        try {
            listIndex = Integer.parseInt(split[1].strip());
        }
        catch (Exception e) {
            return null;
        }
        if (listIndex < 1) {
            return null;
        }
        WorldVariables variables = action.getExecutor().getPlanet().getVariables();
        switch (key) {
            case "list_local": {
                VariableLink variableLink = new VariableLink(listName, VariableLink.VariableType.LOCAL);
                break;
            }
            case "list": 
            case "list_global": 
            case "list_game": {
                VariableLink variableLink = new VariableLink(listName, VariableLink.VariableType.GLOBAL);
                break;
            }
            case "list_save": 
            case "list_saved": {
                VariableLink variableLink = new VariableLink(listName, VariableLink.VariableType.SAVED);
                break;
            }
            default: {
                VariableLink variableLink = link = null;
            }
        }
        if (link == null) {
            return null;
        }
        WorldVariable variable = variables.getVariable(link, action);
        String replacement = "null! " + value + " - " + link.getVariableType().name();
        if (variable == null) {
            return replacement;
        }
        Object object = variable.getValue();
        if (!(object instanceof List)) {
            return replacement;
        }
        List list = (List)object;
        if (listIndex > list.size()) {
            return replacement;
        }
        Object listValue = list.get(listIndex - 1);
        return String.valueOf(listValue).substring(0, Math.min(100, String.valueOf(listValue).length()));
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getName() {
        return "List Placeholder";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Parses list elements placeholders";
    }
}

