/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.placeholders;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.placeholders.KeyValuePlaceholder;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.coding.variables.WorldVariable;
import ua.mcchickenstudio.opencreative.coding.variables.WorldVariables;

public final class VarPlaceholder
extends KeyValuePlaceholder {
    public VarPlaceholder() {
        super("var", "var_local", "var_game", "var_global", "var_save", "var_saved");
    }

    @Override
    @Nullable
    public String parseKeyValue(String type, String name, ActionsHandler handler, Action action) {
        VariableLink link;
        WorldVariables variables = action.getExecutor().getPlanet().getVariables();
        switch (type) {
            case "var_local": {
                VariableLink variableLink = new VariableLink(name, VariableLink.VariableType.LOCAL);
                break;
            }
            case "var": 
            case "var_game": 
            case "var_global": {
                VariableLink variableLink = new VariableLink(name, VariableLink.VariableType.GLOBAL);
                break;
            }
            case "var_save": 
            case "var_saved": {
                VariableLink variableLink = new VariableLink(name, VariableLink.VariableType.SAVED);
                break;
            }
            default: {
                VariableLink variableLink = link = null;
            }
        }
        if (link == null) {
            return null;
        }
        WorldVariable variable = variables.getVariable(link, action);
        Object replacement = "null! " + name + " - " + link.getVariableType().name();
        if (variable != null) {
            replacement = String.valueOf(variable.getValue()).substring(0, Math.min(100, String.valueOf(variable.getValue()).length()));
        }
        return replacement;
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getName() {
        return "Variable Placeholder";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Parses variable placeholders";
    }
}

