/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.variables;

import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.variables.EventValueLink;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public enum ValueType {
    BOOLEAN(Material.CLOCK, Material.YELLOW_STAINED_GLASS_PANE),
    ENTITY_TYPE(Material.PIG_SPAWN_EGG, Material.RED_STAINED_GLASS_PANE),
    ITEM(Material.ITEM_FRAME, Material.ORANGE_STAINED_GLASS_PANE),
    LIST(Material.PAINTING, Material.GREEN_STAINED_GLASS_PANE),
    MAP(Material.CHEST_MINECART, Material.BROWN_STAINED_GLASS_PANE),
    LOCATION(Material.PAPER, Material.WHITE_STAINED_GLASS_PANE),
    NUMBER(Material.SLIME_BALL, Material.LIME_STAINED_GLASS_PANE),
    PARAMETER(Material.ANVIL, Material.BLACK_STAINED_GLASS_PANE),
    PARTICLE(Material.NETHER_STAR, Material.PURPLE_STAINED_GLASS_PANE),
    POTION(Material.POTION, Material.BLUE_STAINED_GLASS_PANE),
    TEXT(Material.BOOK, Material.BROWN_STAINED_GLASS_PANE),
    VARIABLE(Material.MAGMA_CREAM, Material.YELLOW_STAINED_GLASS_PANE),
    EVENT_VALUE(Material.NAME_TAG, Material.YELLOW_STAINED_GLASS_PANE),
    VECTOR(Material.PRISMARINE_SHARD, Material.LIGHT_BLUE_STAINED_GLASS_PANE),
    COLOR(Material.BLACK_DYE, Material.LIGHT_BLUE_STAINED_GLASS),
    ANY(Material.AIR, Material.BLACK_STAINED_GLASS_PANE);

    private final Material material;
    private final Material glass;

    private ValueType(Material item, Material glass) {
        this.material = item;
        this.glass = glass;
    }

    public Material getGlass() {
        return this.glass;
    }

    public ItemStack getGlassItem(ActionType action, String path) {
        String messagePath = "items.developer.actions." + action.name().toLowerCase().replace("_", "-") + ".placeholders." + path;
        ItemStack itemStack = ItemUtils.createItem(this.getGlass(), 1);
        ItemMeta meta = itemStack.getItemMeta();
        if (!MessageUtils.messageExists(messagePath + ".name")) {
            meta.setDisplayName(MessageUtils.getLocaleItemName("items.developer.placeholders." + this.name().toLowerCase() + ".name"));
        } else {
            meta.setDisplayName(MessageUtils.getLocaleItemName(messagePath + ".name"));
        }
        if (!MessageUtils.messageExists(messagePath + ".lore")) {
            meta.setLore(MessageUtils.getLocaleItemDescription("items.developer.placeholders." + this.name().toLowerCase() + ".lore"));
        } else {
            meta.setLore(MessageUtils.getLocaleItemDescription(messagePath + ".lore"));
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    @NotNull
    public static ValueType parseString(String type) {
        for (ValueType varType : ValueType.values()) {
            if (!varType.name().equalsIgnoreCase(type)) continue;
            ValueType valueType = varType;
            if (valueType == null) {
                ValueType.$$$reportNull$$$0(0);
            }
            return valueType;
        }
        ValueType valueType = TEXT;
        if (valueType == null) {
            ValueType.$$$reportNull$$$0(1);
        }
        return valueType;
    }

    @NotNull
    public static ValueType getByMaterial(Material material) {
        for (ValueType varType : ValueType.values()) {
            if (varType.material != material) continue;
            ValueType valueType = varType;
            if (valueType == null) {
                ValueType.$$$reportNull$$$0(2);
            }
            return valueType;
        }
        ValueType valueType = TEXT;
        if (valueType == null) {
            ValueType.$$$reportNull$$$0(3);
        }
        return valueType;
    }

    @Nullable
    public static ValueType getByObject(Object object) {
        if (object instanceof Float || object instanceof Double || object instanceof Integer || object instanceof Byte) {
            return NUMBER;
        }
        if (object instanceof String) {
            return TEXT;
        }
        if (object instanceof VariableLink) {
            return VARIABLE;
        }
        if (object instanceof EventValueLink) {
            return EVENT_VALUE;
        }
        if (object instanceof Boolean) {
            return BOOLEAN;
        }
        if (object instanceof List) {
            return LIST;
        }
        if (object instanceof Map) {
            return MAP;
        }
        if (object instanceof ItemStack) {
            return ITEM;
        }
        if (object instanceof Location) {
            return LOCATION;
        }
        if (object instanceof Vector) {
            return VECTOR;
        }
        if (object instanceof Particle) {
            return PARTICLE;
        }
        if (object instanceof Color) {
            return COLOR;
        }
        return null;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getLocaleName() {
        return MessageUtils.getLocaleMessage("environment.values." + this.name().toLowerCase().replace("_", "-"), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ua/mcchickenstudio/opencreative/coding/variables/ValueType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getByMaterial";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

