/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.variables;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Argument;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionsHandler;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedVariablesEvent;
import ua.mcchickenstudio.opencreative.coding.variables.EventValueLink;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.coding.variables.WorldVariable;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class WorldVariables {
    private final Planet planet;
    private final Set<WorldVariable> variables = new LinkedHashSet<WorldVariable>();

    public WorldVariables(Planet planet) {
        this.planet = planet;
    }

    @Nullable
    public WorldVariable getVariable(@NotNull VariableLink link, @NotNull Action action) {
        if (link == null) {
            WorldVariables.$$$reportNull$$$0(0);
        }
        if (action == null) {
            WorldVariables.$$$reportNull$$$0(1);
        }
        return this.getVariable(Argument.parseEntity(link.getName(), action.getHandler(), action), link.getVariableType(), action.getHandler().getMainActionHandler());
    }

    @Nullable
    public WorldVariable getVariable(@NotNull String name, @NotNull VariableLink.VariableType type, @Nullable ActionsHandler handler) {
        if (name == null) {
            WorldVariables.$$$reportNull$$$0(2);
        }
        if (type == null) {
            WorldVariables.$$$reportNull$$$0(3);
        }
        return this.variables.stream().filter(var -> var.getName().equalsIgnoreCase(name)).filter(var -> type == var.getVarType()).filter(var -> type != VariableLink.VariableType.LOCAL || handler != null && handler.equals(var.getHandler())).findFirst().orElse(null);
    }

    private boolean handleVariableValue(VariableLink link, ValueType type, Object value, ActionsHandler handler, Action action) {
        WorldVariable variable = action != null ? this.getVariable(link, action) : this.getVariable(link.getName(), link.getVariableType(), null);
        String valueString = value.toString().substring(0, Math.min(20, value.toString().length()));
        if (variable != null) {
            if (variable.getSize() + this.getTotalVariablesAmount() > this.planet.getLimits().getVariablesAmountLimit()) {
                ErrorUtils.sendCodingDebugLog(this.getPlanet(), "Reached limit of " + this.planet.getLimits().getVariablesAmountLimit() + " variables.");
                new LimitReachedVariablesEvent(this.planet).callEvent();
                return false;
            }
            variable.setType(type);
            variable.setValue(value);
        } else {
            WorldVariable newVariable;
            if (this.getTotalVariablesAmount() > this.planet.getLimits().getVariablesAmountLimit()) {
                ErrorUtils.sendCodingDebugLog(this.getPlanet(), "Reached limit of " + this.planet.getLimits().getVariablesAmountLimit() + " variables.");
                new LimitReachedVariablesEvent(this.planet).callEvent();
                return false;
            }
            WorldVariable worldVariable = newVariable = action != null ? new WorldVariable(Argument.parseEntity(link.getName(), action.getHandler(), action), link.getVariableType(), type, value, handler) : new WorldVariable(link.getName(), link.getVariableType(), type, value, null);
            if (newVariable.getSize() + this.getTotalVariablesAmount() > this.planet.getLimits().getVariablesAmountLimit()) {
                ErrorUtils.sendCodingDebugLog(this.getPlanet(), "Reached limit of " + this.planet.getLimits().getVariablesAmountLimit() + " variables.");
                new LimitReachedVariablesEvent(this.planet).callEvent();
                return false;
            }
            this.variables.add(newVariable);
        }
        ErrorUtils.sendCodingDebugLog(this.getPlanet(), MessageUtils.getLocaleMessage("coding-debug.variable." + (variable == null ? "created" : "set"), false).replace("%variable%", action != null ? Argument.parseEntity(link.getName(), action.getHandler(), action) : link.getName()).replace("%value%", valueString));
        return true;
    }

    public void setVariableValue(VariableLink link, ValueType type, Object value, ActionsHandler handler, Action action) {
        this.handleVariableValue(link, type, value, handler, action);
    }

    public boolean setVariableValue(VariableLink link, ValueType type, Object value) {
        return this.handleVariableValue(link, type, value, null, null);
    }

    public Object getVariableValue(VariableLink link, Action action) {
        WorldVariable variable = this.getVariable(link, action);
        return variable != null ? variable.getValue() : null;
    }

    public void removeVariable(VariableLink link, Action action) {
        this.variables.removeIf(var -> var.equals(this.getVariable(link, action)));
    }

    public Set<WorldVariable> getSet() {
        return this.variables;
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public void load() {
        long startTime = System.currentTimeMillis();
        OpenCreative.getPlugin().getLogger().info("Loading variables for planet " + this.planet.getId());
        this.clearVariables();
        File variablesJson = FileUtils.getPlanetVariablesJson(this.planet);
        if (variablesJson == null || variablesJson.length() <= 2L) {
            return;
        }
        try {
            JSONParser jsonParser = new JSONParser();
            JSONArray a = (JSONArray)jsonParser.parse((Reader)new FileReader(variablesJson));
            for (Object object : a) {
                JSONObject jsonObject = (JSONObject)object;
                String name = (String)jsonObject.get((Object)"name");
                ValueType type = ValueType.valueOf((String)jsonObject.get((Object)"type"));
                Object value = jsonObject.get((Object)"value");
                value = this.deserializeObject(value, type);
                if (this.variables.size() >= this.planet.getLimits().getVariablesAmountLimit()) continue;
                this.variables.add(new WorldVariable(name, VariableLink.VariableType.SAVED, type, value, null));
            }
        }
        catch (Exception e) {
            ErrorUtils.sendCriticalErrorMessage("Failed to parse JSON file " + variablesJson.getPath(), e);
        }
        long endTime = System.currentTimeMillis();
        OpenCreative.getPlugin().getLogger().info("Loaded " + this.variables.size() + " variables for planet " + this.planet.getId() + " in " + (endTime - startTime) + " ms");
    }

    public void save() {
        long startTime = System.currentTimeMillis();
        OpenCreative.getPlugin().getLogger().info("Saving variables for planet " + this.planet.getId());
        File variablesJson = FileUtils.getPlanetVariablesJson(this.planet);
        if (variablesJson == null) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        try (FileWriter file = new FileWriter(variablesJson.getPath());){
            for (WorldVariable worldVariable : this.variables) {
                if (worldVariable.getVarType() != VariableLink.VariableType.SAVED) continue;
                JSONObject objItem = new JSONObject();
                objItem.put((Object)"name", (Object)worldVariable.getName());
                objItem.put((Object)"type", (Object)worldVariable.getType().name());
                Object value = worldVariable.getValue();
                value = this.serializeObject(value);
                objItem.put((Object)"value", value);
                jsonArray.add((Object)objItem);
            }
            file.write(jsonArray.toString());
        }
        catch (Exception e) {
            ErrorUtils.sendCriticalErrorMessage("Failed to save variables", e);
        }
        long endTime = System.currentTimeMillis();
        long fileSize = FileUtils.getFileSize(variablesJson);
        OpenCreative.getPlugin().getLogger().info("Saved " + jsonArray.size() + " variables for planet " + this.planet.getId() + " in " + (endTime - startTime) + " ms (" + org.apache.commons.io.FileUtils.byteCountToDisplaySize(fileSize) + ")");
    }

    private Object serializeObject(Object value) {
        try {
            if (value instanceof ItemStack) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                BukkitObjectOutputStream objectOutputStream = new BukkitObjectOutputStream((OutputStream)arrayOutputStream);
                objectOutputStream.writeObject(value);
                value = Base64Coder.encodeLines((byte[])arrayOutputStream.toByteArray());
            } else {
                if (value instanceof Location) {
                    Location location = (Location)value;
                    HashMap<String, Number> locationMap = new HashMap<String, Number>();
                    locationMap.put("x", location.getX());
                    locationMap.put("y", location.getY());
                    locationMap.put("z", location.getZ());
                    locationMap.put("yaw", Float.valueOf(location.getYaw()));
                    locationMap.put("pitch", Float.valueOf(location.getPitch()));
                    return locationMap;
                }
                if (value instanceof Vector) {
                    Vector vector = (Vector)value;
                    HashMap<String, Double> vectorMap = new HashMap<String, Double>();
                    vectorMap.put("x", vector.getX());
                    vectorMap.put("y", vector.getY());
                    vectorMap.put("z", vector.getZ());
                    return vectorMap;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    ArrayList newList = new ArrayList();
                    for (Object element : list) {
                        HashMap<String, Object> parsedElement = new HashMap<String, Object>();
                        ValueType insideType = ValueType.getByObject(element);
                        if (insideType == null) {
                            insideType = ValueType.TEXT;
                        }
                        parsedElement.put("type", insideType.name());
                        parsedElement.put("value", this.serializeObject(element));
                        newList.add(parsedElement);
                    }
                    return newList;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    HashMap newMap = new HashMap();
                    for (Object key : map.keySet()) {
                        HashMap<String, Object> newKey = new HashMap<String, Object>();
                        ValueType insideKeyType = ValueType.getByObject(key);
                        if (insideKeyType == null) {
                            insideKeyType = ValueType.TEXT;
                        }
                        newKey.put("type", insideKeyType.name());
                        newKey.put("value", this.serializeObject(key));
                        HashMap<String, Object> newValue = new HashMap<String, Object>();
                        ValueType insideValueType = ValueType.getByObject(key);
                        if (insideValueType == null) {
                            insideValueType = ValueType.TEXT;
                        }
                        newValue.put("type", insideValueType.name());
                        newValue.put("value", this.serializeObject(map.get(key)));
                        String serializedKey = new JSONObject(newKey).toString();
                        newMap.put(serializedKey, newValue);
                    }
                    return newMap;
                }
                if (value instanceof Color) {
                    Color color = (Color)value;
                    HashMap<String, Integer> colorMap = new HashMap<String, Integer>();
                    colorMap.put("red", color.getRed());
                    colorMap.put("green", color.getGreen());
                    colorMap.put("blue", color.getBlue());
                    return colorMap;
                }
                if (value instanceof Particle) {
                    Particle particle = (Particle)value;
                    HashMap<String, String> particleMap = new HashMap<String, String>();
                    particleMap.put("type", particle.name());
                    return particleMap;
                }
                if (value instanceof EventValueLink) {
                    EventValueLink link = (EventValueLink)value;
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.put("name", link.id());
                    return valueMap;
                }
                if (value instanceof VariableLink) {
                    VariableLink link = (VariableLink)value;
                    HashMap<String, String> variableMap = new HashMap<String, String>();
                    variableMap.put("name", link.getName());
                    variableMap.put("type", link.getVariableType().name());
                    return variableMap;
                }
            }
        }
        catch (Exception e) {
            return String.valueOf(value);
        }
        return String.valueOf(value);
    }

    private Object deserializeObject(Object value, ValueType type) {
        try {
            if (type == ValueType.ITEM) {
                ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)((String)value)));
                BukkitObjectInputStream objectInputStream = new BukkitObjectInputStream((InputStream)arrayInputStream);
                value = objectInputStream.readObject();
            } else {
                if (type == ValueType.LOCATION) {
                    Map locationMap = (Map)value;
                    double x = (Double)locationMap.get("x");
                    double y = (Double)locationMap.get("y");
                    double z = (Double)locationMap.get("z");
                    float yaw = ((Double)locationMap.get("yaw")).floatValue();
                    float pitch = ((Double)locationMap.get("pitch")).floatValue();
                    return new Location(this.planet.getTerritory().getWorld(), x, y, z, yaw, pitch);
                }
                if (type == ValueType.VECTOR) {
                    Map vectorMap = (Map)value;
                    double x = (Double)vectorMap.get("x");
                    double y = (Double)vectorMap.get("y");
                    double z = (Double)vectorMap.get("z");
                    return new Vector(x, y, z);
                }
                if (type == ValueType.LIST) {
                    ArrayList newList = new ArrayList();
                    List oldList = (List)value;
                    for (Object element : oldList) {
                        Map insideMap;
                        Object newElement = element;
                        if (newElement instanceof Map && (insideMap = (Map)newElement).containsKey("type") && insideMap.containsKey("value")) {
                            ValueType keyType = ValueType.parseString(insideMap.get("type").toString());
                            newElement = this.deserializeObject(insideMap.get("value"), keyType);
                        } else {
                            newElement = this.deserializeObject(newElement, ValueType.getByObject(newElement));
                        }
                        newList.add(newElement);
                    }
                    return newList;
                }
                if (type == ValueType.MAP) {
                    HashMap newMap = new HashMap();
                    Map oldMap = (Map)value;
                    Iterator y = oldMap.keySet().iterator();
                    while (y.hasNext()) {
                        Map insideMap;
                        Object key;
                        Object newKey = key = y.next();
                        Object newValue = oldMap.get(key);
                        Map deserializedKey = (Map)new JSONParser().parse((String)newKey);
                        newKey = this.deserializeObject(deserializedKey.get("value"), ValueType.parseString(deserializedKey.get("type").toString()));
                        if (newValue instanceof Map && (insideMap = (Map)newValue).containsKey("type") && insideMap.containsKey("value")) {
                            ValueType keyValueType = ValueType.parseString(insideMap.get("type").toString());
                            newValue = this.deserializeObject(insideMap.get("value"), keyValueType);
                        } else {
                            newValue = this.deserializeObject(key, ValueType.getByObject(key));
                        }
                        newMap.put(newKey, newValue);
                    }
                    return newMap;
                }
                if (type == ValueType.COLOR) {
                    Map colorMap = (Map)value;
                    int red = (Integer)colorMap.get("red");
                    int green = (Integer)colorMap.get("green");
                    int blue = (Integer)colorMap.get("blue");
                    return Color.fromRGB((int)red, (int)green, (int)blue);
                }
                if (type == ValueType.PARTICLE) {
                    Map particleMap = (Map)value;
                    String particleType = (String)particleMap.get("type");
                    return Particle.valueOf((String)particleType);
                }
                if (type == ValueType.EVENT_VALUE) {
                    Map eventValueMap = (Map)value;
                    String eventValueType = (String)eventValueMap.get("name");
                    Target target = Target.SELECTED;
                    if (eventValueMap.containsKey("target")) {
                        String targetType = (String)eventValueMap.get("target");
                        target = Target.getByText(targetType);
                    }
                    return new EventValueLink(eventValueType, target);
                }
                if (type == ValueType.VARIABLE) {
                    Map varMap = (Map)value;
                    String varName = (String)varMap.get("name");
                    return new VariableLink(varName, VariableLink.VariableType.SAVED);
                }
            }
        }
        catch (Exception e) {
            return String.valueOf(value);
        }
        return String.valueOf(value);
    }

    public int getTotalVariablesAmount() {
        int size = 0;
        for (WorldVariable var : this.variables) {
            size += var.getSize();
        }
        return size;
    }

    public Planet getPlanet() {
        return this.planet;
    }

    public void garbageCollector(ActionsHandler actionsHandler) {
        this.variables.removeIf(var -> var.getVarType() == VariableLink.VariableType.LOCAL && var.getHandler() != null && var.getHandler().equals(actionsHandler));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "link";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "action";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
        }
        objectArray[1] = "ua/mcchickenstudio/opencreative/coding/variables/WorldVariables";
        objectArray[2] = "getVariable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

