/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.CodeConfiguration;
import ua.mcchickenstudio.opencreative.coding.CodingBlockPlacer;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.indev.Items;
import ua.mcchickenstudio.opencreative.menus.CreativeMenu;
import ua.mcchickenstudio.opencreative.menus.world.WorldModerationMenu;
import ua.mcchickenstudio.opencreative.menus.world.browsers.WorldsPickerMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;
import ua.mcchickenstudio.opencreative.utils.world.generators.FlatGenerator;

public class CreativeCommand
extends CommandHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onExecute(final @NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            CreativeCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            CreativeCommand.$$$reportNull$$$0(2);
        }
        if (args.length > 0) {
            Player player = null;
            if (sender instanceof Player && !CooldownUtils.checkAndSetCooldownWithMessage(player = (Player)sender, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            switch (args[0].toLowerCase()) {
                case "reload": {
                    if (!sender.hasPermission("opencreative.reload")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.reloading"));
                    if (player != null) {
                        Sounds.RELOADING.play((Audience)player);
                    }
                    OpenCreative.getPlugin().reloadConfig();
                    OpenCreative.getSettings().load(OpenCreative.getPlugin().getConfig());
                    FileUtils.loadLocales();
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.reloaded"));
                    if (player == null) return;
                    Sounds.RELOADED.play((Audience)player);
                    return;
                }
                case "updatelocale": {
                    int added;
                    if (!sender.hasPermission("opencreative.updatelocale")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (player != null) {
                        Sounds.RELOADING.play((Audience)player);
                    }
                    if ((added = MessageUtils.addMissingMessageLines()) == -1) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("creative.cant-update-locale"));
                    } else if (added == 0) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("creative.not-updated-locale"));
                    } else {
                        sender.sendMessage(MessageUtils.getLocaleMessage("creative.updated-locale").replace("%amount%", String.valueOf(added)));
                    }
                    if (player == null) return;
                    Sounds.RELOADED.play((Audience)player);
                    return;
                }
                case "resetlocale": {
                    if (!sender.hasPermission("opencreative.resetlocale")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.resetting-locale"));
                    if (player != null) {
                        Sounds.RELOADING.play((Audience)player);
                    }
                    FileUtils.resetLocales();
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.reset-locale"));
                    if (player == null) return;
                    Sounds.RELOADED.play((Audience)player);
                    return;
                }
                case "info": {
                    if (!sender.hasPermission("opencreative.info")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    Planet planet2 = OpenCreative.getPlanetsManager().getPlanetByWorldName("./planets/planet" + args[1]);
                    if (planet2 == null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-planet-found"));
                        return;
                    }
                    long now = System.currentTimeMillis();
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.info").replace("%name%", planet2.getInformation().getDisplayName()).replace("%id%", String.valueOf(planet2.getId())).replace("%creation-time%", MessageUtils.getElapsedTime(now, planet2.getCreationTime())).replace("%activity-time%", MessageUtils.getElapsedTime(now, planet2.getLastActivityTime())).replace("%online%", String.valueOf(planet2.getOnline())).replace("%builders%", planet2.getWorldPlayers().getBuilders()).replace("%coders%", planet2.getWorldPlayers().getDevelopers()).replace("%owner%", planet2.getOwner()).replace("%sharing%", planet2.getSharing().getName()).replace("%mode%", planet2.getMode().getName()).replace("%description%", planet2.getInformation().getDescription()));
                    return;
                }
                case "register": {
                    int id;
                    if (!sender.hasPermission("opencreative.world.register")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    try {
                        id = Integer.parseInt(args[1]);
                    }
                    catch (Exception ignored) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.not-numeric-id"));
                        return;
                    }
                    File planetFolder = new File(FileUtils.getPlanetsStorageFolder(), "planet" + id);
                    if (!planetFolder.exists() || !planetFolder.isDirectory()) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.not-found").replace("%id%", args[1]).replace("%path%", planetFolder.getPath()));
                        return;
                    }
                    if (OpenCreative.getPlanetsManager().getPlanetByWorldName("./planets/planet" + args[1]) != null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.already-registered").replace("%id%", args[1]));
                        return;
                    }
                    Planet newPlanet = new Planet(id);
                    OpenCreative.getPlanetsManager().registerPlanet(newPlanet);
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.registered").replace("%id%", args[1]));
                    return;
                }
                case "unregister": {
                    if (!sender.hasPermission("opencreative.world.unregister")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    String id = args[1];
                    Planet planet3 = OpenCreative.getPlanetsManager().getPlanetById(id);
                    if (planet3 == null) {
                        planet3 = OpenCreative.getPlanetsManager().getPlanetByCustomID(id);
                    }
                    if (planet3 == null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.not-found").replace("%id%", args[1]).replace("%path%", "/join " + id));
                        return;
                    }
                    OpenCreative.getPlanetsManager().unregisterPlanet(planet3);
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.unregistered").replace("%id%", args[1]));
                    return;
                }
                case "updateworld": {
                    if (!sender.hasPermission("opencreative.world.update")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    String id = args[1];
                    Planet planet4 = OpenCreative.getPlanetsManager().getPlanetById(id);
                    if (planet4 == null) {
                        planet4 = OpenCreative.getPlanetsManager().getPlanetByCustomID(id);
                    }
                    if (planet4 == null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.not-found").replace("%id%", args[1]).replace("%path%", "/join " + id));
                        return;
                    }
                    planet4.loadInfo();
                    planet4.getInformation().loadInformation();
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.updated-info").replace("%id%", args[1]));
                    return;
                }
                case "delete": {
                    if (!sender.hasPermission("opencreative.delete")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    Planet planet5 = OpenCreative.getPlanetsManager().getPlanetByWorldName("./planets/planet" + args[1]);
                    if (planet5 == null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-planet-found"));
                        return;
                    }
                    if (!OpenCreative.getPlanetsManager().deletePlanet(planet5)) return;
                    Sounds.WORLD_DELETION.play((Audience)sender);
                    sender.sendMessage(MessageUtils.getLocaleMessage("deleting-world.message"));
                    return;
                }
                case "moderate": 
                case "moderation": {
                    Planet planet6;
                    if (player == null) {
                        return;
                    }
                    if (!sender.hasPermission("opencreative.moderation.menus")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length == 1) {
                        planet6 = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                        if (planet6 == null) {
                            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                            return;
                        }
                    } else {
                        planet6 = OpenCreative.getPlanetsManager().getPlanetById(args[1]);
                        if (planet6 == null) {
                            planet6 = OpenCreative.getPlanetsManager().getPlanetByCustomID(args[1]);
                        }
                    }
                    if (planet6 == null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-planet-found"));
                        return;
                    }
                    new WorldModerationMenu(planet6).open(player);
                    return;
                }
                case "load": {
                    if (!sender.hasPermission("opencreative.world.load")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    Planet planet7 = OpenCreative.getPlanetsManager().getPlanetByWorldName("./planets/planet" + args[1].replace("dev", ""));
                    if (planet7 == null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-planet-found"));
                        return;
                    }
                    if (!planet7.isLoaded()) {
                        planet7.getTerritory().load();
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.loaded").replace("%id%", args[1]));
                        return;
                    }
                    if (args[1].contains("dev") && !planet7.getDevPlanet().isLoaded()) {
                        planet7.getDevPlanet().loadDevPlanetWorld();
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.loaded").replace("%id%", args[1]));
                        return;
                    }
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.already-loaded").replace("%id%", args[1]));
                    return;
                }
                case "dev": {
                    if (!sender.hasPermission("opencreative.world.dev.visit")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    Planet planet8 = OpenCreative.getPlanetsManager().getPlanetByWorldName("./planets/planet" + args[1].replace("dev", ""));
                    if (planet8 == null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-planet-found"));
                        return;
                    }
                    if (planet8.getDevPlanet().isLoaded()) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("world.already-loaded").replace("%id%", args[1]));
                        return;
                    }
                    if (!planet8.isLoaded()) {
                        planet8.getTerritory().load();
                    }
                    planet8.connectToDevPlanet(player);
                    sender.sendMessage(MessageUtils.getLocaleMessage("world.loaded").replace("%id%", args[1]));
                    return;
                }
                case "creative-chat": 
                case "chat": {
                    if (!sender.hasPermission("opencreative.creative-chat")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    if ("disable".equalsIgnoreCase(args[1])) {
                        OpenCreative.getSettings().setCreativeChatEnabled(false);
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            onlinePlayer.sendMessage(MessageUtils.getLocaleMessage("creative.creative-chat.disabled").replace("%player%", sender.getName()));
                        }
                    } else if ("enable".equalsIgnoreCase(args[1])) {
                        OpenCreative.getSettings().setCreativeChatEnabled(true);
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            onlinePlayer.sendMessage(MessageUtils.getLocaleMessage("creative.creative-chat.enabled").replace("%player%", sender.getName()));
                        }
                    }
                    if (!"clear".equalsIgnoreCase(args[1])) return;
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        onlinePlayer.sendMessage("\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n  \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n ");
                        onlinePlayer.sendMessage(MessageUtils.getLocaleMessage("creative.creative-chat.cleared").replace("%player%", sender.getName()));
                    }
                    return;
                }
                case "debug": {
                    if (!sender.hasPermission("opencreative.debug")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    if ("disable".equalsIgnoreCase(args[1]) || "off".equalsIgnoreCase(args[1])) {
                        OpenCreative.getSettings().setDebug(false);
                        sender.sendMessage(MessageUtils.getLocaleMessage("creative.debug.disabled").replace("%player%", sender.getName()));
                        return;
                    }
                    if (!"enable".equalsIgnoreCase(args[1]) && !"on".equalsIgnoreCase(args[1])) return;
                    OpenCreative.getSettings().setDebug(true);
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.debug.enabled").replace("%player%", sender.getName()));
                    return;
                }
                case "locale": 
                case "lang": 
                case "language": {
                    if (!sender.hasPermission("opencreative.locale")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    if (MessageUtils.localizationFileExists(args[1])) {
                        OpenCreative.getPlugin().getConfig().set("messages.locale", (Object)args[1]);
                        OpenCreative.getPlugin().saveConfig();
                        MessageUtils.loadLocalizationFile();
                        sender.sendMessage(MessageUtils.getLocaleMessage("creative.locale.changed"));
                        return;
                    }
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.locale.not-found"));
                    return;
                }
                case "sounds": 
                case "soundtheme": 
                case "soundstheme": {
                    if (!sender.hasPermission("opencreative.sounds.theme")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    if (OpenCreative.getSettings().setSoundsTheme(args[1])) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("creative.sounds.set").replace("%theme%", args[1]));
                        if (player == null) return;
                        Sounds.LOBBY.play((Audience)player);
                        return;
                    }
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.sounds.not-found").replace("%theme%", args[1]));
                    return;
                }
                case "sound": 
                case "playsound": {
                    if (!sender.hasPermission("opencreative.sounds.play")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    try {
                        Sounds sound = Sounds.valueOf(args[1].toUpperCase());
                        sound.play((Audience)sender);
                        return;
                    }
                    catch (Exception sound) {}
                    return;
                }
                case "item": 
                case "items": {
                    if (!sender.hasPermission("opencreative.items.get") && !sender.hasPermission("opencreative.items.set")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (player == null) {
                        return;
                    }
                    if (args.length < 3) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    Items itemType = null;
                    try {
                        itemType = Items.valueOf(args[2].toUpperCase());
                    }
                    catch (Exception error) {
                        Sounds.PLAYER_FAIL.play((Audience)player);
                        return;
                    }
                    switch (args[1].toLowerCase()) {
                        case "get": {
                            player.getInventory().addItem(new ItemStack[]{itemType.get()});
                            return;
                        }
                        case "set": {
                            ItemStack item = player.getInventory().getItemInMainHand();
                            if (item.isEmpty()) {
                                Sounds.PLAYER_FAIL.play((Audience)player);
                                return;
                            }
                            OpenCreative.getSettings().setCustomItem(itemType, item);
                        }
                    }
                    return;
                }
                case "kick-all": {
                    if (!sender.hasPermission("opencreative.kick-all")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 3) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    String nickname = args[2];
                    if ("starts".equalsIgnoreCase(args[1])) {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            if (!onlinePlayer.getName().toLowerCase().startsWith(nickname.toLowerCase())) continue;
                            onlinePlayer.kick();
                        }
                        return;
                    } else if ("ends".equalsIgnoreCase(args[1])) {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            if (!onlinePlayer.getName().toLowerCase().endsWith(nickname.toLowerCase())) continue;
                            onlinePlayer.kick();
                        }
                        return;
                    } else if ("contains".equalsIgnoreCase(args[1])) {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            if (!onlinePlayer.getName().toLowerCase().contains(nickname.toLowerCase())) continue;
                            onlinePlayer.kick();
                        }
                        return;
                    } else {
                        if (!"ignore".equalsIgnoreCase(args[1])) return;
                        List<String> nicknames = new ArrayList<String>(List.of(args)).subList(1, args.length);
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            boolean ignore = false;
                            for (String nick : nicknames) {
                                if (!nick.equalsIgnoreCase(onlinePlayer.getName()) && !onlinePlayer.getName().equalsIgnoreCase(sender.getName())) continue;
                                ignore = true;
                            }
                            if (ignore) continue;
                            onlinePlayer.kick();
                        }
                    }
                    return;
                }
                case "maintenance": {
                    this.handleMaintenanceCommand(sender, Arrays.copyOfRange(args, 0, args.length));
                    return;
                }
                case "unload": {
                    this.handleUnloadCommand(sender, args);
                    return;
                }
                case "update": 
                case "updates": 
                case "checkupdate": {
                    this.handleUpdateCommand(sender);
                    return;
                }
                case "list": {
                    if (!sender.hasPermission("opencreative.list.loaded")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    List<String> worlds = Bukkit.getServer().getWorlds().stream().filter(WorldUtils::isPlanet).map(WorldUtils::getPlanetIdFromName).toList();
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.loaded-worlds-list").replace("%amount%", String.valueOf(worlds.size())) + String.join((CharSequence)", ", worlds));
                    return;
                }
                case "deprecated": {
                    this.handleDeprecatedCommand(sender, args);
                    return;
                }
                case "corrupted": {
                    this.handleCorruptedCommand(sender, args);
                    return;
                }
                case "print": {
                    if (!sender.hasPermission("opencreative.print")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    sender.sendMessage(MessageUtils.getLocaleMessage(args[1]));
                    return;
                }
                case "minimsg": {
                    if (!sender.hasPermission("opencreative.print.minimessage")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length))));
                    return;
                }
                case "stability": {
                    if (!sender.hasPermission("opencreative.stability")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    sender.sendMessage(MessageUtils.getLocaleMessage("creative.stability.actionbar").replace("%memory%", OpenCreative.getStability().getMemoryState().getLocalized()).replace("%storage%", OpenCreative.getStability().getStorageState().getLocalized()).replace("%tps%", OpenCreative.getStability().getTicksState().getLocalized()).replace("%database%", OpenCreative.getStability().getDatabaseState().getLocalized()));
                    return;
                }
                case "test": {
                    if (!sender.hasPermission("opencreative.test")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (player == null) {
                        return;
                    }
                    player.sendMessage("Test of code downloader");
                    if (args.length == 1) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                        return;
                    }
                    final DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
                    if (devPlanet == null) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("only-in-dev-world"));
                        return;
                    }
                    if (!devPlanet.getPlanet().getWorldPlayers().canDevelop(player)) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("not-developer"));
                        return;
                    }
                    final String link = args[1];
                    if (!link.startsWith("https://")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("Not save link. Needs to start with https://"));
                        return;
                    }
                    new BukkitRunnable(this){

                        public void run() {
                            try {
                                URL requestUrl = new URI(link).toURL();
                                HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
                                connection.setConnectTimeout(5000);
                                connection.setReadTimeout(5000);
                                connection.setRequestMethod("GET");
                                connection.setRequestProperty("User-Agent", "OpenCreative+ Code Downloader");
                                connection.setDoOutput(false);
                                int code = connection.getResponseCode();
                                StringBuilder responseBuilder = new StringBuilder();
                                try (BufferedReader reader = new BufferedReader(new InputStreamReader(code >= 400 ? connection.getErrorStream() : connection.getInputStream(), StandardCharsets.UTF_8));){
                                    int read;
                                    char[] buffer = new char[4096];
                                    while ((read = reader.read(buffer)) != -1) {
                                        responseBuilder.append(buffer, 0, read);
                                        if (responseBuilder.length() <= 0x100000) continue;
                                        sender.sendMessage("Too large file");
                                        return;
                                    }
                                }
                                String response = responseBuilder.toString();
                                CodeConfiguration config = new CodeConfiguration();
                                config.loadFromString(response);
                                ConfigurationSection section = config.getConfigurationSection("code.blocks");
                                if (section == null) {
                                    sender.sendMessage("Section does not exists.");
                                    return;
                                }
                                Bukkit.getScheduler().runTask((Plugin)OpenCreative.getPlugin(), () -> {
                                    if (new CodingBlockPlacer(devPlanet).placeCodingLines(devPlanet, section).isSuccess()) {
                                        sender.sendMessage("Placed");
                                    } else {
                                        sender.sendMessage("Failed to place");
                                    }
                                });
                            }
                            catch (Exception e) {
                                sender.sendMessage("Failed to download code");
                            }
                        }
                    }.runTaskAsynchronously((Plugin)OpenCreative.getPlugin());
                    return;
                }
                case "test3": {
                    if (!sender.hasPermission("opencreative.test")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    if (player == null) {
                        return;
                    }
                    player.sendMessage("Test of worlds downloader");
                    WorldsPickerMenu menu = new WorldsPickerMenu(player, new HashSet<Planet>(OpenCreative.getPlanetsManager().getPlanets().stream().filter(planet -> planet.getInformation().isDownloadable()).toList()));
                    menu.open(player);
                    return;
                }
                case "uuid": 
                case "getuuid": {
                    if (!sender.hasPermission("opencreative.getuuid")) {
                        sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                        return;
                    }
                    String text = sender.getName();
                    if (args.length >= 2) {
                        text = args[1];
                    }
                    String uuid = Bukkit.getOfflinePlayer((String)text).getUniqueId().toString();
                    sender.sendMessage(Component.text((String)uuid).clickEvent(ClickEvent.suggestCommand((String)uuid)));
                    return;
                }
                case "template": {
                    this.handleTemplateCommand(sender, args);
                    return;
                }
                default: {
                    String copyright = OpenCreative.getPlugin().getConfig().getString("messages.version", "\n\u00a77 Open\u00a7fCreative\u00a7b+ \u00a77%version%\u00a7f: \u00a7f%codename% \n \u00a7cMcChicken Studio 2017-2025\n ");
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)copyright.replace("%version%", OpenCreative.getVersion()).replace("%codename%", OpenCreative.getCodename())));
                    if (player == null) return;
                    Sounds.OPENCREATIVE.play((Audience)player);
                    new CreativeMenu().open(player);
                }
            }
            return;
        }
        String copyright = OpenCreative.getPlugin().getConfig().getString("messages.version", "\n\u00a77 Open\u00a7fCreative\u00a7b+ \u00a77%version%\u00a7f: \u00a7f%codename% \n \u00a7cMcChicken Studio 2017-2025\n ");
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)copyright.replace("%version%", OpenCreative.getVersion()).replace("%codename%", OpenCreative.getCodename())));
        if (!(sender instanceof Player)) return;
        Player player = (Player)sender;
        Sounds.OPENCREATIVE.play((Audience)player);
        new CreativeMenu().open(player);
    }

    public void handleMaintenanceCommand(@NotNull CommandSender sender, String[] args) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(3);
        }
        if (!sender.hasPermission("opencreative.maintenance")) {
            sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
            return;
        }
        if ("start".equalsIgnoreCase(args[1])) {
            int seconds = 60;
            if (args.length > 2) {
                try {
                    seconds = Integer.parseInt(args[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            OpenCreative.getPlugin().getLogger().info("Maintenance mode will be enabled after " + seconds + " seconds by " + sender.getName());
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                Sounds.MAINTENANCE_NOTIFY.play((Audience)onlinePlayer);
                onlinePlayer.sendMessage(MessageUtils.getLocaleMessage("creative.maintenance.starting-notification").replace("%time%", String.valueOf(seconds)));
            }
            final int time = seconds;
            new BukkitRunnable(this){
                int seconds;
                {
                    this.seconds = time;
                }

                public void run() {
                    if (this.seconds >= 1) {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            onlinePlayer.sendActionBar(MessageUtils.getLocaleMessage("creative.maintenance.starting-in").replace("%time%", String.valueOf(this.seconds)));
                        }
                        if (this.seconds <= 3) {
                            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                                Sounds.MAINTENANCE_COUNT.play((Audience)onlinePlayer);
                                onlinePlayer.sendMessage(MessageUtils.getLocaleMessage("creative.maintenance.starting-in").replace("%time%", String.valueOf(this.seconds)));
                            }
                        }
                        --this.seconds;
                    } else {
                        OpenCreative.getSettings().setMaintenance(true);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)OpenCreative.getPlugin(), 0L, 20L);
        } else if ("end".equalsIgnoreCase(args[1])) {
            OpenCreative.getSettings().setMaintenance(false);
        }
    }

    public void handleTemplateCommand(@NotNull CommandSender sender, String[] args) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(4);
        }
        if (!sender.hasPermission("opencreative.template")) {
            sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
            return;
        }
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            return;
        }
        File template = new File(String.valueOf(OpenCreative.getPlugin().getDataPath()) + File.separator + "templates" + File.separator + args[1]);
        if (!template.exists()) {
            sender.sendMessage("Template doesn't exists.");
            return;
        }
        if (!OpenCreative.getStability().isFine()) {
            player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
            Sounds.PLAYER_FAIL.play((Audience)player);
            return;
        }
        File templateDev = new File(String.valueOf(OpenCreative.getPlugin().getDataPath()) + File.separator + "templates" + File.separator + args[1] + "dev");
        int id = WorldUtils.generateWorldID();
        File world = new File(Bukkit.getWorldContainer().getPath() + File.separator + "planets" + File.separator + "planet" + id + File.separator);
        File worldDev = new File(Bukkit.getWorldContainer().getPath() + File.separator + "planets" + File.separator + "planet" + id + File.separator + "dev");
        FileUtils.copyFilesToDirectory(template, world);
        if (templateDev.exists()) {
            FileUtils.copyFilesToDirectory(templateDev, worldDev);
        }
        OpenCreative.getPlanetsManager().createPlanet(player, id, new FlatGenerator());
    }

    public void handleUpdateCommand(@NotNull CommandSender sender) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(5);
        }
        if (!sender.hasPermission("opencreative.update")) {
            sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
            return;
        }
        ((CompletableFuture)OpenCreative.getUpdater().checkUpdates().thenAccept(version -> {
            if (version.isEmpty()) {
                sender.sendMessage(MessageUtils.getLocaleMessage("creative.updates.up-to-date").replace("%version%", OpenCreative.getPlugin().getPluginMeta().getVersion()));
            } else {
                sender.sendMessage(MessageUtils.getLocaleMessage("creative.updates.available").replace("%new%", (CharSequence)version).replace("%old%", OpenCreative.getPlugin().getPluginMeta().getVersion()));
            }
        })).exceptionally(e -> {
            sender.sendMessage(MessageUtils.getLocaleMessage("creative.updates.cant-check"));
            return null;
        });
    }

    public void handleUnloadCommand(@NotNull CommandSender sender, String[] args) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(6);
        }
        if (!sender.hasPermission("opencreative.world.unload")) {
            sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
            return;
        }
        if (args[1].equalsIgnoreCase("all") || args[1].equalsIgnoreCase("*")) {
            if (!sender.hasPermission("opencreative.world.unload.all")) {
                sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                return;
            }
            for (Planet planet : OpenCreative.getPlanetsManager().getPlanets()) {
                if (planet.isLoaded()) {
                    planet.getTerritory().unload();
                    continue;
                }
                if (!planet.getDevPlanet().isLoaded()) continue;
                planet.getDevPlanet().unload();
            }
            OpenCreative.getPlugin().getLogger().info("All worlds were unloaded by " + sender.getName());
            return;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorldName("./planets/planet" + args[1]);
        if (planet == null) {
            sender.sendMessage(MessageUtils.getLocaleMessage("no-planet-found"));
            return;
        }
        if (planet.isLoaded()) {
            planet.getTerritory().unload();
            sender.sendMessage(MessageUtils.getLocaleMessage("world.unloaded").replace("%id%", args[1]));
        } else if (args[1].contains("dev") && planet.getDevPlanet().isLoaded()) {
            planet.getDevPlanet().unload();
            sender.sendMessage(MessageUtils.getLocaleMessage("world.unloaded").replace("%id%", args[1]));
        } else {
            sender.sendMessage(MessageUtils.getLocaleMessage("world.already-unloaded").replace("%id%", args[1]));
        }
    }

    public void handleLoadCommand(@NotNull CommandSender sender, String[] args) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(7);
        }
    }

    public void handleCorruptedCommand(@NotNull CommandSender sender, String[] args) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(8);
        }
        if (args.length < 3) {
            if (!sender.hasPermission("opencreative.list.corrupted")) {
                sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
                return;
            }
            Set<Planet> corruptedPlanets = OpenCreative.getPlanetsManager().getCorruptedPlanets();
            sender.sendMessage(MessageUtils.getLocaleMessage("creative.corrupted-worlds.list").replace("%amount%", String.valueOf(corruptedPlanets.size())));
            String worldMessage = MessageUtils.getLocaleMessage("creative.corrupted-worlds.world");
            for (Planet planet : corruptedPlanets) {
                sender.sendMessage(Component.text((String)worldMessage.replace("%id%", String.valueOf(planet.getId()))).clickEvent(ClickEvent.runCommand((String)("/oc corrupted " + planet.getId() + " join"))));
            }
            return;
        }
        if (!sender.hasPermission("opencreative.corrupted.recovery")) {
            sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException worldMessage) {
            // empty catch block
        }
        if (id < 0) {
            return;
        }
        Planet foundPlanet = null;
        for (Planet planet : OpenCreative.getPlanetsManager().getCorruptedPlanets()) {
            if (planet.getId() != id) continue;
            foundPlanet = planet;
            break;
        }
        if (foundPlanet == null) {
            sender.sendMessage(MessageUtils.getLocaleMessage("no-planet-found"));
            return;
        }
        String action = args[2];
        switch (action.toLowerCase()) {
            case "teleport": 
            case "tp": 
            case "join": 
            case "load": {
                foundPlanet.getTerritory().load();
                if (!(sender instanceof Player)) break;
                Player player = (Player)sender;
                foundPlanet.connectPlayer(player);
                break;
            }
            case "unload": {
                foundPlanet.getTerritory().unload();
                break;
            }
            case "owner": 
            case "setowner": {
                if (args.length < 4) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("too-few-args"));
                    return;
                }
                sender.sendMessage(MessageUtils.getLocaleMessage("creative.corrupted-worlds.set-owner").replace("%replace%", args[3]));
                if (foundPlanet.getCreationTime() == 0L) {
                    FileUtils.setPlanetConfigParameter(foundPlanet, "creation-time", System.currentTimeMillis());
                }
                if (foundPlanet.getLastActivityTime() == 0L) {
                    FileUtils.setPlanetConfigParameter(foundPlanet, "last-activity-time", System.currentTimeMillis());
                }
                foundPlanet.setOwner(args[3]);
                OpenCreative.getPlanetsManager().getCorruptedPlanets().remove(foundPlanet);
                Planet planet = new Planet(foundPlanet.getId());
                OpenCreative.getPlanetsManager().registerPlanet(planet);
            }
        }
    }

    public void handleDeprecatedCommand(@NotNull CommandSender sender, String[] args) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(9);
        }
        if (!sender.hasPermission("opencreative.list.deprecated")) {
            sender.sendMessage(MessageUtils.getLocaleMessage("no-perms"));
            return;
        }
        int months = 1;
        if (args.length >= 2) {
            try {
                months = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (months < 1) {
            months = 1;
        }
        long currentTime = System.currentTimeMillis();
        ArrayList<Planet> deprecatedWorlds = new ArrayList<Planet>();
        for (Planet planet : OpenCreative.getPlanetsManager().getPlanets()) {
            OfflinePlayer planetOwner;
            long monthsInMillis = 2592000000L * (long)months;
            if (currentTime - planet.getCreationTime() <= monthsInMillis || OpenCreative.getPlanetsManager().getRecommendedPlanets().contains(planet) || (planetOwner = Bukkit.getOfflinePlayer((String)planet.getOwner())).getLastSeen() != 0L && currentTime - planetOwner.getLastLogin() <= monthsInMillis) continue;
            deprecatedWorlds.add(planet);
        }
        String worldMessage = MessageUtils.getLocaleMessage("creative.deprecated-worlds.world");
        for (Planet planet : deprecatedWorlds) {
            sender.sendMessage(Component.text((String)worldMessage.replace("%id%", String.valueOf(planet.getId())).replace("%owner%", planet.getOwner()).replace("%created%", MessageUtils.getElapsedTime(currentTime, planet.getCreationTime())).replace("%seen%", MessageUtils.getElapsedTime(currentTime, Bukkit.getOfflinePlayer((String)planet.getOwner()).getLastSeen()))).clickEvent(ClickEvent.runCommand((String)("/oc delete " + planet.getId()))));
        }
        sender.sendMessage(MessageUtils.getLocaleMessage("creative.deprecated-worlds.list").replace("%amount%", String.valueOf(deprecatedWorlds.size())));
    }

    @Override
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (sender == null) {
            CreativeCommand.$$$reportNull$$$0(10);
        }
        if (command == null) {
            CreativeCommand.$$$reportNull$$$0(11);
        }
        if (alias == null) {
            CreativeCommand.$$$reportNull$$$0(12);
        }
        ArrayList<String> tabCompleter = new ArrayList<String>();
        if (!sender.hasPermission("opencreative.admin")) {
            return null;
        }
        if (args.length == 1) {
            tabCompleter.add("update");
            tabCompleter.add("moderation");
            tabCompleter.add("reload");
            tabCompleter.add("locale");
            tabCompleter.add("debug");
            tabCompleter.add("maintenance");
            tabCompleter.add("stability");
            tabCompleter.add("load");
            tabCompleter.add("unload");
            tabCompleter.add("resetlocale");
            tabCompleter.add("updatelocale");
            tabCompleter.add("creative-chat");
            tabCompleter.add("kick-all");
            tabCompleter.add("list");
            tabCompleter.add("deprecated");
            tabCompleter.add("corrupted");
            tabCompleter.add("sound");
            tabCompleter.add("sounds");
            tabCompleter.add("register");
            tabCompleter.add("unregister");
            tabCompleter.add("updateworld");
        } else if (args.length == 2) {
            if ("maintenance".equalsIgnoreCase(args[0])) {
                tabCompleter.add("start");
                tabCompleter.add("end");
            } else if ("kick-all".equalsIgnoreCase(args[0])) {
                tabCompleter.add("starts");
                tabCompleter.add("ends");
                tabCompleter.add("contains");
                tabCompleter.add("ignore");
            } else if ("creative-chat".equalsIgnoreCase(args[0])) {
                tabCompleter.add("enable");
                tabCompleter.add("disable");
                tabCompleter.add("clear");
            } else if ("debug".equalsIgnoreCase(args[0])) {
                tabCompleter.add("enable");
                tabCompleter.add("disable");
            } else if (List.of("load", "unload", "moderate", "moderation", "updateworld", "unregister", "delete").contains(args[0].toLowerCase())) {
                tabCompleter.addAll(OpenCreative.getPlanetsManager().getPlanets().stream().map(planet -> String.valueOf(planet.getId())).toList());
            } else if ("corrupted".equalsIgnoreCase(args[0])) {
                tabCompleter.addAll(OpenCreative.getPlanetsManager().getCorruptedPlanets().stream().map(planet -> String.valueOf(planet.getId())).toList());
            } else if ("locale".equalsIgnoreCase(args[0])) {
                tabCompleter.add("en");
                tabCompleter.add("ru");
            } else if ("sounds".equalsIgnoreCase(args[0])) {
                ConfigurationSection config = OpenCreative.getPlugin().getConfig().getConfigurationSection("sounds");
                if (config == null) {
                    return null;
                }
                tabCompleter.addAll(config.getKeys(false));
                tabCompleter.remove("theme");
            } else if ("sound".equalsIgnoreCase(args[0]) || "playsound".equalsIgnoreCase(args[0])) {
                tabCompleter.addAll(Arrays.stream(Sounds.values()).map(s -> s.name().toLowerCase()).filter(s -> s.startsWith(args[1].toLowerCase())).toList());
            } else if ("item".equalsIgnoreCase(args[0]) || "items".equalsIgnoreCase(args[0])) {
                tabCompleter.addAll(Arrays.stream(Items.values()).map(s -> s.name().toLowerCase()).filter(s -> s.startsWith(args[1].toLowerCase())).toList());
            }
        } else if (args.length == 3) {
            if ("start".equalsIgnoreCase(args[1])) {
                tabCompleter.add("120");
                tabCompleter.add("60");
                tabCompleter.add("30");
                tabCompleter.add("15");
            } else if ("corrupted".equalsIgnoreCase(args[0])) {
                tabCompleter.add("owner");
                tabCompleter.add("join");
                tabCompleter.add("unload");
            }
        }
        return tabCompleter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/CreativeCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleMaintenanceCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleTemplateCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleUpdateCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleUnloadCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleLoadCommand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "handleCorruptedCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDeprecatedCommand";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

