/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.minecraft;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class TeleportCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        block37: {
            if (sender == null) {
                TeleportCommand.$$$reportNull$$$0(0);
            }
            if (command == null) {
                TeleportCommand.$$$reportNull$$$0(1);
            }
            if (label == null) {
                TeleportCommand.$$$reportNull$$$0(2);
            }
            if (!(sender instanceof Player)) {
                Bukkit.getServer().dispatchCommand(sender, "minecraft:tp " + String.join((CharSequence)" ", args));
                return;
            }
            Player player = (Player)sender;
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            if (!player.hasPermission("opencreative.teleport.bypass")) {
                Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                if (planet == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                    return;
                }
                if (!(planet.isOwner(player) || planet.getWorldPlayers().canDevelop(player) || planet.getWorldPlayers().canBuild(player))) {
                    player.sendMessage(MessageUtils.getLocaleMessage("not-owner"));
                    return;
                }
                if (OpenCreative.getPlanetsManager().getDevPlanet(player) != null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                    return;
                }
            }
            if (args.length == 1) {
                Planet planet;
                Player teleportToPlayer = Bukkit.getPlayer((String)args[0]);
                if (teleportToPlayer == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    return;
                }
                Planet teleportPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(teleportToPlayer);
                if (!player.hasPermission("opencreative.teleport.bypass")) {
                    planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                    if (planet == null || !planet.equals(teleportPlanet)) {
                        player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                        return;
                    }
                    if (OpenCreative.getPlanetsManager().getDevPlanet(teleportToPlayer) != null) {
                        player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                        return;
                    }
                }
                if (!player.hasPermission("opencreative.teleport.clear-bypass")) {
                    if (!player.getWorld().equals((Object)teleportToPlayer.getWorld())) {
                        PlayerUtils.clearPlayer(player);
                    }
                    if ((planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player)) == null || !planet.equals(teleportPlanet)) {
                        teleportPlanet.connectPlayer(player);
                    } else {
                        player.teleport(teleportToPlayer.getLocation());
                    }
                } else {
                    player.teleport(teleportToPlayer.getLocation());
                }
                Sounds.PLAYER_TELEPORT.play((Audience)player);
                if (!player.getWorld().equals((Object)teleportToPlayer.getWorld()) && !player.hasPermission("opencreative.teleport.clear-bypass")) {
                    PlayerUtils.clearPlayer(player);
                }
            } else if (args.length == 2) {
                Player firstPlayer = Bukkit.getPlayer((String)args[0]);
                if (firstPlayer == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    return;
                }
                Player secondPlayer = Bukkit.getPlayer((String)args[1]);
                if (secondPlayer == null) {
                    player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                    return;
                }
                Planet firstPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(firstPlayer);
                Planet secondPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(secondPlayer);
                if (!player.hasPermission("opencreative.teleport.others-bypass")) {
                    Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                    if (!(planet != null && planet.equals(firstPlanet) && planet.equals(secondPlanet) && firstPlanet.equals(secondPlanet))) {
                        player.sendMessage(MessageUtils.getLocaleMessage("no-player-found"));
                        return;
                    }
                    if (OpenCreative.getPlanetsManager().getDevPlanet(firstPlayer) != null || OpenCreative.getPlanetsManager().getDevPlanet(secondPlayer) != null) {
                        player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                        return;
                    }
                }
                if (!firstPlayer.getWorld().equals((Object)secondPlayer.getWorld()) && !player.hasPermission("opencreative.teleport.clear-bypass")) {
                    PlayerUtils.clearPlayer(firstPlayer);
                }
                firstPlayer.teleport(secondPlayer.getLocation());
                Sounds.PLAYER_TELEPORT.play((Audience)firstPlayer);
                if (!firstPlayer.getWorld().equals((Object)secondPlayer.getWorld()) && !firstPlayer.hasPermission("opencreative.teleport.clear-bypass")) {
                    PlayerUtils.clearPlayer(firstPlayer);
                }
            } else if (args.length >= 3) {
                Location location = player.getLocation();
                float yaw = location.getYaw();
                float pitch = location.getPitch();
                try {
                    Location newLocation;
                    double x = this.parseCoordinate(args[0], location.getX());
                    double y = this.parseCoordinate(args[1], location.getY());
                    double z = this.parseCoordinate(args[2], location.getZ());
                    if (args.length >= 4) {
                        yaw = this.parseCoordinate(args[3], location.getYaw());
                    }
                    if (args.length >= 5) {
                        pitch = this.parseCoordinate(args[3], location.getPitch());
                    }
                    if (!BlockUtils.isOutOfBorders(newLocation = new Location(location.getWorld(), x, y, z, yaw, pitch))) {
                        player.teleport(newLocation);
                        Sounds.PLAYER_TELEPORT.play((Audience)player);
                        break block37;
                    }
                    sender.sendMessage(MessageUtils.getLocaleMessage("commands.teleport.out-of-borders"));
                }
                catch (NumberFormatException exception) {
                    sender.sendMessage(MessageUtils.getLocaleMessage("commands.teleport.help"));
                }
            } else {
                sender.sendMessage(MessageUtils.getLocaleMessage("commands.teleport.help"));
                return;
            }
        }
    }

    private double parseCoordinate(String arg, double current) throws NumberFormatException {
        if (arg.startsWith("~")) {
            return arg.equals("~") ? current : current + Double.parseDouble(arg.substring(1));
        }
        return Double.parseDouble(arg);
    }

    private float parseCoordinate(String arg, float current) throws NumberFormatException {
        if (arg.startsWith("~")) {
            return arg.equals("~") ? current : current + Float.parseFloat(arg.substring(1));
        }
        return Float.parseFloat(arg);
    }

    @Override
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            TeleportCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            TeleportCommand.$$$reportNull$$$0(4);
        }
        if (label == null) {
            TeleportCommand.$$$reportNull$$$0(5);
        }
        if (args.length >= 3) {
            return null;
        }
        if (!(sender instanceof Player)) {
            return new ArrayList<String>(Bukkit.getOnlinePlayers().stream().map(Player::getName).toList());
        }
        Player player = (Player)sender;
        return player.getWorld().getPlayers().stream().map(Player::getName).toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/minecraft/TeleportCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

