/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.world;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.AdvertisedEvent;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.commands.world.JoinCommand;
import ua.mcchickenstudio.opencreative.events.planet.PlanetAdvertisementEvent;
import ua.mcchickenstudio.opencreative.events.planet.PlanetInviteEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class AdvertisementCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            AdvertisementCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            AdvertisementCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            AdvertisementCommand.$$$reportNull$$$0(2);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtils.getLocaleMessage("only-players"));
            return;
        }
        Player player = (Player)sender;
        if (OpenCreative.getSettings().isMaintenance() && !player.hasPermission("opencreative.maintenance.bypass")) {
            player.sendMessage(MessageUtils.getLocaleMessage("maintenance"));
            return;
        }
        if (OpenCreative.getStability().isVeryBad() && !player.hasPermission("opencreative.stability.bypass")) {
            player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
            return;
        }
        switch (args.length) {
            case 0: {
                AdvertisementCommand.handlePlanetAdvertisement(player, OpenCreative.getPlanetsManager().getPlanetByPlayer(player));
                break;
            }
            case 1: {
                if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                    return;
                }
                JoinCommand.handlePlayerConnection(player, args[0]);
                break;
            }
            case 2: {
                this.handlePlanetInvitation(player, args[0], args[1]);
            }
        }
    }

    public static void handlePlanetAdvertisement(Player player, Planet planet) {
        if (planet == null) {
            player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
            return;
        }
        if (CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND) > 0) {
            player.sendMessage(MessageUtils.getLocaleMessage("advertisement.cooldown").replace("%cooldown%", String.valueOf(CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND))));
            return;
        }
        if (planet.getSharing() != Planet.Sharing.PUBLIC) {
            player.sendMessage(MessageUtils.getLocaleMessage("advertisement.closed-world"));
            return;
        }
        PlanetAdvertisementEvent event = new PlanetAdvertisementEvent(planet, player);
        event.callEvent();
        if (event.isCancelled()) {
            return;
        }
        if (OpenCreative.getEconomy().isEnabled()) {
            double advertisementPrice;
            double playerBalance = OpenCreative.getEconomy().getBalance((OfflinePlayer)player).doubleValue();
            if (playerBalance < (advertisementPrice = OpenCreative.getSettings().getGroups().getGroup(player).getAdvertisementPrice())) {
                player.sendMessage(MessageUtils.getPlayerLocaleMessage("advertisement.no-money", (OfflinePlayer)player).replace("%money%", String.valueOf(Math.round(advertisementPrice - playerBalance))));
                return;
            }
            OpenCreative.getEconomy().withdrawMoney((OfflinePlayer)player, advertisementPrice);
        }
        CooldownUtils.setCooldown(player, OpenCreative.getSettings().getGroups().getGroup(player).getAdvertisementCooldown(), CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND);
        new AdvertisedEvent(player).callEvent();
        Component advertisementMessage = AdvertisementCommand.createAdvertisementMessage(player, planet);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.sendMessage(advertisementMessage);
        }
    }

    private void handlePlanetInvitation(Player player, String planetId, String inviteeName) {
        Player inviteReceiver = Bukkit.getPlayer((String)inviteeName);
        if (inviteReceiver == null) {
            player.sendMessage(MessageUtils.getPlayerLocaleMessage("no-player-found", (OfflinePlayer)player));
            return;
        }
        if (player.equals((Object)inviteReceiver)) {
            player.sendMessage(MessageUtils.getPlayerLocaleMessage("same-world", (OfflinePlayer)player));
            return;
        }
        Planet foundPlanet = JoinCommand.findPlanet(planetId);
        if (foundPlanet == null) {
            Sounds.PLAYER_FAIL.play((Audience)player);
            player.clearTitle();
            player.sendMessage(MessageUtils.getPlayerLocaleMessage("no-planet-found", (OfflinePlayer)player));
            return;
        }
        if (foundPlanet.getSharing() != Planet.Sharing.PUBLIC) {
            player.sendMessage(MessageUtils.getLocaleMessage("advertisement.closed-world"));
            return;
        }
        if (CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND) > 0) {
            player.sendMessage(MessageUtils.getLocaleMessage("advertisement.cooldown").replace("%cooldown%", String.valueOf(CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND))));
            return;
        }
        PlanetInviteEvent event = new PlanetInviteEvent(foundPlanet, player, inviteReceiver);
        event.callEvent();
        if (event.isCancelled()) {
            return;
        }
        CooldownUtils.setCooldown(player, OpenCreative.getSettings().getGroups().getGroup(player).getAdvertisementCooldown(), CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND);
        Component advertisementMessage = AdvertisementCommand.createAdvertisementMessage(player, foundPlanet);
        inviteReceiver.sendMessage(advertisementMessage);
        player.sendMessage(advertisementMessage);
    }

    private static Component createAdvertisementMessage(Player player, Planet planet) {
        Component advertisement = MessageUtils.getLocaleComponent("advertisement.message", (OfflinePlayer)player).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%world%").replacement((ComponentLike)planet.getInformation().displayName()).build());
        Component hoverComponent = MessageUtils.parsePlanetLines(planet, MessageUtils.getLocaleComponent("advertisement.hover"));
        String clickCommand = "/ad " + planet.getId();
        advertisement = advertisement.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent)).clickEvent(ClickEvent.runCommand((String)clickCommand));
        return advertisement;
    }

    @Override
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (sender == null) {
            AdvertisementCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            AdvertisementCommand.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            AdvertisementCommand.$$$reportNull$$$0(5);
        }
        return switch (args.length) {
            case 1 -> OpenCreative.getPlanetsManager().getPlanets().stream().map(planet -> planet.getInformation().getCustomID()).filter(id -> id.startsWith(args[0])).toList();
            case 2 -> Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.startsWith(args[1])).toList();
            default -> Collections.emptyList();
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/world/AdvertisementCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

