/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.commands.world.reputation;

import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.CommandHandler;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class DislikeCommand
extends CommandHandler {
    @Override
    public void onExecute(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            DislikeCommand.$$$reportNull$$$0(0);
        }
        if (command == null) {
            DislikeCommand.$$$reportNull$$$0(1);
        }
        if (label == null) {
            DislikeCommand.$$$reportNull$$$0(2);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
            if (planet == null) {
                player.sendMessage(MessageUtils.getLocaleMessage("only-in-world"));
                return;
            }
            if (!CooldownUtils.checkAndSetCooldownWithMessage(player, CooldownUtils.CooldownType.GENERIC_COMMAND)) {
                return;
            }
            long createdSeconds = (System.currentTimeMillis() - planet.getCreationTime()) / 1000L;
            if ((long)OpenCreative.getSettings().getWorldReputationMinSeconds() > createdSeconds) {
                Sounds.PLAYER_CANCEL.play((Audience)player);
                long unlockTime = ((long)OpenCreative.getSettings().getWorldReputationMinSeconds() - createdSeconds) * 1000L;
                player.sendMessage(MessageUtils.getPlayerLocaleMessage("world.cant-rate", (OfflinePlayer)player).replace("%time%", MessageUtils.convertTime(unlockTime)));
                return;
            }
            if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.LIKED).contains(sender.getName())) {
                sender.sendMessage(MessageUtils.getLocaleMessage("world.already-rated"));
            } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DISLIKED).contains(sender.getName())) {
                sender.sendMessage(MessageUtils.getLocaleMessage("world.already-rated"));
            } else if (FileUtils.addPlayerInPlanetList(planet, sender.getName(), Planet.PlayersType.DISLIKED)) {
                planet.getInformation().setPlanetReputation(planet.getInformation().getReputation() - 1);
                Sounds.WORLD_DISLIKED.play((Audience)player);
                sender.sendMessage(MessageUtils.getPlayerLocaleMessage("world.disliked", (OfflinePlayer)player));
            }
        }
    }

    @Override
    @Nullable
    public List<String> onTab(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (sender == null) {
            DislikeCommand.$$$reportNull$$$0(3);
        }
        if (command == null) {
            DislikeCommand.$$$reportNull$$$0(4);
        }
        if (alias == null) {
            DislikeCommand.$$$reportNull$$$0(5);
        }
        if (args == null) {
            DislikeCommand.$$$reportNull$$$0(6);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/commands/world/reputation/DislikeCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onExecute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "onTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

