/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.indev;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataType;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public class CutsceneHelpTest {
    private final DevPlanet devPlanet;

    public CutsceneHelpTest(DevPlanet devPlanet) {
        this.devPlanet = devPlanet;
    }

    private ItemStack getChestPlate() {
        ItemStack chestPlate = new ItemStack(Material.LEATHER_CHESTPLATE);
        LeatherArmorMeta chestPlateMeta = (LeatherArmorMeta)chestPlate.getItemMeta();
        chestPlateMeta.setColor(Color.fromRGB((int)199, (int)199, (int)199));
        chestPlate.setItemMeta((ItemMeta)chestPlateMeta);
        return chestPlate;
    }

    private ItemStack getLeggings() {
        ItemStack leggings = new ItemStack(Material.LEATHER_LEGGINGS);
        LeatherArmorMeta leggingsMeta = (LeatherArmorMeta)leggings.getItemMeta();
        leggingsMeta.setColor(Color.fromRGB((int)92, (int)92, (int)92));
        leggings.setItemMeta((ItemMeta)leggingsMeta);
        return leggings;
    }

    private ItemStack getBoots() {
        ItemStack boots = new ItemStack(Material.LEATHER_BOOTS);
        LeatherArmorMeta bootsMeta = (LeatherArmorMeta)boots.getItemMeta();
        bootsMeta.setColor(Color.fromRGB((int)64, (int)64, (int)64));
        boots.setItemMeta((ItemMeta)bootsMeta);
        return boots;
    }

    private void setupArmorStand(ArmorStand stand) {
        stand.getPersistentDataContainer().set(ItemUtils.getCodingValueKey(), PersistentDataType.STRING, (Object)"cutscene");
        stand.setArms(true);
        stand.setBasePlate(false);
        stand.getEquipment().setHelmet(new ItemStack(Material.PLAYER_HEAD));
        stand.getEquipment().setChestplate(this.getChestPlate());
        stand.getEquipment().setLeggings(this.getLeggings());
        stand.getEquipment().setBoots(this.getBoots());
    }

    public void clearEntities() {
        if (!this.devPlanet.isLoaded()) {
            return;
        }
        for (Entity entity : this.devPlanet.getWorld().getEntities()) {
            if (!entity.getPersistentDataContainer().has(ItemUtils.getCodingValueKey())) continue;
            entity.remove();
        }
    }

    public void start() {
        if (!this.devPlanet.isLoaded()) {
            return;
        }
        Location location = new Location(this.devPlanet.getWorld(), 2.0, 1.0, 2.0);
        ArmorStand stand = (ArmorStand)this.devPlanet.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        this.setupArmorStand(stand);
    }
}

