/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.indev.messages;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.indev.messages.PlaceholderReplacer;
import ua.mcchickenstudio.opencreative.indev.messages.TranslationManager;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public class YamlTranslation
implements TranslationManager {
    private final Map<String, Map<String, String>> translation = new HashMap<String, Map<String, String>>();

    @Override
    public void init() {
        File[] localesFolders;
        this.translation.clear();
        File localesFolder = this.getLocalesFolder();
        if (!localesFolder.exists()) {
            try {
                if (!localesFolder.mkdir()) {
                    ErrorUtils.sendWarningErrorMessage("Failed to create folder: " + localesFolder.getPath());
                }
            }
            catch (Exception exception) {
                ErrorUtils.sendWarningMessage("Failed to create folder: " + localesFolder.getPath(), exception);
            }
        }
        if ((localesFolders = localesFolder.listFiles()) == null || localesFolders.length == 0) {
            this.addDefaultLocales(false);
            localesFolders = localesFolder.listFiles();
            if (localesFolders == null || localesFolders.length == 0) {
                ErrorUtils.sendWarningErrorMessage("Can't load default locales");
                return;
            }
        }
        for (File localeFile : localesFolders) {
            if (localeFile.isDirectory() || !localeFile.getPath().endsWith(".yml")) continue;
            String translationName = localeFile.getName().replace(".yml", "");
            HashMap<String, String> newTranslation = new HashMap<String, String>();
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)localeFile);
            for (String key : config.getKeys(true)) {
                List contentList = config.getStringList(key);
                String contentString = config.getString(key);
                if (!contentList.isEmpty()) {
                    contentString = String.join((CharSequence)"\n", contentList);
                }
                newTranslation.put(key, contentString);
            }
            OpenCreative.getPlugin().getLogger().info("Loaded locale: " + translationName);
            this.translation.put(translationName, newTranslation);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull String path) {
        if (path == null) {
            YamlTranslation.$$$reportNull$$$0(0);
        }
        String defaultLanguage = "en";
        Component component = YamlTranslation.textToComponent(this.getContent(path, defaultLanguage)).replaceText(new PlaceholderReplacer("prefix", "OpenCreative").get());
        if (component == null) {
            YamlTranslation.$$$reportNull$$$0(1);
        }
        return component;
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull String path, @NotNull String locale) {
        if (path == null) {
            YamlTranslation.$$$reportNull$$$0(2);
        }
        if (locale == null) {
            YamlTranslation.$$$reportNull$$$0(3);
        }
        Component component = YamlTranslation.textToComponent(this.getContent(path, locale)).replaceText(new PlaceholderReplacer("prefix", "OpenCreative").get());
        if (component == null) {
            YamlTranslation.$$$reportNull$$$0(4);
        }
        return component;
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull String path, @NotNull OfflinePlayer player) {
        if (path == null) {
            YamlTranslation.$$$reportNull$$$0(5);
        }
        if (player == null) {
            YamlTranslation.$$$reportNull$$$0(6);
        }
        Component component = this.getMessage(path);
        if (component == null) {
            YamlTranslation.$$$reportNull$$$0(7);
        }
        return component;
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull String path, @NotNull CommandSender sender) {
        if (path == null) {
            YamlTranslation.$$$reportNull$$$0(8);
        }
        if (sender == null) {
            YamlTranslation.$$$reportNull$$$0(9);
        }
        if (sender instanceof OfflinePlayer) {
            OfflinePlayer player = (OfflinePlayer)sender;
            Component component = this.getMessage(path, player);
            if (component == null) {
                YamlTranslation.$$$reportNull$$$0(10);
            }
            return component;
        }
        Component component = this.getMessage(path);
        if (component == null) {
            YamlTranslation.$$$reportNull$$$0(11);
        }
        return component;
    }

    @Nullable
    public Map<String, String> getTranslation(@NotNull String locale) {
        if (locale == null) {
            YamlTranslation.$$$reportNull$$$0(12);
        }
        return this.translation.get(locale);
    }

    @NotNull
    public String getContent(@NotNull String path, @NotNull String locale) {
        Map<String, String> localeTranslation;
        if (path == null) {
            YamlTranslation.$$$reportNull$$$0(13);
        }
        if (locale == null) {
            YamlTranslation.$$$reportNull$$$0(14);
        }
        if ((localeTranslation = this.getTranslation(locale)) == null) {
            String string = path;
            if (string == null) {
                YamlTranslation.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = localeTranslation.getOrDefault(path, path);
        if (string == null) {
            YamlTranslation.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void addDefaultLocales(boolean replace) {
        OpenCreative.getPlugin().saveResource("locales" + File.separator + "en.yml", replace);
    }

    @Override
    @NotNull
    public String getName() {
        return "Yaml Translation Manager";
    }

    @NotNull
    public File getLocalesFolder() {
        return new File(OpenCreative.getPlugin().getDataFolder().getPath() + File.separator + "locales");
    }

    @NotNull
    private static Component textToComponent(@NotNull String text) {
        if (text == null) {
            YamlTranslation.$$$reportNull$$$0(17);
        }
        if (text.contains("&")) {
            TextComponent textComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(text);
            if (textComponent == null) {
                YamlTranslation.$$$reportNull$$$0(18);
            }
            return textComponent;
        }
        Component component = MiniMessage.miniMessage().deserialize((Object)text);
        if (component == null) {
            YamlTranslation.$$$reportNull$$$0(19);
        }
        return component;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7, 10, 11, 15, 16, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/indev/messages/YamlTranslation";
                break;
            }
            case 3: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/indev/messages/YamlTranslation";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "textToComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTranslation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "textToComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 7, 10, 11, 15, 16, 18, 19 -> new IllegalStateException(string);
        };
    }
}

