/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.events.planet.PlanetConnectPlayerEvent;
import ua.mcchickenstudio.opencreative.events.planet.PlanetDisconnectPlayerEvent;
import ua.mcchickenstudio.opencreative.events.player.CreativeChatEvent;
import ua.mcchickenstudio.opencreative.events.player.PlayerLobbyEvent;
import ua.mcchickenstudio.opencreative.events.player.WorldChatEvent;
import ua.mcchickenstudio.opencreative.events.status.MaintenanceEndEvent;
import ua.mcchickenstudio.opencreative.events.status.MaintenanceStartEvent;

public final class CreativeListener
implements Listener {
    @EventHandler
    public void onEvent(PlayerLobbyEvent event) {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("%player%", event.getPlayer().getName());
        OpenCreative.getSettings().getCommands().execute(event.getPlayer(), "onLobby", placeholders);
    }

    @EventHandler
    public void onEvent(CreativeChatEvent event) {
        CommandSender commandSender = event.getSender();
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("%player%", event.getSender().getName());
        placeholders.put("%message%", event.getMessage());
        placeholders.put("%formatted%", event.getFormattedMessage());
        OpenCreative.getSettings().getCommands().execute(player, "onCreativeChat", placeholders);
    }

    @EventHandler
    public void onEvent(WorldChatEvent event) {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("%player%", event.getPlayer().getName());
        placeholders.put("%world%", event.getPlayer().getWorld().getName());
        placeholders.put("%message%", event.getMessage());
        placeholders.put("%formatted%", event.getFormattedMessage());
        OpenCreative.getSettings().getCommands().execute(event.getPlayer(), "onWorldChat", placeholders);
    }

    @EventHandler
    public void onEvent(PlanetConnectPlayerEvent event) {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("%player%", event.getPlayer().getName());
        placeholders.put("%planet%", event.getPlanet().getId());
        OpenCreative.getSettings().getCommands().execute(event.getPlayer(), "onPlanetConnect", placeholders);
    }

    @EventHandler
    public void onEvent(PlanetDisconnectPlayerEvent event) {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("%player%", event.getPlayer().getName());
        placeholders.put("%planet%", event.getPlanet().getId());
        OpenCreative.getSettings().getCommands().execute(event.getPlayer(), "onPlanetDisconnect", placeholders);
    }

    @EventHandler
    public void onEvent(MaintenanceStartEvent event) {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        CommandSender commandSender = event.getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            placeholders.put("%player%", player.getName());
            OpenCreative.getSettings().getCommands().execute(player, "onMaintenanceStart", placeholders);
        } else if (event.getSender() != null) {
            placeholders.put("%player%", Bukkit.getConsoleSender().getName());
            OpenCreative.getSettings().getCommands().execute(null, "onMaintenanceStart", placeholders);
        } else {
            OpenCreative.getSettings().getCommands().execute(null, "onMaintenanceStart", placeholders);
        }
    }

    @EventHandler
    public void onEvent(MaintenanceEndEvent event) {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        CommandSender commandSender = event.getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            placeholders.put("%player%", player.getName());
            OpenCreative.getSettings().getCommands().execute(player, "onMaintenanceEnd", placeholders);
        } else if (event.getSender() != null) {
            placeholders.put("%player%", Bukkit.getConsoleSender().getName());
            OpenCreative.getSettings().getCommands().execute(null, "onMaintenanceEnd", placeholders);
        } else {
            OpenCreative.getSettings().getCommands().execute(null, "onMaintenanceEnd", placeholders);
        }
    }
}

