/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.entity;

import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.HungerChangeEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.MobDamagesPlayerEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.PlayerDamagedEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.PlayerDamagesMobEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.PlayerDamagesPlayerEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.PlayerKilledMobEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetFlags;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class EntityDamageListener
implements Listener {
    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            final Player victim = (Player)entity;
            final Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(victim);
            if (planet != null) {
                byte playerDamageFlag;
                if (planet.getMode() == Planet.Mode.BUILD) {
                    event.setCancelled(true);
                    if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
                        BukkitRunnable runnable = new BukkitRunnable(this){

                            public void run() {
                                if (planet.isLoaded() && planet.getTerritory().getWorld().equals((Object)victim.getWorld()) && planet.getMode() == Planet.Mode.BUILD) {
                                    victim.teleport(victim.getWorld().getSpawnLocation().add(0.0, 0.5, 0.0));
                                }
                                planet.getTerritory().removeBukkitRunnable(this);
                            }
                        };
                        planet.getTerritory().addBukkitRunnable(runnable);
                        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 1L);
                    }
                }
                if (OpenCreative.getPlanetsManager().getDevPlanet(victim) != null) {
                    event.setCancelled(true);
                }
                if (victim.getLocation().distance(victim.getWorld().getSpawnLocation()) < 5.0) {
                    event.setCancelled(true);
                }
                if ((playerDamageFlag = planet.getFlagValue(PlanetFlags.PlanetFlag.PLAYER_DAMAGE)) == 2) {
                    event.setCancelled(true);
                }
                if (playerDamageFlag == 3 && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                    event.setCancelled(true);
                }
                if (playerDamageFlag == 4 && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                    event.setCancelled(true);
                }
                if (playerDamageFlag == 5 && (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK || event.getCause() == EntityDamageEvent.DamageCause.FALL)) {
                    event.setCancelled(true);
                }
                new PlayerDamagedEvent(victim, event).callEvent();
            } else if (PlayerUtils.isEntityInLobby((Entity)victim)) {
                event.setCancelled(true);
                if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
                    final World world = victim.getWorld();
                    BukkitRunnable runnable = new BukkitRunnable(this){

                        public void run() {
                            if (world.equals((Object)victim.getWorld())) {
                                victim.teleport(world.getSpawnLocation());
                            }
                        }
                    };
                    runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 1L);
                }
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player victim = (Player)entity;
            Entity entity2 = event.getDamager();
            if (entity2 instanceof Player) {
                damager = (Player)entity2;
                planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(damager);
                if (planet != null) {
                    new PlayerDamagesPlayerEvent(damager, victim, event).callEvent();
                }
            } else {
                planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(victim);
                if (planet != null) {
                    new MobDamagesPlayerEvent(victim, event).callEvent();
                }
            }
        } else {
            Object planet = event.getDamager();
            if (planet instanceof Player) {
                damager = (Player)planet;
                planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(damager);
                if (planet != null) {
                    new PlayerDamagesMobEvent(damager, event).callEvent();
                } else if (PlayerUtils.isEntityInLobby((Entity)damager) && OpenCreative.getSettings().isLobbyDisallowDamagingMobs() && !damager.hasPermission("opencreative.lobby.damaging-mobs.bypass")) {
                    event.setCancelled(true);
                    damager.sendActionBar(MessageUtils.getLocaleMessage("not-for-lobby"));
                }
            }
        }
    }

    @EventHandler
    public void onExplosionDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        if (WorldUtils.isLobbyWorld(event.getEntity().getWorld()) && OpenCreative.getSettings().isLobbyDisableExplosions()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        Player player = event.getEntity().getKiller();
        if (player instanceof Player) {
            Player player2 = player;
            if (!(event.getEntity() instanceof Player) && OpenCreative.getPlanetsManager().getPlanetByPlayer(player2) != null) {
                new PlayerKilledMobEvent(player2, (Entity)event.getEntity(), event).callEvent();
            }
        }
    }

    @EventHandler
    public void onHungerChange(FoodLevelChangeEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer((Player)event.getEntity());
        if (PlayerUtils.isEntityInLobby((Entity)event.getEntity())) {
            event.setCancelled(true);
        }
        if (planet != null) {
            if (planet.getMode() == Planet.Mode.BUILD) {
                event.setCancelled(true);
            } else {
                new HungerChangeEvent((Player)event.getEntity(), event).callEvent();
            }
        }
    }
}

