/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.entity;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.World;
import org.bukkit.entity.Boss;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.entity.entities.EntitySpawnEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedEntitiesEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetFlags;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class EntitySpawnListener
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntitySpawn(org.bukkit.event.entity.EntitySpawnEvent event) {
        Entity entity;
        Entity entity2 = entity = event.getEntity();
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Item.class, InventoryHolder.class, CommandMinecart.class}, (Object)entity3, n)) {
            case 0: {
                Item item = (Item)entity3;
                ItemStack newItem = ItemUtils.fixItem(item.getItemStack());
                if (newItem.getType().isAir()) {
                    event.setCancelled(true);
                    break;
                }
                item.setItemStack(newItem);
                break;
            }
            case 1: {
                InventoryHolder holder = (InventoryHolder)entity3;
                for (ItemStack insideItem : holder.getInventory().getContents()) {
                    if (insideItem == null) continue;
                    ItemUtils.fixItem(insideItem);
                }
                break;
            }
            case 2: {
                CommandMinecart minecart = (CommandMinecart)entity3;
                if (!OpenCreative.getSettings().isItemsClearCommandBlocksData()) break;
                minecart.setCommand(null);
                minecart.customName((Component)Component.text((String)""));
                break;
            }
        }
        Component customName = entity.customName();
        if (customName != null) {
            String text = PlainTextComponentSerializer.plainText().serialize(customName);
            int limit = OpenCreative.getSettings().getItemsMaxEntityNameLength();
            if (text.length() > limit) {
                entity.customName((Component)PlainTextComponentSerializer.plainText().deserialize(text.substring(0, limit)));
            }
        }
        World world = event.getLocation().getWorld();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorld(world);
        if (planet != null) {
            int limit = planet.getLimits().getEntitiesLimit();
            int count = planet.getTerritory().getWorld().getEntityCount();
            if (world.getName().contains("dev") && !(event.getEntity() instanceof Item)) {
                event.setCancelled(true);
            }
            if (planet.getDevPlanet() != null && planet.getDevPlanet().getWorld() != null) {
                count += planet.getDevPlanet().getWorld().getEntityCount();
            }
            if (count > limit) {
                event.setCancelled(true);
                if (planet.getOnline() < 1) {
                    return;
                }
                TextComponent warning = new TextComponent(MessageUtils.getLocaleMessage("world.entity-limit").replace("%count%", String.valueOf(limit)));
                warning.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(MessageUtils.getLocaleMessage("world.entity-limit-hover"))}));
                warning.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/world deletemobs"));
                MessageUtils.sendMessageOnce(planet, warning, 3);
                new LimitReachedEntitiesEvent(planet).callEvent();
            } else {
                new EntitySpawnEvent(event).callEvent();
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityPlace(EntityPlaceEvent event) {
        World world = event.getBlock().getWorld();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorld(world);
        if (planet != null) {
            int limit = planet.getLimits().getEntitiesLimit();
            if (world.getEntityCount() > limit) {
                event.setCancelled(true);
                if (planet.getOnline() < 1) {
                    return;
                }
                TextComponent warning = new TextComponent(MessageUtils.getLocaleMessage("world.entity-limit").replace("%count%", String.valueOf(limit)));
                warning.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(MessageUtils.getLocaleMessage("world.entity-limit-hover"))}));
                warning.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/world deletemobs"));
                MessageUtils.sendMessageOnce(planet, warning, 3);
                new LimitReachedEntitiesEvent(planet).callEvent();
            }
        } else if (WorldUtils.isDevPlanet(world)) {
            event.setCancelled(true);
        } else if (WorldUtils.isLobbyWorld(world)) {
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            if (OpenCreative.getSettings().isLobbyDisallowSpawningMobs() && !player.hasPermission("opencreative.lobby.spawning-mobs.bypass")) {
                event.setCancelled(true);
                player.sendActionBar(MessageUtils.getLocaleMessage("not-for-lobby"));
            }
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        World world = event.getEntity().getWorld();
        LivingEntity entity = event.getEntity();
        switch (event.getSpawnReason()) {
            case EGG: 
            case SPAWNER_EGG: 
            case SPAWNER: 
            case DISPENSE_EGG: 
            case TRIAL_SPAWNER: {
                if (!OpenCreative.getSettings().isItemsRemoveBossSpawnEggs() || !(entity instanceof Boss)) break;
                event.setCancelled(true);
            }
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorld(world);
        if (PlayerUtils.isEntityInDevPlanet((Entity)entity) && !(event.getEntity() instanceof Item)) {
            event.setCancelled(true);
        }
        if (planet != null) {
            LivingEntity livingEntity;
            if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.BEEHIVE && !planet.getLimits().canBeeSpawnFromBeehive()) {
                event.setCancelled(true);
            }
            if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL) {
                switch (planet.getFlagValue(PlanetFlags.PlanetFlag.MOB_SPAWN)) {
                    case 3: {
                        if (!(entity instanceof Slime)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case 4: {
                        if (!WorldUtils.isEntityHostile((Entity)entity)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case 5: {
                        if (WorldUtils.isEntityHostile((Entity)entity)) break;
                        event.setCancelled(true);
                    }
                }
                if (world.getEntityCount() >= planet.getLimits().getEntitiesLimit() / 2) {
                    event.setCancelled(true);
                }
            }
            if (planet.getTerritory().getEnvironment() == World.Environment.THE_END && (livingEntity = event.getEntity()) instanceof EnderDragon) {
                EnderDragon dragon = (EnderDragon)livingEntity;
                if (System.currentTimeMillis() - planet.getLastActivityTime() < 10000L) {
                    dragon.setHealth(0.0);
                }
            }
        }
    }

    @EventHandler
    public void onVehicleCreation(VehicleCreateEvent event) {
        Vehicle entity = event.getVehicle();
        if (PlayerUtils.isEntityInDevPlanet((Entity)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        World world = event.getWorld();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorld(world);
        if (planet != null && event.isNewChunk() && world.getEntityCount() >= planet.getLimits().getEntitiesLimit() / 2) {
            for (Entity entity : event.getChunk().getEntities()) {
                entity.remove();
            }
        }
    }
}

