/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.modules.ModuleSettingsMenu;
import ua.mcchickenstudio.opencreative.events.planet.PlanetDisconnectPlayerEvent;
import ua.mcchickenstudio.opencreative.listeners.player.ChatListener;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetFlags;
import ua.mcchickenstudio.opencreative.planets.PlanetPlayer;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class ChangedWorld
implements Listener {
    private static final Map<UUID, Location> developerSetLocation = new HashMap<UUID, Location>();

    public static void addPlayerWithLocation(Player player) {
        developerSetLocation.put(player.getUniqueId(), player.getLocation());
    }

    public static void removePlayerWithLocation(Player player) {
        if (!ChangedWorld.isPlayerWithLocation(player)) {
            return;
        }
        developerSetLocation.remove(player.getUniqueId());
    }

    public static boolean isPlayerWithLocation(Player player) {
        return developerSetLocation.containsKey(player.getUniqueId());
    }

    public static Location getOldLocationPlayerWithLocation(Player player) {
        return developerSetLocation.get(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerWorldChanged(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        PlayerUtils.clearWorldModePermissions(player);
        World oldWorld = event.getFrom();
        World newWorld = player.getWorld();
        ChatListener.confirmation.remove(player);
        ModuleSettingsMenu.removeFromCurrentEditing(player);
        player.clearTitle();
        Planet oldPlanet = OpenCreative.getPlanetsManager().getPlanetByWorld(oldWorld);
        Planet newPlanet = OpenCreative.getPlanetsManager().getPlanetByWorld(newWorld);
        for (Player player2 : oldWorld.getPlayers()) {
            PlayerUtils.hidePlayerInTab(player, player2);
            PlayerUtils.hidePlayerInTab(player2, player);
        }
        for (Player player3 : newWorld.getPlayers()) {
            PlayerUtils.showPlayerFromTab(player, player3);
            PlayerUtils.showPlayerFromTab(player3, player);
        }
        if (oldPlanet != null && oldPlanet == newPlanet) {
            if (WorldUtils.isDevPlanet(newWorld)) {
                if (ChangedWorld.isPlayerWithLocation(player)) {
                    ChangedWorld.removePlayerWithLocation(player);
                }
                for (Player player4 : newPlanet.getPlayers()) {
                    PlayerUtils.showPlayerFromTab(player4, player);
                    PlayerUtils.showPlayerFromTab(player, player4);
                }
            } else if (!ChangedWorld.isPlayerWithLocation(player)) {
                for (Player player5 : oldWorld.getPlayers()) {
                    player5.sendMessage(MessageUtils.getPlayerLocaleMessage("world.dev-mode.left", (OfflinePlayer)player));
                }
                for (Player player6 : newWorld.getPlayers()) {
                    newPlanet.getTerritory().showBorders(player6);
                }
            }
        } else {
            if (!player.hasPermission("opencreative.ignore.world-change-clear")) {
                PlayerUtils.clearPlayer(player);
            }
            player.setLastDeathLocation(null);
            ChangedWorld.removePlayerWithLocation(player);
            if (oldPlanet != null) {
                PlanetPlayer planetPlayer = oldPlanet.getWorldPlayers().getPlanetPlayer(player);
                if (planetPlayer != null) {
                    planetPlayer.save();
                }
                oldPlanet.getWorldPlayers().unregisterPlayer(player);
                new PlanetDisconnectPlayerEvent(oldPlanet, player).callEvent();
                if (oldPlanet.getOnline() > 0) {
                    if (oldPlanet.getFlagValue(PlanetFlags.PlanetFlag.JOIN_MESSAGES) == 1) {
                        for (Player onlinePlayer : oldPlanet.getPlayers()) {
                            onlinePlayer.sendMessage(MessageUtils.getPlayerLocaleMessage("world.left", (OfflinePlayer)player));
                        }
                    }
                    if (oldPlanet.isOwner(player)) {
                        List<String> list = FileUtils.getPlayersFromPlanetList(oldPlanet, Planet.PlayersType.DEVELOPERS_NOT_TRUSTED);
                        List<String> notTrustedBuilders = FileUtils.getPlayersFromPlanetList(oldPlanet, Planet.PlayersType.BUILDERS_NOT_TRUSTED);
                        for (Player p : oldPlanet.getPlayers()) {
                            if (oldPlanet.getMode() == Planet.Mode.BUILD && notTrustedBuilders.contains(p.getName())) {
                                p.setGameMode(GameMode.ADVENTURE);
                                p.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.cant-build-when-offline"));
                                PlayerUtils.clearWorldModePermissions(p);
                            }
                            if (OpenCreative.getPlanetsManager().getDevPlanet(p) == null || !list.contains(p.getName())) continue;
                            p.setGameMode(GameMode.ADVENTURE);
                            p.sendMessage(MessageUtils.getLocaleMessage("world.dev-mode.cant-dev-when-offline"));
                        }
                    }
                    for (Player oldPlanetPlayer : oldPlanet.getPlayers()) {
                        PlayerUtils.hidePlayerInTab(player, oldPlanetPlayer);
                        PlayerUtils.hidePlayerInTab(oldPlanetPlayer, player);
                    }
                } else if (oldPlanet.isLoaded()) {
                    oldPlanet.getTerritory().unload();
                }
                oldPlanet.getInformation().updateIconAsync();
            }
            if (newPlanet != null) {
                newPlanet.getWorldPlayers().registerPlayer(player);
                for (Player player7 : newPlanet.getPlayers()) {
                    PlayerUtils.showPlayerFromTab(player7, player);
                    PlayerUtils.showPlayerFromTab(player, player7);
                    newPlanet.getTerritory().showBorders(player7);
                }
                if (newPlanet.isOwner(player)) {
                    if (newPlanet.getDevPlanet().isLoaded()) {
                        for (Player player8 : newPlanet.getDevPlanet().getWorld().getPlayers()) {
                            if (!newPlanet.getWorldPlayers().isNotTrustedDeveloper(player8)) continue;
                            player8.setGameMode(GameMode.CREATIVE);
                        }
                    }
                    if (newPlanet.getMode() == Planet.Mode.BUILD) {
                        for (Player player9 : newPlanet.getTerritory().getWorld().getPlayers()) {
                            if (!newPlanet.getWorldPlayers().isNotTrustedBuilder(player9)) continue;
                            player9.setGameMode(GameMode.CREATIVE);
                            PlayerUtils.giveBuildPermissions(player9);
                        }
                    }
                }
                newPlanet.getInformation().updateIconAsync();
            }
        }
    }
}

