/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.BookWriteEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.CloseInventoryEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.ItemBreakEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.ItemChangeEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.ItemClickEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.ItemConsumeEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.ItemMoveEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.OpenInventoryEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.PlayerItemCraftEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.PlayerItemDamagedEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.SlotChangeEvent;
import ua.mcchickenstudio.opencreative.coding.modules.BlocksManipulatorMenu;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.listeners.player.ChatListener;
import ua.mcchickenstudio.opencreative.menus.EnderChestMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.RadioButton;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsPlayersMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerConfirmation;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class ClickListener
implements Listener {
    @EventHandler
    public void onCraft(CraftItemEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        new PlayerItemCraftEvent(player, event).callEvent();
    }

    @EventHandler
    public void onChestOpen(InventoryOpenEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getInventory().getLocation() == null) {
            return;
        }
        for (ItemStack insideItem : event.getInventory().getContents()) {
            if (insideItem == null) continue;
            ItemUtils.fixItem(insideItem);
        }
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        if (event.getInventory().getType() != InventoryType.ENDER_CHEST) {
            return;
        }
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            return;
        }
        event.setCancelled(true);
        event.getInventory().close();
        new EnderChestMenu(planet, event.getInventory().getLocation()).open(player);
    }

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent event) {
        new PlayerItemDamagedEvent(event.getPlayer(), event).callEvent();
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        DevPlanet devPlanet;
        Player player = (Player)event.getWhoClicked();
        Planet planet1 = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet1 != null && event.getCurrentItem() != null) {
            new ItemClickEvent(player, event).callEvent();
            if (event.getAction() == InventoryAction.PLACE_ALL) {
                new ItemMoveEvent(player, event).callEvent();
            }
        }
        if (event.getCurrentItem() != null) {
            ItemStack item = event.getCurrentItem();
            if (event.getClickedInventory() != null) {
                InventoryHolder clickedHolder = event.getClickedInventory().getHolder();
                InventoryHolder eventHolder = event.getInventory().getHolder();
                if (clickedHolder != null && clickedHolder.equals((Object)eventHolder)) {
                    ItemUtils.fixItem(item);
                }
            }
            if (event.getInventory().getHolder() instanceof WorldSettingsPlayersMenu) {
                event.setCancelled(true);
                Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                String selectedPlayer = WorldSettingsPlayersMenu.playersSelected.get(player);
                if (planet == null) {
                    return;
                }
                if (item.getType() == Material.SPECTRAL_ARROW) {
                    WorldSettingsPlayersMenu.openInventory(player, WorldSettingsPlayersMenu.openedPage.get(player) + 1);
                } else if (item.getType() == Material.ARROW) {
                    WorldSettingsPlayersMenu.openInventory(player, WorldSettingsPlayersMenu.openedPage.get(player) - 1);
                } else if (item.getType() == Material.PLAYER_HEAD) {
                    boolean playerClicked = false;
                    for (int slot : WorldSettingsPlayersMenu.playerSlots) {
                        if (event.getSlot() != slot) continue;
                        playerClicked = true;
                        break;
                    }
                    if (playerClicked) {
                        WorldSettingsPlayersMenu.playersSelected.put(player, ChatColor.stripColor((String)item.getItemMeta().getDisplayName()));
                        WorldSettingsPlayersMenu.openInventory(player, WorldSettingsPlayersMenu.openedPage.get(player));
                    }
                } else if (item.getType() == Material.BARRIER && event.getSlot() == 16) {
                    player.closeInventory();
                    int limit = planet.getLimits().getBlacklistedLimit();
                    if (planet.getWorldPlayers().getBannedPlayers().size() > limit) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.black-list.limit").replace("%limit%", String.valueOf(limit)));
                        return;
                    }
                    player.sendMessage(MessageUtils.getLocaleMessage("world.players.black-list.added").replace("%player%", selectedPlayer));
                    planet.getWorldPlayers().banPlayer(selectedPlayer);
                } else if (item.getType() == Material.PAPER && event.getSlot() == 5) {
                    player.closeInventory();
                    int limit = planet.getLimits().getWhitelistedLimit();
                    if (planet.getWorldPlayers().getWhitelistedPlayers().size() > limit) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.white-list.limit").replace("%limit%", String.valueOf(limit)));
                        return;
                    }
                    player.sendMessage(MessageUtils.getLocaleMessage("world.players.white-list.added").replace("%player%", selectedPlayer));
                    planet.getWorldPlayers().whitelistPlayer(selectedPlayer);
                } else if (item.getType() == Material.FILLED_MAP && event.getSlot() == 5) {
                    player.closeInventory();
                    player.sendMessage(MessageUtils.getLocaleMessage("world.players.white-list.removed").replace("%player%", selectedPlayer));
                    planet.getWorldPlayers().removeFromWhitelist(selectedPlayer);
                } else if (item.getType() == Material.STRUCTURE_VOID) {
                    if (event.getSlot() == 16) {
                        player.closeInventory();
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.black-list.removed").replace("%player%", selectedPlayer));
                        planet.getWorldPlayers().unbanPlayer(selectedPlayer);
                    } else {
                        player.closeInventory();
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.kick.kicked").replace("%player%", selectedPlayer));
                        Player planetPlayer = Bukkit.getPlayer((String)selectedPlayer);
                        if (planetPlayer != null && OpenCreative.getPlanetsManager().getPlanetByPlayer(planetPlayer) == planet) {
                            planet.getWorldPlayers().kickPlayer(planetPlayer);
                        }
                    }
                } else if (item.getType() == Material.FEATHER || item.getType() == Material.BRICKS || item.getType() == Material.COMMAND_BLOCK) {
                    RadioButton rd = RadioButton.getRadioButtonByItemStack(item);
                    if (rd != null) {
                        rd.onChoice();
                        Sounds.MENU_NEXT_CHOICE.play((Audience)player);
                        WorldSettingsPlayersMenu.openInventory(player);
                    }
                } else if (item.getType() == Material.ENCHANTED_GOLDEN_APPLE) {
                    player.closeInventory();
                    if (WorldSettingsPlayersMenu.playersSelected.get(player) == null) {
                        return;
                    }
                    String newOwner = WorldSettingsPlayersMenu.playersSelected.get(player);
                    if (Bukkit.getPlayer((String)newOwner) == null) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.offline").replace("%player%", newOwner));
                        return;
                    }
                    if (!planet.getPlayers().contains(Bukkit.getPlayer((String)newOwner))) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.offline").replace("%player%", newOwner));
                        return;
                    }
                    if (OpenCreative.getPlanetsManager().getPlanetsByOwner(Bukkit.getPlayer((String)newOwner)).size() >= OpenCreative.getSettings().getGroups().getGroup(Bukkit.getPlayer((String)newOwner)).getWorldsLimit()) {
                        player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.limit").replace("%player%", newOwner));
                        return;
                    }
                    player.sendMessage(MessageUtils.getLocaleMessage("world.players.transfer-ownership.confirm-old").replace("%player%", newOwner).replace("%id%", String.valueOf(planet.getId())));
                    player.closeInventory();
                    if (!ChatListener.confirmation.containsKey(player)) {
                        ChatListener.confirmation.put(player, PlayerConfirmation.TRANSFER_OWNERSHIP);
                    }
                }
            }
            if (!WorldUtils.isPlanet(player.getWorld()) && item.hasItemMeta() && item.getItemMeta().displayName() != null && (item.getItemMeta().getDisplayName().equals(MessageUtils.getLocaleMessage("items.lobby.games.name")) || item.getItemMeta().getDisplayName().equals(MessageUtils.getLocaleMessage("items.lobby.own.name")))) {
                event.setCancelled(true);
            }
        }
        if ((devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player)) == null) {
            return;
        }
        if (player.getGameMode() == GameMode.ADVENTURE) {
            event.setCancelled(true);
            ClickListener.cantDev(player);
        }
    }

    private static void cantDev(Player player) {
        player.closeInventory();
        player.sendActionBar(MessageUtils.getLocaleMessage("world.dev-mode.cant-dev"));
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer((Player)event.getPlayer());
        if (planet != null) {
            new OpenInventoryEvent((Player)event.getPlayer()).callEvent();
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer((Player)event.getPlayer());
        if (planet != null) {
            new CloseInventoryEvent((Player)event.getPlayer()).callEvent();
        }
    }

    @EventHandler
    public void onSwap(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        ItemStack fixedMain = ItemUtils.fixItem(player.getInventory().getItemInMainHand().clone());
        ItemStack fixedOff = ItemUtils.fixItem(player.getInventory().getItemInOffHand().clone());
        if (!fixedMain.equals((Object)player.getInventory().getItemInMainHand())) {
            player.getInventory().setItemInMainHand(fixedMain);
        }
        if (!fixedOff.equals((Object)player.getInventory().getItemInOffHand())) {
            player.getInventory().setItemInOffHand(fixedOff);
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
        ItemStack currentItem = event.getOffHandItem();
        if (devPlanet != null) {
            if (currentItem.getType() == Material.PAPER) {
                event.setCancelled(true);
                if (!player.hasCooldown(currentItem.getType()) && planet != null && planet.getTerritory().getWorld() != null) {
                    ChangedWorld.addPlayerWithLocation(player);
                    if (currentItem.hasItemMeta()) {
                        ItemMeta meta = currentItem.getItemMeta();
                        String locationString = ChatColor.stripColor((String)meta.getDisplayName());
                        String[] locCoords = locationString.split(" ");
                        if (locCoords.length == 5) {
                            try {
                                double x = Double.parseDouble(locCoords[0]);
                                double y = Double.parseDouble(locCoords[1]);
                                double z = Double.parseDouble(locCoords[2]);
                                float yaw = Float.parseFloat(locCoords[3]);
                                float pitch = Float.parseFloat(locCoords[4]);
                                Location location = new Location(planet.getTerritory().getWorld(), x, y, z, yaw, pitch);
                                if (BlockUtils.isOutOfBorders(location)) {
                                    location = planet.getTerritory().getWorld().getSpawnLocation();
                                }
                                player.teleport(location);
                                PlayerUtils.spawnGlowingBlock(player, location);
                            }
                            catch (Exception error) {
                                player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
                            }
                        }
                    } else {
                        player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
                    }
                    Sounds.DEV_LOCATION_TELEPORT.play((Audience)player);
                    player.setCooldown(currentItem.getType(), 60);
                }
            } else if (currentItem.getType() == Material.COMPARATOR) {
                if (!devPlanet.getPlanet().getWorldPlayers().canDevelop(player)) {
                    return;
                }
                event.setCancelled(true);
                if (player.hasCooldown(currentItem.getType())) {
                    return;
                }
                player.setCooldown(currentItem.getType(), 40);
                int size = devPlanet.getMarkedExecutors(player).size();
                if (size == 0) {
                    player.sendActionBar(MessageUtils.getLocaleMessage("menus.developer.manipulator.not-selected"));
                    Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                    return;
                }
                new BlocksManipulatorMenu(player, devPlanet, size).open(player);
            }
        } else if (planet != null) {
            if (ChangedWorld.isPlayerWithLocation(player) && currentItem.getType() == Material.PAPER) {
                event.setCancelled(true);
                if (!player.hasCooldown(currentItem.getType()) && currentItem.hasItemMeta()) {
                    ItemMeta meta = currentItem.getItemMeta();
                    String locationString = ChatColor.stripColor((String)meta.getDisplayName());
                    String[] locCoords = locationString.split(" ");
                    if (locCoords.length == 5) {
                        try {
                            double x = Double.parseDouble(locCoords[0]);
                            double y = Double.parseDouble(locCoords[1]);
                            double z = Double.parseDouble(locCoords[2]);
                            float yaw = Float.parseFloat(locCoords[3]);
                            float pitch = Float.parseFloat(locCoords[4]);
                            player.teleport(new Location(planet.getTerritory().getWorld(), x, y, z, yaw, pitch));
                        }
                        catch (Exception error) {
                            player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
                        }
                    } else {
                        player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
                    }
                    Sounds.DEV_LOCATION_TELEPORT.play((Audience)player);
                    player.setCooldown(currentItem.getType(), 60);
                }
            } else {
                new ItemChangeEvent(event.getPlayer(), event).callEvent();
            }
        }
    }

    @EventHandler
    public void onBookWrite(PlayerEditBookEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new BookWriteEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onItemConsume(PlayerItemConsumeEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new ItemConsumeEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onItemBreak(PlayerItemBreakEvent event) {
        ItemUtils.fixItem(event.getPlayer().getInventory().getItemInMainHand());
        ItemUtils.fixItem(event.getPlayer().getInventory().getItemInOffHand());
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new ItemBreakEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onInventorySlotChange(PlayerInventorySlotChangeEvent event) {
        ItemUtils.fixItem(event.getNewItemStack());
        ItemUtils.fixItem(event.getOldItemStack());
    }

    @EventHandler
    public void onSlotChange(PlayerItemHeldEvent event) {
        Planet planet;
        Player player = event.getPlayer();
        int previousSlot = event.getPreviousSlot();
        int newSlot = event.getNewSlot();
        ItemStack previousItem = player.getInventory().getItem(previousSlot);
        ItemStack newItem = player.getInventory().getItem(newSlot);
        if (previousItem != null) {
            player.getInventory().setItem(previousSlot, ItemUtils.fixItem(previousItem));
        }
        if (newItem != null) {
            player.getInventory().setItem(newSlot, ItemUtils.fixItem(newItem));
        }
        if ((planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer())) != null) {
            new SlotChangeEvent(event.getPlayer(), event).callEvent();
        }
    }
}

