/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.PlayerKilledPlayerEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetFlags;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class DeathListener
implements Listener {
    public static final Map<Player, Location> deathLocations = new HashMap<Player, Location>();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet != null) {
            event.deathMessage(null);
            deathLocations.put(player, planet.getTerritory().getWorld().getSpawnLocation());
            if (planet.getFlagValue(PlanetFlags.PlanetFlag.DEATH_MESSAGES) == 1) {
                for (Player p : planet.getPlayers()) {
                    p.sendMessage("\u00a77 " + player.getName() + "\u00a7f " + this.translateDeathMessage(player));
                }
            }
            event.getDrops().remove(ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings"));
            new ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.PlayerDeathEvent(player, event).callEvent();
            Player killer = player.getKiller();
            if (killer != null) {
                new PlayerKilledPlayerEvent(killer, player, event).callEvent();
            }
            player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("deaths.title", false)), (Component)Component.text((String)("\u00a77 " + player.getName() + "\u00a7f " + this.translateDeathMessage(player))), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(750L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(500L))));
        } else if (WorldUtils.isLobbyWorld(event.getPlayer().getWorld())) {
            event.deathMessage(null);
            event.setKeepInventory(true);
            event.setCancelled(true);
            PlayerUtils.teleportToLobby(player);
        }
    }

    private String translateDeathMessage(Player player) {
        EntityDamageEvent damageEvent = player.getLastDamageCause();
        if (damageEvent == null) {
            return MessageUtils.getLocaleMessage("deaths.custom");
        }
        Player damager = player.getKiller();
        if (damageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageByEntityEvent = (EntityDamageByEntityEvent)damageEvent;
            damager = damageByEntityEvent.getDamager();
        }
        return switch (damageEvent.getCause()) {
            case EntityDamageEvent.DamageCause.BLOCK_EXPLOSION -> MessageUtils.getLocaleMessage("deaths.block-explosion");
            case EntityDamageEvent.DamageCause.CONTACT -> MessageUtils.getLocaleMessage("deaths.contact");
            case EntityDamageEvent.DamageCause.CRAMMING -> MessageUtils.getLocaleMessage("deaths.cramming");
            case EntityDamageEvent.DamageCause.DRAGON_BREATH -> MessageUtils.getLocaleMessage("deaths.dragon-breath");
            case EntityDamageEvent.DamageCause.DROWNING -> MessageUtils.getLocaleMessage("deaths.drowning");
            case EntityDamageEvent.DamageCause.DRYOUT -> MessageUtils.getLocaleMessage("deaths.dryout");
            case EntityDamageEvent.DamageCause.ENTITY_ATTACK -> MessageUtils.getLocaleMessage("deaths.entity-attack").replace("%entity%", damager == null ? "" : damager.getName().substring(0, Math.min(damager.getName().length(), 30)));
            case EntityDamageEvent.DamageCause.ENTITY_EXPLOSION -> MessageUtils.getLocaleMessage("deaths.entity-explosion").replace("%entity%", damager == null ? "" : damager.getName().substring(0, Math.min(damager.getName().length(), 30)));
            case EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK -> MessageUtils.getLocaleMessage("deaths.entity-sweep-attack").replace("%entity%", damager == null ? "" : damager.getName().substring(0, Math.min(damager.getName().length(), 30)));
            case EntityDamageEvent.DamageCause.FALL -> MessageUtils.getLocaleMessage("deaths.fall");
            case EntityDamageEvent.DamageCause.FALLING_BLOCK -> MessageUtils.getLocaleMessage("deaths.falling-block");
            case EntityDamageEvent.DamageCause.FIRE -> MessageUtils.getLocaleMessage("deaths.fire");
            case EntityDamageEvent.DamageCause.FIRE_TICK -> MessageUtils.getLocaleMessage("deaths.fire-tick");
            case EntityDamageEvent.DamageCause.FLY_INTO_WALL -> MessageUtils.getLocaleMessage("deaths.fly-into-wall");
            case EntityDamageEvent.DamageCause.HOT_FLOOR -> MessageUtils.getLocaleMessage("deaths.hot-floor");
            case EntityDamageEvent.DamageCause.LAVA -> MessageUtils.getLocaleMessage("deaths.lava");
            case EntityDamageEvent.DamageCause.LIGHTNING -> MessageUtils.getLocaleMessage("deaths.lightning");
            case EntityDamageEvent.DamageCause.MAGIC -> MessageUtils.getLocaleMessage("deaths.magic");
            case EntityDamageEvent.DamageCause.MELTING -> MessageUtils.getLocaleMessage("deaths.melting");
            case EntityDamageEvent.DamageCause.POISON -> MessageUtils.getLocaleMessage("deaths.poison");
            case EntityDamageEvent.DamageCause.PROJECTILE -> MessageUtils.getLocaleMessage("deaths.projectile");
            case EntityDamageEvent.DamageCause.STARVATION -> MessageUtils.getLocaleMessage("deaths.starvation");
            case EntityDamageEvent.DamageCause.SUFFOCATION -> MessageUtils.getLocaleMessage("deaths.suffocation");
            case EntityDamageEvent.DamageCause.SUICIDE -> MessageUtils.getLocaleMessage("deaths.suicide");
            case EntityDamageEvent.DamageCause.THORNS -> MessageUtils.getLocaleMessage("deaths.thorns");
            case EntityDamageEvent.DamageCause.VOID -> MessageUtils.getLocaleMessage("deaths.void");
            case EntityDamageEvent.DamageCause.WITHER -> MessageUtils.getLocaleMessage("deaths.wither");
            default -> MessageUtils.getLocaleMessage("deaths.custom");
        };
    }
}

