/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import net.kyori.adventure.text.Component;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.ItemDropEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.inventory.ItemPickupEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class DropItemListener
implements Listener {
    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Planet planet;
        Component name;
        Player player = event.getPlayer();
        ItemStack item = event.getItemDrop().getItemStack();
        if (item.hasItemMeta() && item.getItemMeta() != null && (name = item.getItemMeta().displayName()) != null) {
            String displayName = item.getItemMeta().getDisplayName();
            if (!WorldUtils.isPlanet(player.getWorld())) {
                if (displayName.equals(MessageUtils.getLocaleItemName("items.lobby.games.name")) || displayName.equals(MessageUtils.getLocaleMessage("items.lobby.own.name"))) {
                    event.setCancelled(true);
                }
            } else if (displayName.equals(MessageUtils.getLocaleItemName("items.developer.world-settings.name"))) {
                event.setCancelled(true);
            }
        }
        if ((planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player)) != null) {
            new ItemDropEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        ItemStack item = ItemUtils.fixItem(event.getItem().getItemStack());
        if (item.getType().isAir()) {
            event.setCancelled(true);
        }
        event.getItem().setItemStack(item);
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet != null) {
            new ItemPickupEvent(player, event).callEvent();
        }
    }
}

