/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import io.papermc.paper.event.player.PlayerNameEntityEvent;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.BedEnterEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.BedLeaveEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.BlockInteractionEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.FishEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.LeftClickEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.MobInteractionEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.RightClickEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.StartSpectatingEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.StopSpectatingEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.WorldInteractEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.menus.TargetSelectionMenu;
import ua.mcchickenstudio.opencreative.coding.menus.ValueTargetSelectionMenu;
import ua.mcchickenstudio.opencreative.coding.menus.blocks.BlocksCategorySelectionMenu;
import ua.mcchickenstudio.opencreative.coding.menus.blocks.FunctionChooserMenu;
import ua.mcchickenstudio.opencreative.coding.menus.blocks.MethodChooserMenu;
import ua.mcchickenstudio.opencreative.coding.menus.blocks.SelectionActionsMenu;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.ArgumentSlot;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.Layout;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.LayoutMaker;
import ua.mcchickenstudio.opencreative.coding.menus.variables.EventValuesMenu;
import ua.mcchickenstudio.opencreative.coding.menus.variables.ParticlesMenu;
import ua.mcchickenstudio.opencreative.coding.menus.variables.PotionsMenu;
import ua.mcchickenstudio.opencreative.coding.menus.variables.VariablesMenu;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.listeners.player.PlaceBlockListener;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.world.browsers.OwnWorldsBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.world.browsers.RecommendedWorldsMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetFlags;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.settings.groups.LimitType;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class InteractListener
implements Listener {
    @EventHandler
    public void onInteraction(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack fixedMain = ItemUtils.fixItem(player.getInventory().getItemInMainHand().clone());
        ItemStack fixedOff = ItemUtils.fixItem(player.getInventory().getItemInOffHand().clone());
        if (!fixedMain.equals((Object)player.getInventory().getItemInMainHand())) {
            player.getInventory().setItemInMainHand(fixedMain);
        }
        if (!fixedOff.equals((Object)player.getInventory().getItemInOffHand())) {
            player.getInventory().setItemInOffHand(fixedOff);
        }
        ItemStack currentItem = player.getInventory().getItemInMainHand();
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
        if (devPlanet == null) {
            this.setPaperLocation(event, player, currentItem);
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        boolean doNotUseItem = false;
        if (clickedBlock != null) {
            if (clickedBlock.getType().toString().contains("WALL_SIGN")) {
                doNotUseItem = this.handleSignClick(event, player, currentItem, clickedBlock, devPlanet);
            } else if (clickedBlock.getState() instanceof InventoryHolder) {
                doNotUseItem = this.handleContainerClick(event, player, devPlanet, event.getClickedBlock());
            }
        }
        if (currentItem.getItemMeta() != null && !doNotUseItem) {
            this.handleCodingItemInteraction(event, player, currentItem, clickedBlock);
        }
    }

    private void handleCodingItemInteraction(PlayerInteractEvent event, Player player, ItemStack currentItem, Block clickedBlock) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (ItemUtils.itemEquals(currentItem, ItemUtils.createItem(Material.IRON_INGOT, 1, "items.developer.variables"))) {
            new VariablesMenu().open(player);
            return;
        }
        switch (currentItem.getType()) {
            case BOOK: {
                this.handleBookClick(event, player, currentItem);
                break;
            }
            case SLIME_BALL: {
                this.handleSlimeBallClick(event, player, currentItem);
                break;
            }
            case BLACK_DYE: {
                this.handleDyeClick(event, player, currentItem);
                break;
            }
            case FEATHER: {
                this.handleFeatherInteraction(event, player, currentItem);
                break;
            }
            case CLOCK: {
                this.handleClockInteraction(event, player, currentItem);
                break;
            }
            case MAGMA_CREAM: {
                this.handleMagmaCreamInteraction(event, player, currentItem);
                break;
            }
            case PAPER: {
                this.handlePaperInteraction(event, player, currentItem);
                break;
            }
            case PRISMARINE_SHARD: {
                this.handlePrismarineShardClick(event, player, currentItem);
                break;
            }
            case NAME_TAG: {
                event.setCancelled(true);
                if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    return;
                }
                if (player.isSneaking()) {
                    new ValueTargetSelectionMenu(player).open(player);
                    break;
                }
                new EventValuesMenu(player).open(player);
                break;
            }
            case COMPARATOR: {
                if (clickedBlock == null) break;
                this.handleComparatorInteraction(event, player, clickedBlock);
                break;
            }
            case NETHER_STAR: {
                event.setCancelled(true);
                if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    return;
                }
                if (player.isSneaking()) {
                    String particleType = ItemUtils.getPersistentData(currentItem, ItemUtils.getCodingParticleTypeKey());
                    if (particleType.isEmpty()) {
                        return;
                    }
                    try {
                        Particle particle = Particle.valueOf((String)particleType.toUpperCase());
                        Vector direction = player.getLocation().getDirection().normalize().multiply(1.5);
                        Location particleLocation = player.getLocation().add(direction).add(0.0, 1.0, 0.0);
                        player.spawnParticle(particle, particleLocation, 1);
                    }
                    catch (Exception particle) {}
                    break;
                }
                new ParticlesMenu(player).open(player);
                break;
            }
            case POTION: 
            case GLASS_BOTTLE: 
            case LINGERING_POTION: 
            case SPLASH_POTION: {
                event.setCancelled(true);
                if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    return;
                }
                if (player.isSneaking() && currentItem.getType() != Material.GLASS_BOTTLE) {
                    if (player.hasCooldown(currentItem.getType())) {
                        return;
                    }
                    player.setCooldown(currentItem.getType(), 10);
                    try {
                        PotionMeta potionMeta = (PotionMeta)currentItem.getItemMeta();
                        ArrayList effects = new ArrayList();
                        if (potionMeta.getBasePotionType() != null) {
                            effects.addAll(potionMeta.getBasePotionType().getPotionEffects());
                        }
                        if (potionMeta.hasCustomEffects()) {
                            effects.addAll(potionMeta.getCustomEffects());
                        }
                        for (PotionEffect potionEffect : effects) {
                            if (player.hasPotionEffect(potionEffect.getType())) {
                                player.removePotionEffect(potionEffect.getType());
                                continue;
                            }
                            player.addPotionEffect(potionEffect);
                        }
                        break;
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                new PotionsMenu(player, currentItem.getType()).open(player);
            }
        }
    }

    private boolean handleContainerClick(PlayerInteractEvent event, Player player, DevPlanet devPlanet, Block clickedBlock) {
        BlockState blockState = clickedBlock.getState();
        if (!(blockState instanceof InventoryHolder)) {
            return false;
        }
        InventoryHolder holder = (InventoryHolder)blockState;
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item.isEmpty()) {
                return true;
            }
            ActionType action = ActionType.getType(clickedBlock.getRelative(BlockFace.DOWN));
            if (action == null) {
                return true;
            }
            if (action.getCategory() == ActionCategory.SELECTION_ACTION) {
                String selectionAction = BlockUtils.getSignLine(clickedBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.SOUTH).getLocation(), 3);
                if (selectionAction == null || selectionAction.isEmpty()) {
                    return true;
                }
                action = ActionType.getType(selectionAction);
                if (action == null) {
                    return true;
                }
            }
            if (action.getArgumentsSlots().length == 0) {
                return true;
            }
            int maximumSlots = 0;
            ArrayList<Integer> ignored = new ArrayList<Integer>();
            for (ArgumentSlot argument : action.getArgumentsSlots()) {
                if (argument.isParameter()) {
                    ignored.add(maximumSlots);
                }
                maximumSlots += argument.getListSize();
            }
            Inventory inventory = holder.getInventory();
            for (int slot = 0; slot < maximumSlots && slot < inventory.getSize(); ++slot) {
                if (ignored.contains(slot) || inventory.getItem(slot) != null) continue;
                inventory.setItem(slot, item);
                player.getInventory().setItemInMainHand(null);
                Sounds.DEV_INSERTED_IN_CONTAINER.play((Audience)player);
                Layout layout = devPlanet.getOpenedMenu(inventory.getLocation());
                if (layout != null && slot < layout.getArgsSlots().size()) {
                    layout.setItem(layout.getArgsSlots().get(slot), item);
                }
                devPlanet.setCodeChanged(true);
                return true;
            }
            Sounds.DEV_NOT_ALLOWED.play((Audience)player);
            return true;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return false;
        }
        if (player.isSneaking()) {
            return true;
        }
        Block actionBlock = clickedBlock.getRelative(BlockFace.DOWN);
        Block signBlock = actionBlock.getRelative(BlockFace.SOUTH);
        BlockState ignored = signBlock.getState();
        if (!(ignored instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)ignored;
        if (sign.getSide(Side.FRONT).lines().size() < 3) {
            return false;
        }
        String type = sign.getSide(Side.FRONT).getLine(2);
        try {
            ActionType action = ActionType.valueOf(type.toUpperCase());
            Layout layout = devPlanet.getOpenedMenu(clickedBlock.getLocation());
            event.setCancelled(true);
            if (layout == null) {
                layout = new LayoutMaker(action, clickedBlock);
                layout.open(player);
                devPlanet.registerOpenedMenu(clickedBlock.getLocation(), layout);
            } else {
                player.openInventory(layout.getInventory());
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            player.sendActionBar(MessageUtils.getLocaleMessage("coding-error.unknown-layout"));
            event.setCancelled(false);
            return true;
        }
    }

    private boolean handleSignClick(PlayerInteractEvent event, Player player, ItemStack currentItem, Block clickedBlock, DevPlanet devPlanet) {
        event.setCancelled(true);
        if (currentItem.getType() == Material.COMPARATOR) {
            return false;
        }
        Block mainBlock = clickedBlock.getRelative(BlockFace.NORTH);
        ExecutorCategory mainBlockCategory = ExecutorCategory.getByMaterial(mainBlock.getType());
        ActionCategory actionBlockCategory = ActionCategory.getByMaterial(mainBlock.getType());
        if (currentItem.getType() == Material.ARROW && (actionBlockCategory != null && actionBlockCategory.isCondition() || actionBlockCategory == ActionCategory.SELECTION_ACTION)) {
            if (event.getHand() == EquipmentSlot.HAND) {
                if (actionBlockCategory == ActionCategory.SELECTION_ACTION && BlockUtils.isSignLineEmpty(clickedBlock.getLocation(), 3)) {
                    return false;
                }
                if (actionBlockCategory == ActionCategory.ELSE_CONDITION) {
                    return false;
                }
                devPlanet.setCodeChanged(true);
                if (BlockUtils.isSignLineEmpty(clickedBlock.getLocation(), 1)) {
                    BlockUtils.setSignLine(clickedBlock.getLocation(), 1, "not");
                    Sounds.DEV_CONDITION_NOT.play((Audience)player);
                } else {
                    BlockUtils.setSignLine(clickedBlock.getLocation(), 1, "");
                    Sounds.DEV_CONDITION_DEFAULT.play((Audience)player);
                }
                PlayerUtils.translateBlockSign(clickedBlock);
            }
        } else if (player.isSneaking() && actionBlockCategory != null) {
            if (actionBlockCategory == ActionCategory.SELECTION_ACTION) {
                String selectionAction;
                String string = selectionAction = BlockUtils.getSignLine(clickedBlock.getLocation(), 4);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"selection_set", "selection_add"}, (Object)string, n)) {
                    case 0: {
                        BlockUtils.setSignLine(clickedBlock.getLocation(), 4, "selection_add");
                        Sounds.DEV_ACTION_TARGET.play((Audience)player);
                        break;
                    }
                    case 1: {
                        BlockUtils.setSignLine(clickedBlock.getLocation(), 4, "selection_remove");
                        Sounds.DEV_ACTION_TARGET.play((Audience)player);
                        break;
                    }
                    default: {
                        BlockUtils.setSignLine(clickedBlock.getLocation(), 4, "selection_set");
                        Sounds.DEV_ACTION_TARGET.play((Audience)player);
                    }
                }
                PlayerUtils.translateBlockSign(clickedBlock);
            } else {
                new TargetSelectionMenu(clickedBlock.getLocation()).open(player);
            }
        } else {
            String displayName;
            ItemStack item;
            BlocksCategorySelectionMenu menu = null;
            Location clickedLocation = clickedBlock.getLocation();
            if (mainBlockCategory != null) {
                menu = switch (mainBlockCategory) {
                    case ExecutorCategory.EVENT_WORLD, ExecutorCategory.EVENT_ENTITY, ExecutorCategory.EVENT_PLAYER -> new BlocksCategorySelectionMenu(player, clickedLocation, mainBlockCategory);
                    default -> null;
                };
            } else if (actionBlockCategory != null) {
                switch (actionBlockCategory) {
                    case PLAYER_ACTION: 
                    case PLAYER_CONDITION: 
                    case VARIABLE_ACTION: 
                    case VARIABLE_CONDITION: 
                    case ENTITY_ACTION: 
                    case ENTITY_CONDITION: 
                    case WORLD_ACTION: 
                    case WORLD_CONDITION: 
                    case CONTROL_ACTION: 
                    case REPEAT_ACTION: 
                    case CONTROLLER_ACTION: {
                        AbstractMenu abstractMenu = new BlocksCategorySelectionMenu(player, clickedLocation, actionBlockCategory);
                        break;
                    }
                    case SELECTION_ACTION: {
                        AbstractMenu abstractMenu = new SelectionActionsMenu(player, clickedLocation);
                        break;
                    }
                    case LAUNCH_FUNCTION_ACTION: {
                        AbstractMenu abstractMenu = new FunctionChooserMenu(player, devPlanet, clickedLocation);
                        break;
                    }
                    case LAUNCH_METHOD_ACTION: {
                        AbstractMenu abstractMenu = new MethodChooserMenu(player, devPlanet, clickedLocation);
                        break;
                    }
                    default: {
                        AbstractMenu abstractMenu = menu = null;
                    }
                }
            }
            if (menu != null) {
                menu.open(player);
                return true;
            }
            if (mainBlockCategory == ExecutorCategory.CYCLE) {
                String cycleTicksString = BlockUtils.getSignLine(clickedBlock.getLocation(), 3);
                if (cycleTicksString != null && !cycleTicksString.isEmpty()) {
                    int cycleTicks = 20;
                    try {
                        cycleTicks = Integer.parseInt(cycleTicksString);
                    }
                    catch (NumberFormatException exception) {
                        BlockUtils.setSignLine(clickedBlock.getLocation(), 3, "20");
                    }
                    if (event.getAction().isRightClick()) {
                        if (event.getPlayer().isSneaking()) {
                            --cycleTicks;
                            Sounds.DEV_CYCLE_DELAY_DECREASE.play((Audience)player);
                        } else {
                            ItemStack item2 = event.getPlayer().getInventory().getItemInMainHand();
                            if (!item2.isEmpty() && item2.hasItemMeta()) {
                                String displayName2 = ChatColor.stripColor((String)item2.getItemMeta().getDisplayName());
                                if (item2.getType() == Material.SLIME_BALL) {
                                    try {
                                        cycleTicks = Math.round(Float.parseFloat(displayName2));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                    Sounds.DEV_CYCLE_DELAY_SET.play((Audience)player);
                                } else if (displayName2.length() < 15) {
                                    BlockUtils.setSignLine(clickedBlock.getLocation(), 1, displayName2);
                                    Sounds.DEV_CYCLE_NAMED.play((Audience)player);
                                }
                            } else {
                                ++cycleTicks;
                                Sounds.DEV_CYCLE_DELAY_INCREASE.play((Audience)player);
                            }
                        }
                    }
                    if (cycleTicks < 5) {
                        cycleTicks = 5;
                    }
                    if (cycleTicks > 3600) {
                        cycleTicks = 3600;
                    }
                    BlockUtils.setSignLine(clickedBlock.getLocation(), 3, String.valueOf(cycleTicks));
                    PlayerUtils.translateBlockSign(clickedBlock);
                }
            } else if ((mainBlockCategory == ExecutorCategory.FUNCTION || mainBlockCategory == ExecutorCategory.METHOD) && !(item = event.getPlayer().getInventory().getItemInMainHand()).isEmpty() && item.hasItemMeta() && (displayName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName())).length() < 15) {
                BlockUtils.setSignLine(clickedBlock.getLocation(), 3, displayName);
                (mainBlockCategory == ExecutorCategory.FUNCTION ? Sounds.DEV_FUNCTION_NAMED : Sounds.DEV_METHOD_NAMED).play((Audience)player);
                PlayerUtils.translateBlockSign(clickedBlock);
            }
        }
        return false;
    }

    private void handleDyeClick(PlayerInteractEvent event, Player player, ItemStack currentItem) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            ItemMeta meta = currentItem.getItemMeta();
            if (meta == null || !meta.hasDisplayName()) {
                return;
            }
            Component displayName = meta.displayName();
            if (displayName != null) {
                player.sendMessage(displayName.hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.click-to-copy")))).clickEvent(ClickEvent.suggestCommand((String)ChatColor.stripColor((String)meta.getDisplayName()))));
                player.swingMainHand();
            }
        }
    }

    private void handleSlimeBallClick(PlayerInteractEvent event, Player player, ItemStack currentItem) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            ItemMeta meta = currentItem.getItemMeta();
            if (meta == null || !meta.hasDisplayName()) {
                return;
            }
            Component displayName = meta.displayName();
            if (displayName != null) {
                player.sendMessage(displayName.hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.click-to-copy")))).clickEvent(ClickEvent.suggestCommand((String)ChatColor.stripColor((String)meta.getDisplayName()))));
                ItemUtils.setPersistentData(currentItem, ItemUtils.getCodingValueKey(), "NUMBER");
            }
        }
    }

    private void handleBookClick(PlayerInteractEvent event, Player player, ItemStack currentItem) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            ItemMeta meta = currentItem.getItemMeta();
            if (meta == null || !meta.hasDisplayName()) {
                return;
            }
            Component displayName = meta.displayName();
            if (displayName != null) {
                player.sendMessage(displayName.hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.click-to-copy")))).clickEvent(ClickEvent.suggestCommand((String)meta.getDisplayName().replace("\u00a7", "&"))));
                ItemUtils.setPersistentData(currentItem, ItemUtils.getCodingValueKey(), "TEXT");
                player.swingMainHand();
            }
        }
    }

    private void handlePrismarineShardClick(PlayerInteractEvent event, Player player, ItemStack currentItem) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            ItemMeta meta = currentItem.getItemMeta();
            if (meta == null || !meta.hasDisplayName()) {
                return;
            }
            if (player.isSneaking()) {
                String vectorString = ChatColor.stripColor((String)meta.getDisplayName());
                String[] coords = vectorString.split(" ");
                if (coords.length == 3) {
                    try {
                        double x = Double.parseDouble(coords[0]);
                        double y = Double.parseDouble(coords[1]);
                        double z = Double.parseDouble(coords[2]);
                        player.setVelocity(new Vector(x, y, z));
                    }
                    catch (Exception exception) {}
                }
            } else {
                Component displayName = meta.displayName();
                if (displayName != null) {
                    player.sendMessage(displayName.hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.click-to-copy")))).clickEvent(ClickEvent.suggestCommand((String)ChatColor.stripColor((String)meta.getDisplayName()))));
                    ItemUtils.setPersistentData(currentItem, ItemUtils.getCodingValueKey(), "VECTOR");
                    player.swingMainHand();
                }
            }
        }
    }

    private void handleComparatorInteraction(PlayerInteractEvent event, Player player, Block clickedBlock) {
        DevPlanet devPlanet;
        if (clickedBlock.getType().name().contains("WALL_SIGN")) {
            clickedBlock = clickedBlock.getRelative(BlockFace.NORTH);
        }
        if ((devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player)) == null) {
            return;
        }
        if (ActionCategory.getByMaterial(clickedBlock.getType()) != null) {
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (PlaceBlockListener.move(clickedBlock.getRelative(BlockFace.WEST).getLocation(), BlockFace.EAST)) {
                    Sounds.DEV_MOVE_BLOCKS_RIGHT.play((Audience)player);
                } else {
                    Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                }
                devPlanet.setCodeChanged(true);
            } else if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (PlaceBlockListener.move(clickedBlock.getRelative(-2, 0, 0).getLocation(), BlockFace.WEST)) {
                    Sounds.DEV_MOVE_BLOCKS_LEFT.play((Audience)player);
                } else {
                    Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                }
                devPlanet.setCodeChanged(true);
            }
        } else if (ExecutorCategory.getByMaterial(clickedBlock.getType()) != null) {
            if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (player.hasCooldown(Material.COMPARATOR)) {
                return;
            }
            player.setCooldown(Material.COMPARATOR, 20);
            Location location = clickedBlock.getLocation();
            Set<Location> locations = devPlanet.getMarkedExecutors(player);
            int limit = OpenCreative.getSettings().getGroups().getGroup(player).getLimit(LimitType.SELECTED_LINES_AMOUNT).calculateLimit(1);
            if (locations.contains(location)) {
                devPlanet.unselectMarkedExecutor(player, location);
                player.sendActionBar(MessageUtils.getLocaleMessage("menus.developer.manipulator.unmarked").replace("%amount%", String.valueOf(devPlanet.getMarkedExecutors(player).size())).replace("%limit%", String.valueOf(limit)));
                Sounds.DEV_UNMARK_EXECUTOR.play((Audience)player);
            } else {
                if (locations.size() >= limit) {
                    player.sendActionBar(MessageUtils.getLocaleMessage("menus.developer.manipulator.limit").replace("%amount%", String.valueOf(devPlanet.getMarkedExecutors(player).size())));
                    Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                    return;
                }
                devPlanet.markExecutorAsSelected(player, location);
                player.sendActionBar(MessageUtils.getLocaleMessage("menus.developer.manipulator.marked").replace("%amount%", String.valueOf(devPlanet.getMarkedExecutors(player).size())).replace("%limit%", String.valueOf(limit)));
                Sounds.DEV_MARK_EXECUTOR.play((Audience)player);
            }
        }
    }

    private void handlePaperInteraction(PlayerInteractEvent event, Player player, ItemStack currentItem) {
        Planet planet;
        if (event.getAction() == Action.LEFT_CLICK_AIR && !player.hasCooldown(currentItem.getType()) && (planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player)) != null) {
            ChangedWorld.addPlayerWithLocation(player);
            player.teleport(planet.getTerritory().getWorld().getSpawnLocation());
            Sounds.DEV_LOCATION_TELEPORT.play((Audience)player);
            player.setCooldown(currentItem.getType(), 60);
        }
    }

    private void handleMagmaCreamInteraction(PlayerInteractEvent event, Player player, ItemStack currentItem) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (currentItem.getItemMeta() == null || !currentItem.getItemMeta().hasDisplayName()) {
            return;
        }
        event.setCancelled(true);
        ItemMeta meta = currentItem.getItemMeta();
        VariableLink.VariableType type = InteractListener.getVariableType(meta);
        meta.setDisplayName(String.valueOf(type.getColor()) + ChatColor.stripColor((String)meta.getDisplayName()));
        player.showTitle(Title.title((Component)meta.displayName(), (Component)Component.text((String)type.getLocalized()), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(0L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofSeconds(1L))));
        currentItem.setItemMeta(meta);
        ItemUtils.setPersistentData(currentItem, ItemUtils.getCodingValueKey(), "VARIABLE");
        ItemUtils.setPersistentData(currentItem, ItemUtils.getCodingVariableTypeKey(), type.name());
        Sounds.DEV_VARIABLE_CHANGE.play((Audience)player);
        player.swingMainHand();
        player.sendMessage(Component.text((String)meta.getDisplayName()).clickEvent(ClickEvent.suggestCommand((String)ChatColor.stripColor((String)meta.getDisplayName()))));
    }

    private static VariableLink.VariableType getVariableType(ItemMeta meta) {
        VariableLink.VariableType type;
        int colorCode = 99;
        String itemName = meta.getDisplayName();
        if (itemName.length() >= 2) {
            colorCode = itemName.charAt(1);
        }
        VariableLink.VariableType variableType = colorCode == 97 ? VariableLink.VariableType.SAVED : (type = colorCode == 101 ? VariableLink.VariableType.GLOBAL : VariableLink.VariableType.LOCAL);
        type = type == VariableLink.VariableType.LOCAL ? VariableLink.VariableType.GLOBAL : (type == VariableLink.VariableType.GLOBAL ? VariableLink.VariableType.SAVED : VariableLink.VariableType.LOCAL);
        return type;
    }

    private void handleFeatherInteraction(PlayerInteractEvent event, Player player, ItemStack currentItem) {
        if (currentItem.getItemMeta() == null || !currentItem.getItemMeta().hasDisplayName()) {
            return;
        }
        if (!currentItem.getItemMeta().getDisplayName().equals(MessageUtils.getLocaleItemName("items.developer.fly-speed-changer.name"))) {
            return;
        }
        currentItem.setAmount(currentItem.getAmount() > 3 ? 1 : currentItem.getAmount() + 1);
        float currentSpead = currentItem.getAmount() + 1;
        float speed = (currentSpead - 1.0f) / 9.0f * 0.9f;
        if (speed > 1.0f) {
            speed = currentSpead * 0.1f;
        }
        player.setFlying(true);
        player.setFlySpeed(speed);
        player.sendActionBar(MessageUtils.getLocaleMessage("world.dev-mode.changed-fly-speed").replace("%speed%", String.valueOf(currentItem.getAmount())));
        Sounds.DEV_FLY_SPEED_CHANGE.play((Audience)player);
    }

    private void handleClockInteraction(PlayerInteractEvent event, Player player, ItemStack currentItem) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        boolean value = false;
        ItemMeta meta = currentItem.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            value = meta.getDisplayName().contains("true");
        }
        String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)(!value ? "&atrue" : "&cfalse"));
        ItemUtils.setDisplayName(currentItem, displayName);
        (!value ? Sounds.DEV_BOOLEAN_TRUE : Sounds.DEV_BOOLEAN_FALSE).play((Audience)player);
        player.swingMainHand();
        player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable")), (Component)Component.text((String)displayName), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
    }

    private void setPaperLocation(PlayerInteractEvent event, final Player player, ItemStack currentItem) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (ChangedWorld.isPlayerWithLocation(player) && planet != null && !planet.getWorldPlayers().canBuild(player)) {
            event.setCancelled(true);
        }
        if (currentItem.getType() != Material.PAPER || !ChangedWorld.isPlayerWithLocation(player) || player.hasCooldown(currentItem.getType())) {
            return;
        }
        if (event.getAction().isRightClick()) {
            Block clickedBlock = event.getClickedBlock();
            Location location = player.getLocation();
            if (clickedBlock != null) {
                location = clickedBlock.getLocation();
            }
            String locationString = InteractListener.formatLocation(location);
            ItemUtils.setDisplayName(currentItem, locationString);
            player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.set-variable")), (Component)Component.text((String)locationString), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
            PlayerUtils.spawnGlowingBlock(player, location);
            Sounds.DEV_LOCATION_SET.play((Audience)player);
        } else if (event.getAction() == Action.LEFT_CLICK_AIR && planet != null && planet.getDevPlanet().isLoaded()) {
            player.setCooldown(currentItem.getType(), 60);
            player.teleportAsync(ChangedWorld.getOldLocationPlayerWithLocation(player)).thenAccept(success -> {
                Sounds.DEV_LOCATION_TELEPORT_BACK.play((Audience)player);
                for (Player developer : planet.getDevPlanet().getWorld().getPlayers()) {
                    WorldBorder border = Bukkit.createWorldBorder();
                    border.setCenter(planet.getDevPlanet().getWorld().getWorldBorder().getCenter());
                    border.setSize(planet.getDevPlanet().getWorld().getWorldBorder().getSize() * 5.0);
                    developer.setWorldBorder(border);
                }
                new BukkitRunnable(this){

                    public void run() {
                        PlayerUtils.translateSigns(player, 10);
                    }
                }.runTaskLater((Plugin)OpenCreative.getPlugin(), 10L);
            });
        }
    }

    public static String formatLocation(Location location) {
        double x = (double)Math.round(location.getX() * 100.0) / 100.0;
        double y = (double)Math.round(location.getY() * 100.0) / 100.0;
        double z = (double)Math.round(location.getZ() * 100.0) / 100.0;
        float yaw = (float)Math.round(location.getYaw() * 100.0f) / 100.0f;
        float pitch = (float)Math.round(location.getPitch() * 100.0f) / 100.0f;
        return ChatColor.translateAlternateColorCodes((char)'&', (String)("&a" + x + " " + y + " " + z + " &7" + yaw + " " + pitch));
    }

    @EventHandler
    public void onCompass(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack currentItem = player.getInventory().getItemInMainHand();
        if (!event.getAction().isRightClick()) {
            return;
        }
        if (player.hasCooldown(currentItem.getType())) {
            return;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (PlayerUtils.isEntityInLobby((Entity)player)) {
            if (ItemUtils.getItemType(currentItem).equals("worlds")) {
                if (OpenCreative.getSettings().isMaintenance() && !player.hasPermission("opencreative.maintenance.bypass")) {
                    player.sendMessage(MessageUtils.getLocaleMessage("maintenance"));
                    return;
                }
                if (OpenCreative.getStability().isVeryBad() && !player.hasPermission("opencreative.stability.bypass")) {
                    player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
                    return;
                }
                player.setCooldown(Material.COMPASS, 60);
                new RecommendedWorldsMenu().open(player);
            } else if (ItemUtils.getItemType(currentItem).equals("own_worlds")) {
                if (OpenCreative.getSettings().isMaintenance() && !player.hasPermission("opencreative.maintenance.bypass")) {
                    player.sendMessage(MessageUtils.getLocaleMessage("maintenance"));
                    return;
                }
                if (OpenCreative.getStability().isVeryBad() && !player.hasPermission("opencreative.stability.bypass")) {
                    player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
                    return;
                }
                player.setCooldown(Material.NETHER_STAR, 60);
                new OwnWorldsBrowserMenu(player).open(player);
            }
        } else if (planet != null && currentItem.getType() == Material.COMPASS) {
            if (OpenCreative.getSettings().isMaintenance() && !player.hasPermission("opencreative.maintenance.bypass")) {
                player.sendMessage(MessageUtils.getLocaleMessage("maintenance"));
                return;
            }
            if (OpenCreative.getStability().isVeryBad() && !player.hasPermission("opencreative.stability.bypass")) {
                player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
                return;
            }
            if (planet.isOwner(player)) {
                player.setCooldown(Material.COMPASS, 60);
                new WorldSettingsMenu(planet, player).open(player);
            }
        }
    }

    @EventHandler
    public void onUsing(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (PlayerUtils.isEntityInLobby((Entity)player) && OpenCreative.getSettings().isLobbyDisallowSpawningMobs() && !player.hasPermission("opencreative.lobby.spawning-mobs.bypass")) {
            ItemStack item = event.getItem();
            if (item == null) {
                return;
            }
            if (!(item.getItemMeta() instanceof SpawnEggMeta) && item.getType() != Material.ITEM_FRAME && item.getType() != Material.GLOW_ITEM_FRAME && item.getType() != Material.PAINTING) {
                return;
            }
            event.setCancelled(true);
            player.sendActionBar(MessageUtils.getLocaleMessage("not-for-lobby"));
            return;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            return;
        }
        if (OpenCreative.getPlanetsManager().getDevPlanet(player) != null) {
            return;
        }
        switch (event.getAction()) {
            case LEFT_CLICK_AIR: {
                new LeftClickEvent(player, event).callEvent();
                break;
            }
            case LEFT_CLICK_BLOCK: {
                new LeftClickEvent(player, event).callEvent();
                new BlockInteractionEvent(player, event).callEvent();
                break;
            }
            case PHYSICAL: {
                new WorldInteractEvent(player, event).callEvent();
                break;
            }
            case RIGHT_CLICK_AIR: {
                if (event.getHand() != EquipmentSlot.HAND) break;
                new RightClickEvent(player, event).callEvent();
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                if (event.getHand() != EquipmentSlot.HAND) break;
                new RightClickEvent(player, event).callEvent();
                new BlockInteractionEvent(player, event).callEvent();
            }
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.PHYSICAL) {
            if (planet.getWorldPlayers().canBuild(player)) {
                return;
            }
            switch (planet.getFlagValue(PlanetFlags.PlanetFlag.BLOCK_INTERACT)) {
                case 2: {
                    player.sendActionBar(MessageUtils.getLocaleMessage("world.cant-block-interact"));
                    event.setCancelled(true);
                    break;
                }
                case 3: {
                    if (event.getClickedBlock().getType() != Material.COMPARATOR && event.getClickedBlock().getType() != Material.REPEATER && event.getClickedBlock().getType() != Material.NOTE_BLOCK) break;
                    player.sendActionBar(MessageUtils.getLocaleMessage("world.cant-block-interact"));
                    event.setCancelled(true);
                    break;
                }
                case 4: {
                    if (event.getClickedBlock().getType() != Material.CHEST && !event.getClickedBlock().getType().toString().contains("DOOR")) break;
                    player.sendActionBar(MessageUtils.getLocaleMessage("world.cant-block-interact"));
                    event.setCancelled(true);
                    break;
                }
                case 5: {
                    if (!event.getClickedBlock().getType().toString().contains("BUTTON") && !event.getClickedBlock().getType().toString().contains("PRESSURE_PLATE") && event.getClickedBlock().getType() != Material.LEVER) break;
                    player.sendActionBar(MessageUtils.getLocaleMessage("world.cant-block-interact"));
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onMobClick(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet != null) {
            if (planet.getFlagValue(PlanetFlags.PlanetFlag.MOB_INTERACT) == 2 && !planet.getWorldPlayers().canBuild(player)) {
                event.getPlayer().sendActionBar(MessageUtils.getLocaleMessage("world.cant-mob-interact"));
                event.setCancelled(true);
            }
            if (!(planet.getFlagValue(PlanetFlags.PlanetFlag.MOB_INTERACT) != 3 || planet.getWorldPlayers().canBuild(player) || event.getRightClicked().getType() != EntityType.ITEM_FRAME && event.getRightClicked().getType() != EntityType.ARMOR_STAND)) {
                event.getPlayer().sendActionBar(MessageUtils.getLocaleMessage("world.cant-mob-interact"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onMobClick(PlayerInteractAtEntityEvent event) {
        Player player = event.getPlayer();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet != null) {
            if (event.getHand() == EquipmentSlot.HAND) {
                new MobInteractionEvent(player, (PlayerInteractEntityEvent)event).callEvent();
            }
            if (planet.getFlagValue(PlanetFlags.PlanetFlag.MOB_INTERACT) == 2 && !planet.getWorldPlayers().canBuild(player)) {
                event.getPlayer().sendActionBar(MessageUtils.getLocaleMessage("world.cant-mob-interact"));
                event.setCancelled(true);
            }
            if (!(planet.getFlagValue(PlanetFlags.PlanetFlag.MOB_INTERACT) != 3 || planet.getWorldPlayers().canBuild(player) || event.getRightClicked().getType() != EntityType.ITEM_FRAME && event.getRightClicked().getType() != EntityType.ARMOR_STAND)) {
                event.getPlayer().sendActionBar(MessageUtils.getLocaleMessage("world.cant-mob-interact"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onHang(HangingBreakByEntityEvent event) {
        Entity entity = event.getRemover();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (PlayerUtils.isEntityInLobby((Entity)player) && OpenCreative.getSettings().isLobbyDisallowDestroyingBlocks() && !player.hasPermission("opencreative.lobby.destroying-blocks.bypass")) {
            event.setCancelled(true);
            player.sendActionBar(MessageUtils.getLocaleMessage("not-for-lobby"));
            return;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet != null) {
            new MobInteractionEvent(player, event).callEvent();
            if (planet.getFlagValue(PlanetFlags.PlanetFlag.MOB_INTERACT) == 2 && !planet.getWorldPlayers().canBuild(player)) {
                player.sendActionBar(MessageUtils.getLocaleMessage("world.cant-mob-interact"));
                event.setCancelled(true);
            }
            if (planet.getFlagValue(PlanetFlags.PlanetFlag.MOB_INTERACT) == 3 && !planet.getWorldPlayers().canBuild(player) && event.getEntity().getType() == EntityType.ITEM_FRAME) {
                player.sendActionBar(MessageUtils.getLocaleMessage("world.cant-mob-interact"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onFishing(PlayerFishEvent event) {
        Planet planet;
        if (event.getCaught() == null) {
            return;
        }
        if (event.getCaught().getType() == EntityType.ITEM && (planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer())) != null) {
            new FishEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onSpectating(PlayerStartSpectatingEntityEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new StartSpectatingEvent(event.getPlayer()).callEvent();
        }
    }

    @EventHandler
    public void onSpectatingStop(PlayerStopSpectatingEntityEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new StopSpectatingEvent(event.getPlayer()).callEvent();
        }
    }

    @EventHandler
    public void onBedInteract(PlayerBedEnterEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new BedEnterEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onBedInteract(PlayerBedLeaveEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new BedLeaveEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onEntityRename(PlayerNameEntityEvent event) {
        if (event.getName() == null) {
            return;
        }
        String text = PlainTextComponentSerializer.plainText().serialize(event.getName());
        int limit = OpenCreative.getSettings().getItemsMaxEntityNameLength();
        if (text.length() > limit) {
            event.setName((Component)PlainTextComponentSerializer.plainText().deserialize(text.substring(0, limit)));
        }
    }
}

