/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import io.papermc.paper.event.packet.PlayerChunkUnloadEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.util.Vector;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.JumpEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.PlayerMoveEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.StartFlyingEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.StartRunningEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.StartSneakingEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.StopFlyingEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.StopRunningEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.StopSneakingEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.ChunkLoadEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.ChunkUnloadEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class MoveListener
implements Listener {
    @EventHandler
    public void onMove(org.bukkit.event.player.PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.getY() < 0.0 && PlayerUtils.isEntityInDevPlanet((Entity)player)) {
            player.setVelocity(new Vector(0.0, (double)0.6f * Math.ceil(Math.abs(player.getY())), 0.0));
            if (player.getLocation().add(0.0, 1.9, -0.8).getBlock().isSolid()) {
                player.teleport(player.getLocation().add(0.0, 2.5, 1.0));
            }
        }
        if (this.isBlockChanged(event.getFrom(), event.getTo())) {
            new PlayerMoveEvent(event.getPlayer(), event).callEvent();
            if (PlayerUtils.isEntityInDevPlanet((Entity)player)) {
                PlayerUtils.translateSigns(player, 10);
            }
            if (BlockUtils.isOutOfBorders(event.getTo())) {
                if (BlockUtils.isOutOfBorders(event.getFrom())) {
                    player.teleport(player.getWorld().getSpawnLocation());
                } else {
                    player.teleport(event.getFrom());
                }
            }
        }
    }

    @EventHandler
    public void onJump(PlayerJumpEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new JumpEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onSneaking(PlayerToggleSneakEvent event) {
        if (event.isSneaking()) {
            new StartSneakingEvent(event.getPlayer(), event).callEvent();
        } else {
            new StopSneakingEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onFlying(PlayerToggleFlightEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            if (event.isFlying()) {
                new StartFlyingEvent(event.getPlayer(), event).callEvent();
            } else {
                new StopFlyingEvent(event.getPlayer(), event).callEvent();
            }
        }
    }

    @EventHandler
    public void onSprinting(PlayerToggleSprintEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            if (event.isSprinting()) {
                new StartRunningEvent(event.getPlayer()).callEvent();
            } else {
                new StopRunningEvent(event.getPlayer()).callEvent();
            }
        }
    }

    @EventHandler
    public void onChunkLoad(PlayerChunkLoadEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new ChunkLoadEvent(event.getPlayer(), event).callEvent();
        }
    }

    @EventHandler
    public void onChunkUnload(PlayerChunkUnloadEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            new ChunkUnloadEvent(event.getPlayer(), event).callEvent();
        }
    }

    private boolean isBlockChanged(Location from, Location to) {
        return from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ();
    }
}

