/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import java.util.HashSet;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.interaction.PlaceBlockEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.Layout;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class PlaceBlockListener
implements Listener {
    @EventHandler
    public void onChestPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        BlockState blockState = block.getState();
        if (!(blockState instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder container = (InventoryHolder)blockState;
        for (int i = 0; i < container.getInventory().getSize(); ++i) {
            ItemStack insideItem = container.getInventory().getItem(i);
            if (insideItem == null) continue;
            container.getInventory().setItem(i, ItemUtils.fixItem(insideItem));
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(player);
        if (devPlanet != null) {
            Block block = event.getBlock();
            Block blockAgainst = event.getBlockAgainst();
            DevPlatform platform = devPlanet.getPlatformInLocation(event.getBlock().getLocation());
            if (platform == null || block.getY() < 1) {
                event.setCancelled(true);
                Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                return;
            }
            if (blockAgainst.getType() == platform.getFloorMaterial()) {
                if (block.getType() == Material.PISTON && (blockAgainst.getZ() - devPlanet.getDevPlatformer().getPlatformBeginLocation(platform).getBlockZ()) % 4 == 0 && blockAgainst.getRelative(BlockFace.WEST).getType() == platform.getActionMaterial()) {
                    Directional directional = (Directional)block.getBlockData();
                    if (directional.getFacing() != BlockFace.EAST && directional.getFacing() != BlockFace.WEST) {
                        directional.setFacing(player.getFacing().getOppositeFace());
                    }
                    if (directional.getFacing() != BlockFace.EAST && directional.getFacing() != BlockFace.WEST) {
                        directional.setFacing(block.getRelative(BlockFace.WEST).isEmpty() ? BlockFace.WEST : BlockFace.EAST);
                    }
                    block.setBlockData((BlockData)directional);
                } else if ((!block.getType().name().contains("SIGN") || blockAgainst.getX() < 4 || blockAgainst.getX() % 2 != 0) && !devPlanet.getAllowedBlocks().contains(block.getType()) || block.getY() <= 0) {
                    player.sendActionBar(MessageUtils.getLocaleMessage("world.dev-mode.cant-place-on-floor"));
                    Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                    event.setCancelled(true);
                }
            } else if (blockAgainst.getType() == platform.getEventMaterial()) {
                if (devPlanet.getEventsBlocks().contains(block.getType())) {
                    Material additionalBlockMaterial = Material.REDSTONE_ORE;
                    String signText = "unknown";
                    ExecutorCategory executorCategory = ExecutorCategory.getByMaterial(block.getType());
                    ActionCategory actionCategory = ActionCategory.getByMaterial(block.getType());
                    if (executorCategory != null) {
                        signText = executorCategory.name().toLowerCase();
                        additionalBlockMaterial = executorCategory.getAdditionalBlock();
                    } else if (actionCategory != null) {
                        signText = actionCategory.name().toLowerCase();
                        additionalBlockMaterial = actionCategory.getAdditionalBlock();
                    }
                    devPlanet.setCodeChanged(true);
                    PlaceBlockListener.placeDevBlock(block.getLocation(), block.getType(), additionalBlockMaterial, devPlanet.getSignMaterial(), signText);
                } else {
                    player.sendActionBar(MessageUtils.getLocaleMessage("world.dev-mode.cant-place-action-on-event"));
                    Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                    event.setCancelled(true);
                }
            } else if (blockAgainst.getType() == platform.getActionMaterial()) {
                if (devPlanet.getActionsBlocks().contains(block.getType())) {
                    Material additionalBlockMaterial = Material.REDSTONE_ORE;
                    String signText = "unknown";
                    ExecutorCategory executorCategory = ExecutorCategory.getByMaterial(block.getType());
                    ActionCategory actionCategory = ActionCategory.getByMaterial(block.getType());
                    if (executorCategory != null) {
                        signText = executorCategory.name().toLowerCase();
                        additionalBlockMaterial = executorCategory.getAdditionalBlock();
                    } else if (actionCategory != null) {
                        signText = actionCategory.name().toLowerCase();
                        additionalBlockMaterial = actionCategory.getAdditionalBlock();
                    }
                    if (block.getRelative(BlockFace.EAST).getType() == Material.PISTON) {
                        PlaceBlockListener.move(block.getLocation(), BlockFace.EAST);
                    }
                    devPlanet.setCodeChanged(true);
                    PlaceBlockListener.placeDevBlock(block.getLocation(), block.getType(), additionalBlockMaterial, devPlanet.getSignMaterial(), signText);
                } else {
                    player.sendActionBar(MessageUtils.getLocaleMessage("world.dev-mode.cant-place-event-on-action"));
                    Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                    event.setCancelled(true);
                }
            } else {
                if (block.getType() != Material.COMPARATOR) {
                    Sounds.DEV_NOT_ALLOWED.play((Audience)player);
                }
                event.setCancelled(true);
            }
        } else if (planet != null) {
            if (ChangedWorld.isPlayerWithLocation(player) && !planet.getWorldPlayers().canBuild(player)) {
                player.sendActionBar(MessageUtils.getLocaleMessage("not-builder"));
                event.setCancelled(true);
                return;
            }
            new PlaceBlockEvent(event.getPlayer(), event).callEvent();
        } else if (PlayerUtils.isEntityInLobby((Entity)player) && OpenCreative.getSettings().isLobbyDisallowPlacingBlocks() && !player.hasPermission("opencreative.lobby.placing-blocks.bypass")) {
            event.setCancelled(true);
            player.sendActionBar(MessageUtils.getLocaleMessage("not-for-lobby"));
        }
    }

    public static void placeDevBlock(Location location, Material material, Material additionalBlockMaterial, Material signMaterial, String signText) {
        Block block = location.getBlock();
        block.setType(material);
        Block eastBlock = block.getRelative(BlockFace.EAST);
        eastBlock.setType(additionalBlockMaterial);
        if (eastBlock.getType() == Material.PISTON) {
            Directional data = (Directional)eastBlock.getBlockData();
            data.setFacing(BlockFace.EAST);
            eastBlock.setBlockData((BlockData)data);
            Block farEastBlock = eastBlock.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST);
            PlaceBlockListener.move(eastBlock.getLocation(), BlockFace.EAST);
            farEastBlock.setType(Material.PISTON);
            data = (Directional)farEastBlock.getBlockData();
            data.setFacing(BlockFace.WEST);
            farEastBlock.setBlockData((BlockData)data);
        }
        Block wallSign = block.getRelative(BlockFace.SOUTH);
        wallSign.setType(signMaterial);
        Sign sign = (Sign)wallSign.getState();
        sign.setLine(1, signText);
        if (block.getType() == Material.OXIDIZED_COPPER) {
            sign.setLine(2, "20");
        }
        if (block.getType() == Material.PURPUR_BLOCK) {
            sign.setLine(1, "");
            sign.setLine(3, "selection_set");
        }
        sign.update();
        PlayerUtils.translateBlockSign(wallSign);
        Directional data = (Directional)wallSign.getBlockData();
        data.setFacing(BlockFace.SOUTH);
        wallSign.setBlockData((BlockData)data);
    }

    public static boolean move(Location location, BlockFace face) {
        block8: {
            Location end;
            Location begin;
            block7: {
                DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(location.getWorld());
                if (devPlanet == null) {
                    return false;
                }
                DevPlatform platform = devPlanet.getPlatformInLocation(location);
                if (platform == null) {
                    return false;
                }
                begin = devPlanet.getDevPlatformer().getPlatformBeginLocation(platform);
                end = devPlanet.getDevPlatformer().getPlatformEndLocation(platform);
                if (face != BlockFace.EAST) break block7;
                if (location.getX() >= (double)(end.getBlockX() - 4)) {
                    return false;
                }
                HashSet<Block> movedBlocks = new HashSet<Block>();
                for (double x = (double)(end.getBlockX() - 5); x > location.getX(); x -= 1.0) {
                    Block oldBlock = location.getWorld().getBlockAt((int)x, location.getBlockY(), location.getBlockZ());
                    if (oldBlock.getType() == Material.AIR || movedBlocks.contains(oldBlock)) continue;
                    Block newBlock = location.getWorld().getBlockAt((int)x + 2, location.getBlockY(), location.getBlockZ());
                    PlaceBlockListener.moveCodingBlock(oldBlock, newBlock);
                    movedBlocks.add(newBlock);
                }
                break block8;
            }
            if (face != BlockFace.WEST) break block8;
            if (location.getX() <= (double)(begin.getBlockX() + 5)) {
                return false;
            }
            if (!location.getBlock().isEmpty()) {
                return false;
            }
            HashSet<Block> movedBlocks = new HashSet<Block>();
            for (double x = location.getX() + 1.0; x < (double)end.getBlockX(); x += 1.0) {
                Block oldBlock = location.getWorld().getBlockAt((int)x, location.getBlockY(), location.getBlockZ());
                if (oldBlock.getType() == Material.AIR || movedBlocks.contains(oldBlock)) continue;
                Block newBlock = location.getWorld().getBlockAt((int)x - 2, location.getBlockY(), location.getBlockZ());
                PlaceBlockListener.moveCodingBlock(oldBlock, newBlock);
                movedBlocks.add(oldBlock);
            }
        }
        return true;
    }

    public static void moveCodingBlock(Block oldBlock, Block newBlock) {
        BlockState blockState;
        Block oldSignBlock = oldBlock.getRelative(BlockFace.SOUTH);
        Block oldContainerBlock = oldBlock.getRelative(BlockFace.UP);
        Block newSignBlock = newBlock.getRelative(BlockFace.SOUTH);
        Block newContainerBlock = newBlock.getRelative(BlockFace.UP);
        newBlock.setType(oldBlock.getType());
        newBlock.setBlockData(oldBlock.getBlockData());
        if (oldSignBlock.getType().toString().contains("WALL_SIGN")) {
            newSignBlock.setType(oldSignBlock.getType());
            BlockUtils.copySignData((Sign)oldSignBlock.getState(), (Sign)newSignBlock.getState());
            PlayerUtils.translateBlockSign(newSignBlock);
        }
        if ((blockState = oldContainerBlock.getState()) instanceof InventoryHolder) {
            Object object;
            Layout layout;
            InventoryHolder container = (InventoryHolder)blockState;
            newContainerBlock.setType(oldContainerBlock.getType());
            newContainerBlock.setBlockData(oldContainerBlock.getBlockData());
            DevPlanet devPlanet = OpenCreative.getPlanetsManager().getDevPlanet(oldContainerBlock.getWorld());
            if (devPlanet != null && (layout = devPlanet.getOpenedMenu(oldContainerBlock.getLocation())) != null) {
                object = layout.getViewers().iterator();
                while (object.hasNext()) {
                    Player player = (Player)object.next();
                    player.closeInventory();
                }
            }
            if ((object = newContainerBlock.getState()) instanceof InventoryHolder) {
                InventoryHolder newContainer = (InventoryHolder)object;
                newContainer.getInventory().setContents(container.getInventory().getContents());
            }
        }
        oldSignBlock.setType(Material.AIR);
        oldBlock.setType(Material.AIR);
        oldContainerBlock.setType(Material.AIR);
    }
}

