/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.managers.blocks;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.managers.blocks.BlocksManager;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class WorldEditManager
implements BlocksManager {
    @Override
    public int setBlocksType(@NotNull Location first, @NotNull Location second, @NotNull Material material, int limit) {
        int n;
        block11: {
            if (first == null) {
                WorldEditManager.$$$reportNull$$$0(0);
            }
            if (second == null) {
                WorldEditManager.$$$reportNull$$$0(1);
            }
            if (material == null) {
                WorldEditManager.$$$reportNull$$$0(2);
            }
            World world = BukkitAdapter.adapt((org.bukkit.World)first.getWorld());
            CuboidRegion selection = new CuboidRegion(world, BlockVector3.at((int)0, (int)80, (int)0), BlockVector3.at((int)10, (int)80, (int)10));
            EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(world).maxBlocks(limit).build();
            try {
                BlockState blockState = BukkitAdapter.adapt((BlockData)material.createBlockData());
                n = editSession.setBlocks((Region)selection, (BlockStateHolder)blockState);
                if (editSession == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (editSession != null) {
                        try {
                            editSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MaxChangedBlocksException ex) {
                    return 0;
                }
            }
            editSession.close();
        }
        return n;
    }

    @Override
    public void init() {
        WorldEdit.getInstance().getEventBus().register(new Object(this){

            @Subscribe
            public void onEditSessionEvent(EditSessionEvent event) {
                if (event.getStage() != EditSession.Stage.BEFORE_HISTORY) {
                    return;
                }
                if (event.getActor() == null) {
                    return;
                }
                org.bukkit.World bukkitWorld = BukkitAdapter.adapt((World)event.getWorld());
                Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorld(bukkitWorld);
                if (planet == null) {
                    if (WorldUtils.isLobbyWorld(bukkitWorld) && OpenCreative.getSettings().isLobbyDisallowWorldEdit() && !event.getActor().hasPermission("opencreative.lobby.world-edit.bypass")) {
                        event.setExtent((Extent)new DisallowedExtent(event.getExtent()));
                    }
                    return;
                }
                event.setExtent((Extent)new PlanetExtent(planet, event.getExtent()));
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return WorldEdit.getInstance() != null;
    }

    @Override
    public String getName() {
        return "WorldEdit Blocks Manager";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "first";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "second";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "material";
                break;
            }
        }
        objectArray[1] = "ua/mcchickenstudio/opencreative/managers/blocks/WorldEditManager";
        objectArray[2] = "setBlocksType";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class DisallowedExtent
    extends AbstractDelegateExtent {
        public static BlockState AIRSTATE = BlockTypes.AIR.getDefaultState();
        public static BaseBlock AIRBASE = BlockTypes.AIR.getDefaultState().toBaseBlock();

        public DisallowedExtent(Extent extent) {
            super(extent);
        }

        public boolean setBlock(BlockVector3 location, BlockStateHolder block) {
            return false;
        }

        public Entity createEntity(com.sk89q.worldedit.util.Location location, BaseEntity entity) {
            return null;
        }

        public boolean setBiome(BlockVector3 location, BiomeType biome) {
            return false;
        }

        public BlockState getBlock(BlockVector3 location) {
            return AIRSTATE;
        }

        public BaseBlock getFullBlock(BlockVector3 location) {
            return AIRBASE;
        }
    }

    static class PlanetExtent
    extends AbstractDelegateExtent {
        private final Planet planet;
        public static BlockState AIRSTATE = BlockTypes.AIR.getDefaultState();
        public static BaseBlock AIRBASE = BlockTypes.AIR.getDefaultState().toBaseBlock();

        public PlanetExtent(Planet planet, Extent extent) {
            super(extent);
            this.planet = planet;
        }

        public boolean setBlock(BlockVector3 location, BlockStateHolder block) {
            return this.planet.getWorld().getWorldBorder().isInside(new Location(this.planet.getWorld(), (double)location.x(), (double)location.y(), (double)location.z())) && super.setBlock(location, block);
        }

        public Entity createEntity(com.sk89q.worldedit.util.Location location, BaseEntity entity) {
            if (this.planet.getWorld().getWorldBorder().isInside(new Location(this.planet.getWorld(), location.x(), location.y(), location.z()))) {
                super.createEntity(location, entity);
            }
            return null;
        }

        public boolean setBiome(BlockVector3 location, BiomeType biome) {
            return this.planet.getWorld().getWorldBorder().isInside(new Location(this.planet.getWorld(), (double)location.x(), (double)location.y(), (double)location.z())) && super.setBiome(location, biome);
        }

        public BlockState getBlock(BlockVector3 location) {
            if (this.planet.getWorld().getWorldBorder().isInside(new Location(this.planet.getWorld(), (double)location.x(), (double)location.y(), (double)location.z()))) {
                return super.getBlock(location);
            }
            return AIRSTATE;
        }

        public BaseBlock getFullBlock(BlockVector3 location) {
            if (this.planet.getWorld().getWorldBorder().isInside(new Location(this.planet.getWorld(), (double)location.x(), (double)location.y(), (double)location.z()))) {
                return super.getFullBlock(location);
            }
            return AIRBASE;
        }
    }
}

