/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.managers.hints;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.managers.hints.HintManager;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class Hints
implements HintManager {
    @Override
    public void checkForHints(@NotNull Player player) {
        String hint;
        if (player == null) {
            Hints.$$$reportNull$$$0(0);
        }
        if (!PlayerUtils.isEntityInDevPlanet((Entity)player)) {
            if (player.getInventory().getItemInMainHand().getType() != Material.PAPER) {
                return;
            }
            if (ChangedWorld.isPlayerWithLocation(player)) {
                player.sendActionBar(MessageUtils.getLocaleComponent("environment.hints.location.build", (OfflinePlayer)player));
            }
            return;
        }
        Block block = player.getTargetBlockExact(5);
        if (block != null && block.getBlockData() instanceof WallSign) {
            Block farBlock = block.getRelative(BlockFace.NORTH);
            ExecutorCategory executor = ExecutorCategory.getByMaterial(farBlock.getType());
            if (executor != null) {
                String hint2 = switch (executor) {
                    case ExecutorCategory.CYCLE -> "cycle";
                    case ExecutorCategory.METHOD -> "method";
                    case ExecutorCategory.FUNCTION -> "function";
                    default -> "event";
                };
                player.sendActionBar(MessageUtils.getLocaleComponent("environment.hints." + hint2, (OfflinePlayer)player));
                return;
            }
            ActionCategory action = ActionCategory.getByMaterial(farBlock.getType());
            if (action != null) {
                String hint3 = switch (action) {
                    case ActionCategory.LAUNCH_FUNCTION_ACTION -> "launch-function";
                    case ActionCategory.LAUNCH_METHOD_ACTION -> "launch-method";
                    default -> action.isCondition() ? "condition" : "action";
                };
                player.sendActionBar(MessageUtils.getLocaleComponent("environment.hints." + hint3, (OfflinePlayer)player));
            }
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.isEmpty()) {
            return;
        }
        ValueType type = ValueType.getByMaterial(item.getType());
        if (type == ValueType.TEXT && item.getType() != Material.BOOK) {
            if (item.getType() == Material.SPLASH_POTION || item.getType() == Material.LINGERING_POTION) {
                player.sendActionBar(MessageUtils.getLocaleComponent("environment.hints.potion", (OfflinePlayer)player));
            }
            return;
        }
        switch (type) {
            case TEXT: 
            case NUMBER: 
            case EVENT_VALUE: 
            case VECTOR: 
            case POTION: 
            case PARTICLE: 
            case VARIABLE: 
            case BOOLEAN: {
                String string = type.name().toLowerCase().replace("_", "-");
                break;
            }
            case LOCATION: {
                String string = "location.dev";
                break;
            }
            default: {
                String string = hint = "";
            }
        }
        if (!hint.isEmpty()) {
            player.sendActionBar(MessageUtils.getLocaleComponent("environment.hints." + hint, (OfflinePlayer)player));
        }
    }

    @Override
    public void init() {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (PlayerUtils.isEntityInLobby((Entity)player)) continue;
                    Hints.this.checkForHints(player);
                }
            }
        };
        runnable.runTaskTimer((Plugin)OpenCreative.getPlugin(), 40L, 40L);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return "Default Hints";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "player", "ua/mcchickenstudio/opencreative/managers/hints/Hints", "checkForHints"));
    }
}

