/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.managers.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedTeamParameters;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.managers.packets.PacketManager;
import ua.mcchickenstudio.opencreative.utils.world.cache.ChunkPacketListener;

public final class ProtocolLibManager
implements PacketManager {
    private ProtocolManager manager;

    @Override
    public void init() {
        this.manager = ProtocolLibrary.getProtocolManager();
        this.manager.addPacketListener((PacketListener)new ChunkPacketListener((Plugin)OpenCreative.getPlugin()));
    }

    @Override
    public void displayGlowingBlock(final @NotNull Player player, @NotNull Location location) {
        if (player == null) {
            ProtocolLibManager.$$$reportNull$$$0(0);
        }
        if (location == null) {
            ProtocolLibManager.$$$reportNull$$$0(1);
        }
        final World world = player.getWorld();
        UUID uuid = UUID.randomUUID();
        int id = 300;
        if (location.getX() == (double)location.getBlockX() && location.getZ() == (double)location.getBlockZ()) {
            location.add(0.5, 0.0, 0.5);
        }
        PacketContainer spawnEntityPacket = this.getSpawnFallingBlockPacket(id, uuid, location);
        PacketContainer entityDataPacket = this.getFallingBlockDataPacket(id);
        PacketContainer createTeamPacket = this.getTeamCreationPacket(uuid, ChatColor.GREEN);
        final PacketContainer hideGlowingPacket = this.getRemoveEntityPacket(id);
        this.manager.sendServerPacket(player, createTeamPacket);
        this.manager.sendServerPacket(player, spawnEntityPacket);
        this.manager.sendServerPacket(player, entityDataPacket);
        new BukkitRunnable(){

            public void run() {
                if (player.getWorld() == world) {
                    ProtocolLibManager.this.manager.sendServerPacket(player, hideGlowingPacket);
                    ProtocolLibManager.this.manager.sendServerPacket(player, ProtocolLibManager.this.getTeamDeletionPacket());
                }
            }
        }.runTaskLater((Plugin)OpenCreative.getPlugin(), 60L);
    }

    @Override
    public void sendChestOpenAnimation(@NotNull Player player, @NotNull Block block) {
        if (player == null) {
            ProtocolLibManager.$$$reportNull$$$0(2);
        }
        if (block == null) {
            ProtocolLibManager.$$$reportNull$$$0(3);
        }
        PacketContainer blockActionPacket = this.manager.createPacket(PacketType.Play.Server.BLOCK_ACTION);
        blockActionPacket.getBlockPositionModifier().write(0, (Object)new BlockPosition(block.getLocation().toVector()));
        blockActionPacket.getIntegers().write(0, (Object)1);
        blockActionPacket.getIntegers().write(1, (Object)1);
        this.manager.sendServerPacket(player, blockActionPacket);
    }

    @Override
    public void sendChestCloseAnimation(@NotNull Player player, @NotNull Block block) {
        if (player == null) {
            ProtocolLibManager.$$$reportNull$$$0(4);
        }
        if (block == null) {
            ProtocolLibManager.$$$reportNull$$$0(5);
        }
        PacketContainer blockActionPacket = this.manager.createPacket(PacketType.Play.Server.BLOCK_ACTION);
        blockActionPacket.getBlockPositionModifier().write(0, (Object)new BlockPosition(block.getLocation().toVector()));
        blockActionPacket.getIntegers().write(0, (Object)1);
        blockActionPacket.getIntegers().write(1, (Object)0);
        this.manager.sendServerPacket(player, blockActionPacket);
    }

    @Override
    public void displayAsSpectatorName(@NotNull Player player, @NotNull Player receiver) {
        if (player == null) {
            ProtocolLibManager.$$$reportNull$$$0(6);
        }
        if (receiver == null) {
            ProtocolLibManager.$$$reportNull$$$0(7);
        }
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoActions().write(0, EnumSet.of(EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE));
        packet.getPlayerInfoDataLists().write(1, Collections.singletonList(new PlayerInfoData(new WrappedGameProfile(player.getUniqueId(), player.getName()), player.getPing(), EnumWrappers.NativeGameMode.SPECTATOR, WrappedChatComponent.fromText((String)player.getName()))));
        this.manager.sendServerPacket(receiver, packet);
    }

    @Override
    public void removeSpectatorName(@NotNull Player player, @NotNull Player receiver) {
        if (player == null) {
            ProtocolLibManager.$$$reportNull$$$0(8);
        }
        if (receiver == null) {
            ProtocolLibManager.$$$reportNull$$$0(9);
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoActions().write(0, EnumSet.of(EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE));
        packet.getPlayerInfoDataLists().write(1, Collections.singletonList(new PlayerInfoData(new WrappedGameProfile(player.getUniqueId(), player.getName()), player.getPing(), EnumWrappers.NativeGameMode.valueOf((String)player.getGameMode().name()), WrappedChatComponent.fromText((String)player.getName()))));
        this.manager.sendServerPacket(receiver, packet);
    }

    @Override
    public void showBlockForPlayer(@NotNull Player player, @NotNull Location location, @NotNull Material material) {
        if (player == null) {
            ProtocolLibManager.$$$reportNull$$$0(10);
        }
        if (location == null) {
            ProtocolLibManager.$$$reportNull$$$0(11);
        }
        if (material == null) {
            ProtocolLibManager.$$$reportNull$$$0(12);
        }
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.BLOCK_CHANGE);
        packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        packet.getBlockData().write(0, (Object)WrappedBlockData.createData((Material)material));
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    @Override
    public boolean isEnabled() {
        return this.manager != null;
    }

    @Override
    public String getName() {
        return "ProtocolLib Packet Manager";
    }

    private PacketContainer getRemoveEntityPacket(int id) {
        PacketContainer hideGlowingPacket = this.manager.createPacket(PacketType.Play.Server.ENTITY_DESTROY);
        hideGlowingPacket.getModifier().write(0, (Object)new IntArrayList(new int[]{id}));
        return hideGlowingPacket;
    }

    private PacketContainer getTeamCreationPacket(UUID uuid, ChatColor color) {
        PacketContainer createTeamPacket = this.manager.createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        createTeamPacket.getIntegers().write(0, (Object)0);
        createTeamPacket.getStrings().write(0, (Object)"oc_block_display");
        createTeamPacket.getOptionalTeamParameters().write(0, Optional.of(WrappedTeamParameters.newBuilder().displayName(WrappedChatComponent.fromText((String)"oc_block_display")).prefix(WrappedChatComponent.fromText((String)"oc")).suffix(WrappedChatComponent.fromText((String)"oc")).nametagVisibility("never").collisionRule("never").color(EnumWrappers.ChatFormatting.fromBukkit((ChatColor)color)).build()));
        createTeamPacket.getSpecificModifier(Collection.class).write(0, Collections.singletonList(uuid.toString()));
        return createTeamPacket;
    }

    private PacketContainer getTeamDeletionPacket() {
        PacketContainer deletionTeamPacket = this.manager.createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        deletionTeamPacket.getIntegers().write(0, (Object)1);
        deletionTeamPacket.getStrings().write(0, (Object)"oc_block_display");
        return deletionTeamPacket;
    }

    private PacketContainer getFallingBlockDataPacket(int id) {
        PacketContainer entityDataPacket = this.manager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        entityDataPacket.getIntegers().write(0, (Object)id);
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        watcher.setByte(0, (byte)96, true);
        watcher.setInteger(16, Integer.valueOf(2), true);
        watcher.setBoolean(5, Boolean.valueOf(true), true);
        ArrayList<WrappedDataValue> wrappedDataValueList = new ArrayList<WrappedDataValue>();
        for (WrappedWatchableObject entry : watcher.getWatchableObjects()) {
            if (entry == null) continue;
            WrappedDataWatcher.WrappedDataWatcherObject watcherObject = entry.getWatcherObject();
            wrappedDataValueList.add(new WrappedDataValue(watcherObject.getIndex(), watcherObject.getSerializer(), entry.getRawValue()));
        }
        entityDataPacket.getDataValueCollectionModifier().write(0, wrappedDataValueList);
        return entityDataPacket;
    }

    private PacketContainer getSpawnFallingBlockPacket(int id, UUID uuid, Location location) {
        PacketContainer spawnEntityPacket = this.manager.createPacket(PacketType.Play.Server.SPAWN_ENTITY);
        spawnEntityPacket.getIntegers().write(0, (Object)id);
        spawnEntityPacket.getUUIDs().write(0, (Object)uuid);
        spawnEntityPacket.getEntityTypeModifier().write(0, (Object)EntityType.SLIME);
        spawnEntityPacket.getDoubles().write(0, (Object)location.getX()).write(1, (Object)location.getY()).write(2, (Object)location.getZ());
        return spawnEntityPacket;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "material";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/managers/packets/ProtocolLibManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "displayGlowingBlock";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sendChestOpenAnimation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "sendChestCloseAnimation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "displayAsSpectatorName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeSpectatorName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "showBlockForPlayer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

