/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.managers.space;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.events.planet.PlanetDeletionEvent;
import ua.mcchickenstudio.opencreative.events.planet.PlanetRegisterEvent;
import ua.mcchickenstudio.opencreative.events.planet.PlanetSharingChangeEvent;
import ua.mcchickenstudio.opencreative.managers.space.PlanetsManager;
import ua.mcchickenstudio.opencreative.menus.world.WorldMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;
import ua.mcchickenstudio.opencreative.utils.world.generators.FlatGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldTemplate;

public final class Space
implements PlanetsManager {
    private final Set<Planet> planets = new HashSet<Planet>();
    private final Set<Planet> corruptedPlanets = new HashSet<Planet>();

    @Override
    @NotNull
    public Set<Planet> getPlanets() {
        Set<Planet> set = this.planets;
        if (set == null) {
            Space.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Planet> getCorruptedPlanets() {
        Set<Planet> set = this.corruptedPlanets;
        if (set == null) {
            Space.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public void registerPlanet(@NotNull Planet planet) {
        if (planet == null) {
            Space.$$$reportNull$$$0(2);
        }
        if (planet.isCorrupted()) {
            this.corruptedPlanets.add(planet);
        } else {
            this.planets.add(planet);
        }
        new PlanetRegisterEvent(planet).callEvent();
    }

    @Override
    public void unregisterPlanet(@NotNull Planet planet) {
        if (planet == null) {
            Space.$$$reportNull$$$0(3);
        }
        this.planets.remove(planet);
        this.corruptedPlanets.remove(planet);
    }

    @Override
    public void createPlanet(@NotNull Player owner, int id, @NotNull WorldGenerator generator) {
        if (owner == null) {
            Space.$$$reportNull$$$0(4);
        }
        if (generator == null) {
            Space.$$$reportNull$$$0(5);
        }
        this.createPlanet(owner, id, generator, World.Environment.NORMAL, new Random().nextInt(), false);
    }

    @Override
    public void createPlanet(@NotNull Player owner, int id, @NotNull WorldTemplate template) {
        File worldTemplateFolder;
        if (owner == null) {
            Space.$$$reportNull$$$0(6);
        }
        if (template == null) {
            Space.$$$reportNull$$$0(7);
        }
        if (!(worldTemplateFolder = new File(String.valueOf(OpenCreative.getPlugin().getDataPath()) + File.separator + "templates" + File.separator + template.getFolderName())).exists() || !worldTemplateFolder.isDirectory()) {
            ErrorUtils.sendPlayerErrorMessage(owner, "Failed to create world by template " + template.getID() + ", because folder doesn't exists.");
            ErrorUtils.sendCriticalErrorMessage("Failed to create world for planet " + id + " by " + owner.getName() + ". Folder " + template.getFolderName() + " doesn't exists, or it's not directory.");
            return;
        }
        File devTemplateFolder = new File(worldTemplateFolder.getPath() + "dev");
        File planetFolder = new File(Bukkit.getWorldContainer().getPath() + File.separator + "planets" + File.separator + "planet" + id + File.separator);
        File planetDevFolder = new File(planetFolder.getPath() + "dev");
        FileUtils.copyFilesToDirectory(worldTemplateFolder, planetFolder);
        if (devTemplateFolder.exists() && devTemplateFolder.isDirectory()) {
            FileUtils.copyFilesToDirectory(devTemplateFolder, planetDevFolder);
        }
        this.createPlanet(owner, id, new FlatGenerator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createPlanet(@NotNull Player owner, int id, @NotNull WorldGenerator generator, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull World.Environment environment, long seed, boolean bl) {
        void generateStructures;
        if (owner == null) {
            Space.$$$reportNull$$$0(8);
        }
        if (generator == null) {
            Space.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            Space.$$$reportNull$$$0(10);
        }
        long startTime = System.currentTimeMillis();
        owner.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("creating-world.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("creating-world.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(2L))));
        OpenCreative.getPlugin().getLogger().info("Creating new planet " + id + " by " + owner.getName() + "...");
        FileUtils.createWorldSettings(id, owner, environment, generator.getID());
        Planet planet = new Planet(id);
        if (planet.getTerritory().generateWorld(generator, environment, seed, (boolean)generateStructures) != null) {
            long endTime = System.currentTimeMillis();
            OpenCreative.getPlugin().getLogger().info("World for planet " + id + " successfully generated in " + (endTime - startTime) + " ms");
            planet.connectPlayer(owner);
        } else {
            ErrorUtils.sendCriticalErrorMessage("Failed to create world for planet " + id + " by " + owner.getName() + ". World is null.");
            ErrorUtils.sendPlayerErrorMessage(owner, "Failed to create world, world is null.");
        }
    }

    @Override
    @NotNull
    public Set<Planet> getPlanetsByOwner(@NotNull Player player) {
        if (player == null) {
            Space.$$$reportNull$$$0(11);
        }
        Set<Planet> set = this.getPlanetsByOwner(player.getName());
        if (set == null) {
            Space.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    public boolean deletePlanet(@NotNull Planet planet) {
        if (planet == null) {
            Space.$$$reportNull$$$0(13);
        }
        OpenCreative.getPlugin().getLogger().info("Deleting planet " + planet.getId());
        new PlanetDeletionEvent(planet).callEvent();
        try {
            for (Player p : planet.getPlayers()) {
                PlayerUtils.teleportToLobby(p);
                if (!(p.getOpenInventory().getTopInventory().getHolder() instanceof WorldMenu)) continue;
                p.closeInventory();
            }
            PlanetSharingChangeEvent planetEvent = new PlanetSharingChangeEvent(planet, planet.getSharing(), Planet.Sharing.PUBLIC);
            planetEvent.callEvent();
            if (!planetEvent.isCancelled()) {
                planet.setSharing(Planet.Sharing.CLOSED);
            }
            this.unregisterPlanet(planet);
            if (planet.isLoaded()) {
                Bukkit.unloadWorld((String)planet.getWorldName(), (boolean)false);
                if (planet.getDevPlanet().isLoaded()) {
                    Bukkit.unloadWorld((String)planet.getDevPlanet().getWorldName(), (boolean)false);
                }
            }
            FileUtils.deleteFolder(FileUtils.getPlanetFolder(planet));
            FileUtils.deleteFolder(FileUtils.getDevPlanetFolder(planet.getDevPlanet()));
            return true;
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("Error while deleting world " + planet.getId(), error);
            return false;
        }
    }

    @Override
    @NotNull
    public List<Planet> getRecommendedPlanets() {
        ArrayList<Planet> featuredPlanets = new ArrayList<Planet>();
        Set<Integer> featuredIds = OpenCreative.getSettings().getRecommendedWorldsIDs();
        for (int id : featuredIds) {
            Planet planet = this.getPlanetById(String.valueOf(id));
            if (planet == null) continue;
            featuredPlanets.add(planet);
        }
        ArrayList<Planet> arrayList = featuredPlanets;
        if (arrayList == null) {
            Space.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Planet> getPlanetsContainingName(@NotNull String worldName) {
        if (worldName == null) {
            Space.$$$reportNull$$$0(15);
        }
        HashSet<Planet> foundPlanets = new HashSet<Planet>();
        for (Planet planet : this.planets) {
            if (!planet.getInformation().getDisplayName().toLowerCase().contains(worldName.toLowerCase())) continue;
            foundPlanets.add(planet);
        }
        HashSet<Planet> hashSet = foundPlanets;
        if (hashSet == null) {
            Space.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<Planet> getPlanetsContainingID(@NotNull String worldID) {
        if (worldID == null) {
            Space.$$$reportNull$$$0(17);
        }
        HashSet<Planet> foundPlanets = new HashSet<Planet>();
        for (Planet planet : this.planets) {
            if (!planet.getInformation().getCustomID().toLowerCase().contains(worldID.toLowerCase())) continue;
            foundPlanets.add(planet);
        }
        HashSet<Planet> hashSet = foundPlanets;
        if (hashSet == null) {
            Space.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<Planet> getPlanetsByOwner(@NotNull String owner) {
        if (owner == null) {
            Space.$$$reportNull$$$0(19);
        }
        HashSet<Planet> foundPlanets = new HashSet<Planet>();
        for (Planet planet : this.planets) {
            if (!planet.isOwner(owner)) continue;
            foundPlanets.add(planet);
        }
        HashSet<Planet> hashSet = foundPlanets;
        if (hashSet == null) {
            Space.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @Override
    public Planet getPlanetByPlayer(@NotNull Player player) {
        World world;
        if (player == null) {
            Space.$$$reportNull$$$0(21);
        }
        if (!WorldUtils.isPlanet(world = player.getWorld())) {
            return null;
        }
        String id = world.getName().replace("./planets/planet", "").replace("dev", "");
        for (Planet planet : this.planets) {
            if (!id.equals(String.valueOf(planet.getId()))) continue;
            return planet;
        }
        return null;
    }

    @Override
    public DevPlanet getDevPlanet(@NotNull Player player) {
        if (player == null) {
            Space.$$$reportNull$$$0(22);
        }
        if (!WorldUtils.isDevPlanet(player.getWorld())) {
            return null;
        }
        Planet planet = this.getPlanetByPlayer(player);
        return planet != null ? planet.getDevPlanet() : null;
    }

    @Override
    public DevPlanet getDevPlanet(@NotNull World world) {
        if (world == null) {
            Space.$$$reportNull$$$0(23);
        }
        if (!WorldUtils.isDevPlanet(world)) {
            return null;
        }
        for (Planet planet : this.planets) {
            if (!world.equals((Object)planet.getDevPlanet().getWorld())) continue;
            return planet.getDevPlanet();
        }
        return null;
    }

    @Override
    public Planet getPlanetByWorld(@NotNull World world) {
        if (world == null) {
            Space.$$$reportNull$$$0(24);
        }
        if (!WorldUtils.isPlanet(world) && !WorldUtils.isDevPlanet(world)) {
            return null;
        }
        String id = world.getName().replace("./planets/planet", "").replace("dev", "");
        for (Planet planet : this.planets) {
            if (!id.equals(String.valueOf(planet.getId()))) continue;
            return planet;
        }
        return null;
    }

    @Override
    public Planet getPlanetByWorldName(@NotNull String worldName) {
        if (worldName == null) {
            Space.$$$reportNull$$$0(25);
        }
        for (Planet planet : this.planets) {
            if (!planet.getWorldName().equalsIgnoreCase(worldName)) continue;
            return planet;
        }
        return null;
    }

    @Override
    public Planet getPlanetById(@NotNull String id) {
        if (id == null) {
            Space.$$$reportNull$$$0(26);
        }
        for (Planet planet : this.planets) {
            if (!id.equalsIgnoreCase(String.valueOf(planet.getId()))) continue;
            return planet;
        }
        return null;
    }

    @Override
    public Planet getPlanetByCustomID(@NotNull String customID) {
        if (customID == null) {
            Space.$$$reportNull$$$0(27);
        }
        for (Planet planet : this.planets) {
            if (!planet.getInformation().getCustomID().equalsIgnoreCase(customID)) continue;
            return planet;
        }
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isStableConnection() {
        return true;
    }

    @Override
    public String getName() {
        return "Planet Manager";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 21, 22, 23, 24, 25, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/managers/space/Space";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "planet";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worldName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worldID";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "world";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorruptedPlanets";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/managers/space/Space";
                break;
            }
            case 12: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanetsByOwner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedPlanets";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanetsContainingName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanetsContainingID";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerPlanet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterPlanet";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPlanet";
                break;
            }
            case 11: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetsByOwner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deletePlanet";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetsContainingName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetsContainingID";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetByPlayer";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDevPlanet";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetByWorld";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetByWorldName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetById";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetByCustomID";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 21, 22, 23, 24, 25, 26, 27 -> new IllegalArgumentException(string);
        };
    }
}

