/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.managers.stability;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.managers.stability.StabilityManager;
import ua.mcchickenstudio.opencreative.managers.stability.StabilityState;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class Watchdog
implements StabilityManager {
    private FileStore STORAGE_VOLUME;
    private BukkitRunnable runnable;
    private StabilityState pluginState = StabilityState.FINE;
    private StabilityState databaseState = StabilityState.FINE;
    private StabilityState storageState = StabilityState.FINE;
    private StabilityState memoryState = StabilityState.FINE;
    private StabilityState ticksState = StabilityState.FINE;

    @Override
    public void init() {
        try {
            this.STORAGE_VOLUME = Files.getFileStore(Paths.get(".", new String[0]));
        }
        catch (IOException ignored) {
            this.STORAGE_VOLUME = null;
        }
        if (this.runnable != null) {
            this.runnable.cancel();
        }
        this.runnable = new BukkitRunnable(){

            public void run() {
                long availableSpace = Watchdog.this.getAvailableSpace();
                Watchdog.this.storageState = availableSpace >= 200L ? StabilityState.FINE : (availableSpace >= 100L ? StabilityState.NOT_OKAY : StabilityState.NIGHTMARE);
                Watchdog.this.databaseState = OpenCreative.getPlanetsManager().isStableConnection() ? StabilityState.FINE : (OpenCreative.getPlanetsManager().isEnabled() ? StabilityState.NOT_OKAY : StabilityState.NIGHTMARE);
                long freeMemory = Runtime.getRuntime().freeMemory() / 1000000L;
                Watchdog.this.memoryState = freeMemory >= 200L ? StabilityState.FINE : (freeMemory >= 100L ? StabilityState.NOT_OKAY : StabilityState.NIGHTMARE);
                Watchdog.this.ticksState = Watchdog.this.getTPS() >= 18.0 ? StabilityState.FINE : (Watchdog.this.getTPS() >= 13.0 ? StabilityState.NOT_OKAY : StabilityState.NIGHTMARE);
                StabilityState oldState = Watchdog.this.pluginState;
                Watchdog.this.pluginState = Watchdog.this.storageState == Watchdog.this.databaseState && Watchdog.this.databaseState == Watchdog.this.memoryState && Watchdog.this.memoryState == Watchdog.this.ticksState ? Watchdog.this.storageState : StabilityState.NIGHTMARE;
                if (Watchdog.this.getState() == StabilityState.NIGHTMARE) {
                    if (Watchdog.this.memoryState == StabilityState.NIGHTMARE) {
                        ErrorUtils.sendWarningErrorMessage("Out of memory");
                    } else {
                        OpenCreative.getPlugin().getLogger().warning("OpenCreative+ cannot continue work due to stability issues.");
                        OpenCreative.getPlugin().getLogger().warning(" TPS: " + Watchdog.this.ticksState.getLocalized() + " (" + Watchdog.this.getTPS() + "/20)");
                        OpenCreative.getPlugin().getLogger().warning(" Memory: " + Watchdog.this.memoryState.getLocalized() + " (" + freeMemory + " MB free)");
                        OpenCreative.getPlugin().getLogger().warning(" Storage: " + Watchdog.this.storageState.getLocalized() + " (" + availableSpace + " MB available)");
                        OpenCreative.getPlugin().getLogger().warning(" Database: " + Watchdog.this.databaseState.getLocalized());
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.sendActionBar(MessageUtils.getLocaleMessage("creative.stability.actionbar").replace("%memory%", Watchdog.this.memoryState.getLocalized()).replace("%storage%", Watchdog.this.storageState.getLocalized()).replace("%tps%", Watchdog.this.ticksState.getLocalized()).replace("%database%", Watchdog.this.databaseState.getLocalized()));
                        }
                    }
                    if (oldState != StabilityState.NIGHTMARE) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.unload"));
                            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                                Sounds.MAINTENANCE_START.play((Audience)onlinePlayer);
                                for (Planet planet : OpenCreative.getPlanetsManager().getPlanets()) {
                                    if (!planet.isLoaded()) continue;
                                    planet.getTerritory().unload();
                                }
                            }
                        }
                    }
                    return;
                }
                if (Watchdog.this.memoryState == StabilityState.NIGHTMARE) {
                    return;
                }
                if (Watchdog.this.databaseState != StabilityState.FINE) {
                    ErrorUtils.sendWarningErrorMessage("[Watchdog] Database connection is not stable.");
                }
                if (Watchdog.this.ticksState != StabilityState.FINE) {
                    ErrorUtils.sendWarningErrorMessage("[Watchdog] Server ticks aren't stable.");
                }
                if (Watchdog.this.storageState != StabilityState.FINE) {
                    ErrorUtils.sendWarningErrorMessage("[Watchdog] Storage cannot be accessed.");
                }
            }
        };
        this.runnable.runTaskTimerAsynchronously((Plugin)OpenCreative.getPlugin(), 20L, 200L);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    @NotNull
    public StabilityState getDatabaseState() {
        StabilityState stabilityState = this.databaseState;
        if (stabilityState == null) {
            Watchdog.$$$reportNull$$$0(0);
        }
        return stabilityState;
    }

    @Override
    @NotNull
    public StabilityState getMemoryState() {
        StabilityState stabilityState = this.memoryState;
        if (stabilityState == null) {
            Watchdog.$$$reportNull$$$0(1);
        }
        return stabilityState;
    }

    @Override
    @NotNull
    public StabilityState getStorageState() {
        StabilityState stabilityState = this.storageState;
        if (stabilityState == null) {
            Watchdog.$$$reportNull$$$0(2);
        }
        return stabilityState;
    }

    @Override
    @NotNull
    public StabilityState getTicksState() {
        StabilityState stabilityState = this.ticksState;
        if (stabilityState == null) {
            Watchdog.$$$reportNull$$$0(3);
        }
        return stabilityState;
    }

    @Override
    public String getName() {
        return "Stability Watchdog";
    }

    public long getAvailableSpace() {
        return (this.getTotalSpace() - this.getUsedSpace()) / 1000000L;
    }

    public long getUsedSpace() {
        if (this.STORAGE_VOLUME == null) {
            return 1L;
        }
        try {
            long total = this.STORAGE_VOLUME.getTotalSpace();
            return total - this.STORAGE_VOLUME.getUsableSpace();
        }
        catch (IOException e) {
            return 1L;
        }
    }

    public double getTPS() {
        if (Bukkit.getTPS().length >= 1) {
            return Bukkit.getTPS()[0];
        }
        return 20.0;
    }

    public long getTotalSpace() {
        if (this.STORAGE_VOLUME == null) {
            return 1L;
        }
        try {
            return this.STORAGE_VOLUME.getTotalSpace();
        }
        catch (IOException e) {
            return 1L;
        }
    }

    @Override
    @NotNull
    public StabilityState getState() {
        StabilityState stabilityState = this.pluginState;
        if (stabilityState == null) {
            Watchdog.$$$reportNull$$$0(4);
        }
        return stabilityState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ua/mcchickenstudio/opencreative/managers/stability/Watchdog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTicksState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

