/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.managers.updater;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.managers.updater.Updater;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public final class HangarUpdater
implements Updater {
    private boolean updatesAvailable;
    private final String downloadUrl = "https://hangar.papermc.io/mcchickenstudio/OpenCreative";
    private final String apiUrl = "https://hangar.papermc.io/api/v1/projects/OpenCreative/latestrelease";

    @Override
    public CompletableFuture<String> checkUpdates() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        Bukkit.getAsyncScheduler().runDelayed((Plugin)OpenCreative.getPlugin(), task -> {
            try {
                HttpURLConnection connection = this.getHttpURLConnection();
                int code = connection.getResponseCode();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(code >= 400 ? connection.getErrorStream() : connection.getInputStream()));){
                    char[] buffer = new char[64];
                    int read = reader.read(buffer);
                    String response = new String(buffer, 0, Math.max(0, read));
                    int latestVersion = this.getLatestVersion(response);
                    int currentVersion = this.getCurrentVersion();
                    if (latestVersion > currentVersion) {
                        this.updatesAvailable = true;
                        OpenCreative.getPlugin().getLogger().info("A new version (" + this.getSemVer(response) + ") is available for downloading! Current: " + this.getSemVer(OpenCreative.getPlugin().getPluginMeta().getVersion()));
                        OpenCreative.getPlugin().getLogger().info("Visit this site, select latest version, read changelogs and replace OpenCreative.jar with new one.");
                        OpenCreative.getPlugin().getLogger().info("https://hangar.papermc.io/mcchickenstudio/OpenCreative");
                        future.complete(this.getSemVer(response));
                    } else {
                        this.updatesAvailable = false;
                        OpenCreative.getPlugin().getLogger().info("No updates detected, probably it's latest version :) (" + currentVersion + " - " + latestVersion + ")");
                        future.complete("");
                    }
                }
            }
            catch (Exception error) {
                this.updatesAvailable = false;
                ErrorUtils.sendDebugError("Can't check updates: https://hangar.papermc.io/api/v1/projects/OpenCreative/latestrelease", error);
                future.completeExceptionally(error);
            }
        }, 1L, TimeUnit.SECONDS);
        return future;
    }

    private HttpURLConnection getHttpURLConnection() throws IOException, URISyntaxException {
        URL requestUrl = new URI("https://hangar.papermc.io/api/v1/projects/OpenCreative/latestrelease").toURL();
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        connection.setConnectTimeout(3000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "text/plain");
        return connection;
    }

    @Override
    public boolean canBeUpdated() {
        return this.updatesAvailable;
    }

    private int getCurrentVersion() {
        String currentVersion = this.getSemVer(OpenCreative.getPlugin().getPluginMeta().getVersion());
        if (currentVersion.isEmpty()) {
            this.updatesAvailable = false;
            return 0;
        }
        String[] currentVersionSplit = currentVersion.split("\\.");
        if (currentVersionSplit.length < 2) {
            this.updatesAvailable = false;
            return 0;
        }
        String semVer = currentVersion.replaceAll("\\D", "") + (currentVersionSplit.length == 2 ? "0" : "");
        return Integer.parseInt(semVer);
    }

    private int getLatestVersion(String text) {
        try {
            String lastVersion = this.getSemVer(text);
            String[] lastVersionSplit = lastVersion.split("\\.");
            if (lastVersionSplit.length < 2) {
                this.updatesAvailable = false;
                return 0;
            }
            String semVer = lastVersion.replace(".", "") + (lastVersionSplit.length == 2 ? "0" : "");
            return Integer.parseInt(semVer);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private String getSemVer(String version) {
        return version.replaceAll("[^\\d.]", "");
    }

    @Override
    public void init() {
        Bukkit.getAsyncScheduler().runDelayed((Plugin)OpenCreative.getPlugin(), task -> this.checkUpdates(), 3L, TimeUnit.SECONDS);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return "Hangar Updater";
    }
}

