/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public abstract class AbstractListMenu<T>
extends AbstractMenu {
    private final Player player;
    private final int[] charmsBarSlots;
    private final int[] decorationSlots;
    private final int[] elementsSlots;
    private int currentPage = 1;
    protected final List<T> elements = new ArrayList<T>();

    public AbstractListMenu(Player player, String title, PlacementLayout layout) {
        this(player, title, layout.getElementsSlots(), layout.getCharmsBarSlots(), layout.getDecorationSlots());
    }

    public AbstractListMenu(Player player, String title, int[] elementsSlots, int[] charmsBarSlots, int[] decorationSlots) {
        super(6, title);
        this.player = player;
        this.elementsSlots = elementsSlots;
        this.charmsBarSlots = charmsBarSlots;
        this.decorationSlots = decorationSlots;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    protected abstract ItemStack getElementIcon(T var1);

    protected abstract void fillOtherItems();

    protected abstract void onCharmsBarClick(InventoryClickEvent var1);

    protected abstract void onElementClick(InventoryClickEvent var1);

    protected abstract List<T> getElements();

    protected void fillDecorationItems() {
        for (int slot : this.decorationSlots) {
            this.setItem(slot, this.DECORATION_PANE_ITEM);
        }
    }

    protected void fillElements(int page) {
        this.fillEmpty();
        if (!this.elements.isEmpty()) {
            List<T> content = this.getElementsFromPage(page);
            int slot = 0;
            for (T object : content) {
                this.setItem(this.elementsSlots[slot], this.getElementIcon(object));
                ++slot;
            }
        }
    }

    protected void fillEmpty() {
        for (int slot : this.elementsSlots) {
            this.setItem(slot, this.AIR_ITEM);
        }
    }

    protected List<T> getElementsFromPage(int page) {
        if (page < 1 || page > this.getPages()) {
            page = 1;
        }
        int fromIndex = (page - 1) * this.elementsSlots.length;
        int toIndex = Math.min(this.elements.size(), page * this.elementsSlots.length);
        return this.elements.subList(fromIndex, toIndex);
    }

    public final int getPages() {
        return (this.elements.size() + this.elementsSlots.length - 1) / this.elementsSlots.length;
    }

    @Override
    public void fillItems(Player player) {
        this.elements.addAll(this.getElements());
        this.fillDecorationItems();
        this.fillElements(this.getCurrentPage());
        this.fillOtherItems();
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            AbstractListMenu.$$$reportNull$$$0(0);
        }
        if (!this.isPlayerClicked(event) || !this.isClickedInMenuSlots(event)) {
            event.setCancelled(true);
            return;
        }
        if (this.isElementClicked(event.getSlot()) && this.isNotEmpty(event.getCurrentItem())) {
            this.onElementClick(event);
        } else if (ItemUtils.itemEquals(event.getCurrentItem(), this.DECORATION_ITEM)) {
            event.setCancelled(true);
        } else if (this.isCharmsBarClicked(event.getSlot()) && this.isNotEmpty(event.getCurrentItem()) && !event.getCurrentItem().equals((Object)this.DECORATION_ITEM)) {
            this.onCharmsBarClick(event);
        } else {
            event.setCancelled(true);
        }
    }

    protected void nextPage() {
        this.setCurrentPage(this.getNextPage());
        this.fillElements(this.getCurrentPage());
    }

    protected void previousPage() {
        this.setCurrentPage(this.getPreviousPage());
        this.fillElements(this.getCurrentPage());
    }

    protected Player getPlayer() {
        return this.player;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    protected int getPreviousPage() {
        int maxPagesAmount;
        int previousPage = this.getCurrentPage() - 1;
        if (previousPage > (maxPagesAmount = this.getPages()) || previousPage < 1) {
            previousPage = 1;
        }
        return previousPage;
    }

    protected int getNextPage() {
        int maxPagesAmount;
        int nextPage = this.getCurrentPage() + 1;
        if (nextPage > (maxPagesAmount = this.getPages()) || nextPage < 1) {
            nextPage = 1;
        }
        return nextPage;
    }

    private boolean isCharmsBarClicked(int clickedSlot) {
        for (int itemSlot : this.charmsBarSlots) {
            if (itemSlot != clickedSlot) continue;
            return true;
        }
        return false;
    }

    private boolean isElementClicked(int clickedSlot) {
        for (int itemSlot : this.elementsSlots) {
            if (itemSlot != clickedSlot) continue;
            return true;
        }
        return false;
    }

    protected int[] getElementsSlots() {
        return this.elementsSlots;
    }

    protected int[] getCharmsBarSlots() {
        return this.charmsBarSlots;
    }

    protected int[] getDecorationSlots() {
        return this.decorationSlots;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/menus/AbstractListMenu", "onClick"));
    }

    public static enum PlacementLayout {
        LEFT_CHARMS_BAR(new int[]{12, 13, 14, 15, 16, 21, 22, 23, 24, 25, 30, 31, 32, 33, 34, 39, 40, 41, 42, 43}, new int[]{0, 9, 18, 27, 36, 45}, new int[]{1, 10, 19, 28, 37, 46}),
        BOTTOM_CHARMS_BAR(new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34}, new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53}, new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44});

        private final int[] elementsSlots;
        private final int[] charmsBarSlots;
        private final int[] decorationSlots;

        private PlacementLayout(int[] elementsSlots, int[] charmsBarSlots, int[] decorationSlots) {
            this.elementsSlots = elementsSlots;
            this.charmsBarSlots = charmsBarSlots;
            this.decorationSlots = decorationSlots;
        }

        public int[] getCharmsBarSlots() {
            return this.charmsBarSlots;
        }

        public int[] getElementsSlots() {
            return this.elementsSlots;
        }

        public int[] getDecorationSlots() {
            return this.decorationSlots;
        }
    }
}

